/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.hotpost.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.integration.LocationIntegrationService;
import com.bxm.localnews.integration.WebTokenIntegrationService;
import com.bxm.localnews.news.config.NewsProperties;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.activity.ForumPostShareCashCounterMapper;
import com.bxm.localnews.news.domain.activity.ForumPostShareCashInfoMapper;
import com.bxm.localnews.news.hotpost.HotPostShareService;
import com.bxm.localnews.news.hotpost.msg.sender.HotPostJoinMsgSenderService;
import com.bxm.localnews.news.model.dto.hotpost.HotPostShareCashDTO;
import com.bxm.localnews.news.model.entity.activity.ForumPostShareCashCounterEntity;
import com.bxm.localnews.news.model.param.activity.ActivityPostReportParam;
import com.bxm.localnews.news.model.param.hotpost.HotPostListPageParam;
import com.bxm.localnews.news.model.param.hotpost.HotPostReportParam;
import com.bxm.localnews.news.model.vo.PostImg;
import com.bxm.localnews.news.model.vo.hotpost.HotPostCounterInfoVO;
import com.bxm.localnews.news.model.vo.hotpost.HotPostItemVO;
import com.bxm.localnews.news.model.vo.hotpost.HotPostReadDataDTO;
import com.bxm.localnews.news.model.vo.hotpost.ReadReportVO;
import com.bxm.localnews.news.util.PlaceHolderUtil;
import com.bxm.localnews.url.ProtocolFactory;
import com.bxm.localnews.vo.WebTokenVerifyVO;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.util.WebUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class HotPostShareServiceImpl
implements HotPostShareService {
    private static final Logger log = LoggerFactory.getLogger(HotPostShareServiceImpl.class);
    private static final String USER_AGENT_HEADER_KEY = "user-agent";
    private final ForumPostShareCashInfoMapper forumPostShareCashInfoMapper;
    private final ForumPostShareCashCounterMapper forumPostShareCashCounterMapper;
    private final WebTokenIntegrationService webTokenIntegrationService;
    private final RedisSetAdapter redisSetAdapter;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final LocationIntegrationService locationIntegrationService;
    private final NewsProperties newsProperties;
    private final HotPostJoinMsgSenderService hotPostJoinMsgSenderService;
    private static final String WEB_TOKEN_HEADER_KEY = "web-token";

    @Override
    public HotPostCounterInfoVO counterInfo(Long userId) {
        String currentDay = this.getSimpleDateStr(new Date());
        ForumPostShareCashCounterEntity postShareCashCounterEntity = this.forumPostShareCashCounterMapper.selectByDateAndUserId(userId, currentDay);
        HotPostCounterInfoVO resultVO = new HotPostCounterInfoVO();
        resultVO.setTotalAward(this.forumPostShareCashCounterMapper.countAwardAmount(userId, currentDay).setScale(2, RoundingMode.HALF_DOWN));
        if (Objects.isNull(postShareCashCounterEntity)) {
            resultVO.setTodayAward(BigDecimal.ZERO);
            resultVO.setTodayReadCount(Integer.valueOf(0));
            return resultVO;
        }
        resultVO.setTodayAward(postShareCashCounterEntity.getAwardAmount().setScale(2, RoundingMode.HALF_DOWN));
        resultVO.setTodayReadCount(postShareCashCounterEntity.getReadCount());
        return resultVO;
    }

    @Override
    public List<HotPostItemVO> hotPostList(HotPostListPageParam param) {
        List hotPostList = this.forumPostShareCashInfoMapper.getHotPostList(param);
        for (HotPostItemVO hotPostItemVO : hotPostList) {
            String previewImg = hotPostItemVO.getPreviewImg();
            if (StringUtils.isNotBlank((CharSequence)previewImg)) {
                List postImgList = JSON.parseArray((String)previewImg, PostImg.class);
                if (CollectionUtils.isNotEmpty((Collection)postImgList)) {
                    hotPostItemVO.setPreviewImg(((PostImg)postImgList.get(0)).getImgUrl());
                } else {
                    hotPostItemVO.setPreviewImg(this.newsProperties.getDefaultShareCover());
                }
            }
            LocationDTO locationInfo = this.locationIntegrationService.getLocationByGeocode(param.getAreaCode());
            hotPostItemVO.setShareUrl(ProtocolFactory.forumPost().outer().postId(hotPostItemVO.getPostId()).userId(param.getUserId()).areaCode(param.getAreaCode()).cityName(locationInfo.getName()).build());
            if (hotPostItemVO.getShareCount() == 0) {
                hotPostItemVO.setSentAward(BigDecimal.ZERO);
            }
            if (hotPostItemVO.getShareCount() > 0) {
                BigDecimal randomAward = (BigDecimal)this.redisHashMapAdapter.get(this.buildHotPostRandomAwardKey(), String.valueOf(hotPostItemVO.getPostId()), BigDecimal.class);
                hotPostItemVO.setSentAward(hotPostItemVO.getSentAward().multiply(BigDecimal.valueOf(2L)).add(Objects.isNull(randomAward) ? BigDecimal.ZERO : randomAward).setScale(2, RoundingMode.HALF_DOWN));
            }
            hotPostItemVO.setMyAward(hotPostItemVO.getMyAward().setScale(2, RoundingMode.HALF_DOWN));
            if (StringUtils.isBlank((CharSequence)hotPostItemVO.getPostTitle())) {
                hotPostItemVO.setPostDesc(hotPostItemVO.getPostTextField());
                hotPostItemVO.setPostTitle(hotPostItemVO.getPostTextField());
            } else {
                hotPostItemVO.setPostDesc(hotPostItemVO.getPostTitle());
                hotPostItemVO.setPostTitle(hotPostItemVO.getPostTitle());
            }
            hotPostItemVO.setPostTitle(PlaceHolderUtil.replace((String)hotPostItemVO.getPostTitle(), (String)"areaname", (String)locationInfo.getName(), (String)"\u672c\u5730"));
            hotPostItemVO.setPostDesc(PlaceHolderUtil.replace((String)hotPostItemVO.getPostDesc(), (String)"areaname", (String)locationInfo.getName(), (String)"\u672c\u5730"));
        }
        return hotPostList;
    }

    @Override
    public ReadReportVO reportRead(HotPostReportParam param, HttpServletRequest request) {
        WebTokenVerifyVO webTokenVerifyVO = this.checkExpiredToken(request);
        if (webTokenVerifyVO.getExpired().booleanValue()) {
            return ReadReportVO.builder().webTokenExpired(Boolean.valueOf(true)).build();
        }
        if (Objects.isNull(param.getShareUserId())) {
            log.warn("\u70ed\u6587\u5e16\u5b50\u5206\u4eab\u7528\u6237id\u4e3a\u7a7a\uff0c\u5e16\u5b50id\uff1a{}", (Object)param.getPostId());
            return ReadReportVO.builder().webTokenExpired(Boolean.valueOf(false)).build();
        }
        log.info("\u7528\u6237\u53c2\u4e0e\u70ed\u6587\u5206\u4eab\uff1a{}", (Object)JSON.toJSONString((Object)webTokenVerifyVO));
        if (this.checkUserTodayJoin(webTokenVerifyVO.getOpenid())) {
            log.info("\u7528\u6237\u9996\u6b21\u53c2\u4e0e\u70ed\u6587\u5206\u4eab\uff1a{}", (Object)webTokenVerifyVO.getOpenid());
            HotPostReadDataDTO hotPostReadDataDTO = HotPostReadDataDTO.builder().openid(webTokenVerifyVO.getOpenid()).postId(param.getPostId()).reportDate(new Date()).shareUserId(param.getShareUserId()).ip(WebUtils.getIpAddr((HttpServletRequest)request)).userAgent(request.getHeader(USER_AGENT_HEADER_KEY)).areaCode(param.getAreaCode()).build();
            this.hotPostJoinMsgSenderService.send(hotPostReadDataDTO);
        }
        return ReadReportVO.builder().webTokenExpired(Boolean.valueOf(false)).build();
    }

    private String getSimpleDateNoSeparatorStr(Date now) {
        return ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(now);
    }

    private boolean checkUserTodayJoin(String openid) {
        return this.redisSetAdapter.add(this.buildJoinSharePostUserKey(this.getSimpleDateNoSeparatorStr(new Date())), new Object[]{openid}) > 0L;
    }

    public WebTokenVerifyVO checkExpiredToken(HttpServletRequest request) {
        String webToken = request.getHeader(WEB_TOKEN_HEADER_KEY);
        if (StringUtils.isBlank((CharSequence)webToken)) {
            return WebTokenVerifyVO.builder().expired(Boolean.valueOf(true)).build();
        }
        WebTokenVerifyVO verifyResultVO = this.webTokenIntegrationService.verifyWebToken(webToken);
        if (Objects.isNull(verifyResultVO)) {
            return WebTokenVerifyVO.builder().expired(Boolean.valueOf(true)).build();
        }
        return verifyResultVO;
    }

    @Override
    public List<HotPostShareCashDTO> getCashInfo() {
        return this.forumPostShareCashCounterMapper.getCashInfo();
    }

    @Override
    public HotPostShareCashDTO getUserCashInfo(Long userId) {
        HotPostShareCashDTO userCashInfo = this.forumPostShareCashCounterMapper.getUserCashInfo(userId);
        if (Objects.isNull(userCashInfo)) {
            HotPostShareCashDTO emptyShareCashDTO = new HotPostShareCashDTO();
            emptyShareCashDTO.setUserId(userId);
            emptyShareCashDTO.setPostShareCash(BigDecimal.ZERO);
            return emptyShareCashDTO;
        }
        return userCashInfo;
    }

    @Override
    public void reportJoinActivity(ActivityPostReportParam param) {
        this.redisSetAdapter.add(this.buildJoinActivityUserKey(param.getPostId()), new Object[]{param.getUserId()});
    }

    private KeyGenerator buildJoinActivityUserKey(Long postId) {
        return RedisConfig.ACTIVITY_POST_JOIN_USER_KEY.copy().appendKey((Object)postId);
    }

    private KeyGenerator buildJoinSharePostUserKey(String simpleDateStr) {
        return RedisConfig.TODAY_JOIN_SHARE_POST_USER_KEY.copy().appendKey((Object)simpleDateStr);
    }

    private KeyGenerator buildHotPostRandomAwardKey() {
        return RedisConfig.HOT_POST_INIT_RANDOM_AWARD_KEY.copy();
    }

    private String getSimpleDateStr(Date now) {
        return ((DateFormat)DateUtils.DATE_FORMAT_THREAD_LOCAL.get()).format(now);
    }

    public HotPostShareServiceImpl(ForumPostShareCashInfoMapper forumPostShareCashInfoMapper, ForumPostShareCashCounterMapper forumPostShareCashCounterMapper, WebTokenIntegrationService webTokenIntegrationService, RedisSetAdapter redisSetAdapter, RedisHashMapAdapter redisHashMapAdapter, LocationIntegrationService locationIntegrationService, NewsProperties newsProperties, HotPostJoinMsgSenderService hotPostJoinMsgSenderService) {
        this.forumPostShareCashInfoMapper = forumPostShareCashInfoMapper;
        this.forumPostShareCashCounterMapper = forumPostShareCashCounterMapper;
        this.webTokenIntegrationService = webTokenIntegrationService;
        this.redisSetAdapter = redisSetAdapter;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.locationIntegrationService = locationIntegrationService;
        this.newsProperties = newsProperties;
        this.hotPostJoinMsgSenderService = hotPostJoinMsgSenderService;
    }
}

