/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.hotpost.impl;

import com.bxm.localnews.integration.LocationIntegrationService;
import com.bxm.localnews.news.config.ForumProperties;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.activity.ForumPostActivityMapper;
import com.bxm.localnews.news.domain.activity.ForumPostShareCashInfoMapper;
import com.bxm.localnews.news.hotpost.ShareCashPostService;
import com.bxm.localnews.news.model.dto.hotpost.ShareCashPostItemDTO;
import com.bxm.localnews.news.model.entity.activity.ForumPostActivityEntity;
import com.bxm.localnews.news.model.entity.activity.ForumPostShareCashInfoEntity;
import com.bxm.localnews.news.model.param.hotpost.ShareCashPostAwardParam;
import com.bxm.localnews.news.model.param.hotpost.ShareCashPostOrderParam;
import com.bxm.localnews.news.model.param.hotpost.ShareCashPostPageParam;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ShareCashPostServiceImpl
implements ShareCashPostService {
    private static final Logger log = LoggerFactory.getLogger(ShareCashPostServiceImpl.class);
    private ForumPostShareCashInfoMapper forumPostShareCashInfoMapper;
    private ForumPostActivityMapper postActivityMapper;
    private SequenceCreater sequenceCreater;
    private ForumProperties forumProperties;
    private LocationIntegrationService locationIntegrationService;
    private RedisStringAdapter redisStringAdapter;

    @Override
    public Message changeOrder(ShareCashPostOrderParam param) {
        Preconditions.checkArgument((param != null ? 1 : 0) != 0);
        ForumPostShareCashInfoEntity updateEntity = new ForumPostShareCashInfoEntity();
        updateEntity.setPostId(param.getId());
        updateEntity.setModifyTime(new Date());
        updateEntity.setOrder(param.getOrder());
        return Message.build((int)this.forumPostShareCashInfoMapper.updateByPrimaryKeySelective(updateEntity));
    }

    @Override
    public Message changeStatus(Long postId, Integer status) {
        ForumPostShareCashInfoEntity existsPost = this.getDetail(postId);
        ForumPostActivityEntity existActivityPost = this.postActivityMapper.selectByPostId(postId);
        if (Objects.equals(status, 1)) {
            if (existsPost.getAmount().compareTo(existsPost.getUsedAmount()) <= 0) {
                return Message.build((boolean)false, (String)"\u5269\u4f59\u53d1\u653e\u91d1\u989d\u4e0d\u8db3\uff0c\u65e0\u6cd5\u91cd\u542f\u6d3b\u52a8");
            }
            if (Objects.nonNull(existActivityPost) && Objects.equals(existActivityPost.getStatus(), 0)) {
                return Message.build((boolean)false, (String)"\u6d3b\u52a8\u5e16\u5b50\u4e3a\u4e0b\u67b6\u72b6\u6001\uff0c\u5373\u4f7f\u5728\u6709\u6548\u671f\u4e5f\u65e0\u6cd5\u5c06\u70ed\u6587\u4e0a\u67b6");
            }
            if (null != existsPost.getAwardEndTime() && DateUtils.before((Date)existsPost.getAwardEndTime(), (Date)new Date())) {
                return Message.build((boolean)false, (String)"\u6d3b\u52a8\u5df2\u8fc7\u4e86\u622a\u6b62\u6709\u6548\u671f\uff0c\u65e0\u6cd5\u5f00\u542f");
            }
        }
        ForumPostShareCashInfoEntity updateEntity = new ForumPostShareCashInfoEntity();
        updateEntity.setPostId(postId);
        updateEntity.setModifyTime(new Date());
        updateEntity.setStatus(status);
        return Message.build((int)this.forumPostShareCashInfoMapper.updateByPrimaryKeySelective(updateEntity));
    }

    @Override
    public Message changeAwardTime(ShareCashPostAwardParam param) {
        Preconditions.checkArgument((param != null ? 1 : 0) != 0);
        Date awardStartTime = param.getAwardStartTime();
        Date awardEndTime = param.getAwardEndTime();
        if (Objects.nonNull(awardStartTime) && Objects.nonNull(awardEndTime) && DateUtils.after((Date)awardStartTime, (Date)awardEndTime)) {
            return Message.build((boolean)false, (String)"\u70ed\u6587\u6709\u6548\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u65f6\u95f4");
        }
        ForumPostShareCashInfoEntity updateEntity = new ForumPostShareCashInfoEntity();
        updateEntity.setPostId(param.getId());
        updateEntity.setModifyTime(new Date());
        updateEntity.setAwardStartTime(param.getAwardStartTime());
        updateEntity.setAwardEndTime(param.getAwardEndTime());
        if (Objects.nonNull(awardEndTime) && DateUtils.before((Date)awardEndTime, (Date)new Date())) {
            updateEntity.setStatus(Integer.valueOf(0));
        }
        if (DateUtils.after((Date)awardStartTime, (Date)new Date())) {
            updateEntity.setStatus(Integer.valueOf(0));
        }
        return Message.build((int)this.forumPostShareCashInfoMapper.updateAwardTime(updateEntity));
    }

    @Override
    public ForumPostShareCashInfoEntity getDetail(Long postId) {
        return this.forumPostShareCashInfoMapper.getByPostId(postId);
    }

    @Override
    public PageWarper<ShareCashPostItemDTO> queryByPage(ShareCashPostPageParam param) {
        List shareCashPosts = this.forumPostShareCashInfoMapper.queryByPage(param);
        for (ShareCashPostItemDTO post : shareCashPosts) {
            if (StringUtils.isNotEmpty((CharSequence)post.getAreaDetail())) {
                String[] areaCodeArray = post.getAreaDetail().split(",");
                post.setAreaDetail(this.locationIntegrationService.batchGetDetailJson(areaCodeArray));
            }
            if (Objects.equals(post.getPostType(), "1")) {
                post.setPostType("\u6d3b\u52a8\u5e16\u5b50");
                continue;
            }
            post.setPostType("\u793e\u533a\u5e16\u5b50");
        }
        return new PageWarper(shareCashPosts);
    }

    @Override
    public Message save(ForumPostShareCashInfoEntity entity) {
        int result = 0;
        if (null == entity.getId()) {
            entity.setId(this.sequenceCreater.nextLongId());
            entity.setCreateTime(new Date());
            entity.setOrder(Integer.valueOf(0));
            entity.setStatus(Integer.valueOf(Objects.isNull(entity.getStatus()) ? 1 : entity.getStatus()));
            entity.setUsedAmount(BigDecimal.ZERO);
            entity.setAward(this.forumProperties.getShareCashAward());
            result = this.forumPostShareCashInfoMapper.insert(entity);
            this.redisStringAdapter.set(this.buildPostAwardKey(entity.getPostId()), (Object)entity.getAmount());
        } else {
            ForumPostShareCashInfoEntity beforeInfo = this.forumPostShareCashInfoMapper.selectByPrimaryKey(entity.getId());
            log.info("\u70ed\u6587\u5956\u52b1\u91d1\u989d\uff1a\u66f4\u65b0\u524d\u7684\u503c: {}, \u66f4\u65b0\u540e\u7684\u503c\uff1a{}", (Object)beforeInfo.getAmount(), (Object)entity.getAmount());
            log.info("\u66f4\u65b0\u70ed\u6587\u5e16\u5b50\u72b6\u6001\uff1a\u66f4\u65b0\u524d\u7684\u503c: {}, \u66f4\u65b0\u540e\u7684\u503c\uff1a{}", (Object)beforeInfo.getStatus(), (Object)entity.getStatus());
            BigDecimal changeAmount = entity.getAmount().subtract(beforeInfo.getAmount());
            if (Boolean.FALSE.equals(this.redisStringAdapter.hasKey(this.buildPostAwardKey(entity.getPostId())))) {
                this.loadHotPostShareDb(entity.getPostId());
            }
            if (changeAmount.compareTo(BigDecimal.ZERO) >= 0) {
                this.redisStringAdapter.increment(this.buildPostAwardKey(entity.getPostId()), Math.abs(changeAmount.doubleValue()));
                entity.setModifyTime(new Date());
                result = this.forumPostShareCashInfoMapper.updateByPrimaryKeySelective(entity);
                log.info("\u70ed\u6587\u5956\u52b1\u91d1\u989d\u66f4\u65b0\u6210\u529f\uff0c\u589e\u52a0\u6216\u4fdd\u6301\u91d1\u989d\u4e0d\u53d8\uff1a\u66f4\u65b0\u524d\u7684\u503c: {}, \u66f4\u65b0\u540e\u7684\u503c\uff1a{}", (Object)beforeInfo.getAmount(), (Object)entity.getAmount());
            }
            if (changeAmount.compareTo(BigDecimal.ZERO) < 0) {
                log.info("\u70ed\u6587\u5956\u52b1\u91d1\u989d\u66f4\u65b0\u6210\u529f\uff0c\u51cf\u5c11\u5956\u91d1\u91d1\u989d\uff1a{}", (Object)Math.abs(changeAmount.doubleValue()));
                if (entity.getAmount().compareTo(beforeInfo.getUsedAmount()) < 0) {
                    entity.setModifyTime(new Date());
                    entity.setAmount(null);
                    result = this.forumPostShareCashInfoMapper.updateByPrimaryKeySelective(entity);
                    log.warn("\u5e16\u5b50[{}]\u7684\u5956\u52b1\u91d1\u989d[{}]\u6bd4\u5df2\u53d1\u653e\u91d1\u989d[{}]\u5c11\uff0c\u4e0d\u66f4\u65b0\u91d1\u989d", new Object[]{entity.getPostId(), entity.getAmount(), entity.getUsedAmount()});
                    return Message.build((int)result);
                }
                if (this.redisStringAdapter.decrement(this.buildPostAwardKey(entity.getPostId()), Math.abs(changeAmount.doubleValue())) >= 0.0) {
                    entity.setModifyTime(new Date());
                    result = this.forumPostShareCashInfoMapper.updateByPrimaryKeySelective(entity);
                    log.info("\u70ed\u6587\u5956\u52b1\u91d1\u989d\u66f4\u65b0\u6210\u529f\uff0c\u51cf\u5c11\u5956\u91d1\u91d1\u989d\uff1a\u66f4\u65b0\u524d\u7684\u503c: {}, \u66f4\u65b0\u540e\u7684\u503c\uff1a{}", (Object)beforeInfo.getAmount(), (Object)entity.getAmount());
                } else {
                    this.redisStringAdapter.increment(this.buildPostAwardKey(entity.getPostId()), Math.abs(changeAmount.doubleValue()));
                    log.error("\u70ed\u6587\u5206\u4eab\u5956\u91d1\u91d1\u989d\u4e0d\u8db3\uff0c\u5e16\u5b50id\uff1a{}", (Object)entity.getPostId());
                    return Message.build((boolean)false, (String)"\u70ed\u6587\u5206\u4eab\u5956\u91d1\u91d1\u989d\u4e0d\u8db3");
                }
            }
        }
        return Message.build((int)result);
    }

    @Override
    public void setExpired() {
        Date phaseTime = DateUtils.addField((Date)new Date(), (int)10, (int)-1);
        List expiredPostList = this.forumPostShareCashInfoMapper.getActiveAndExpiredPost(phaseTime);
        for (ForumPostShareCashInfoEntity entity : expiredPostList) {
            this.changeStatus(entity.getPostId(), 0);
        }
    }

    @Override
    public void setStart() {
        List startPostList = this.forumPostShareCashInfoMapper.getOfflineAndExpiredPost();
        for (ForumPostShareCashInfoEntity entity : startPostList) {
            this.changeStatus(entity.getPostId(), 1);
        }
    }

    private KeyGenerator buildPostAwardKey(Long postId) {
        return RedisConfig.SHARE_POST_AWARD_KEY.copy().appendKey((Object)postId);
    }

    private void loadHotPostShareDb(Long postId) {
        ForumPostShareCashInfoEntity shareCashInfoEntity = this.forumPostShareCashInfoMapper.getByPostId(postId);
        this.redisStringAdapter.set(this.buildPostAwardKey(postId), (Object)shareCashInfoEntity.getAmount().subtract(shareCashInfoEntity.getUsedAmount()));
    }

    public ShareCashPostServiceImpl(ForumPostShareCashInfoMapper forumPostShareCashInfoMapper, ForumPostActivityMapper postActivityMapper, SequenceCreater sequenceCreater, ForumProperties forumProperties, LocationIntegrationService locationIntegrationService, RedisStringAdapter redisStringAdapter) {
        this.forumPostShareCashInfoMapper = forumPostShareCashInfoMapper;
        this.postActivityMapper = postActivityMapper;
        this.sequenceCreater = sequenceCreater;
        this.forumProperties = forumProperties;
        this.locationIntegrationService = locationIntegrationService;
        this.redisStringAdapter = redisStringAdapter;
    }
}

