/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.list.filter;

import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.detail.context.ForumPostDetailContext;
import com.bxm.localnews.news.detail.context.PostDetailOriginalParam;
import com.bxm.localnews.news.detail.filter.BaseInfoFillFilter;
import com.bxm.localnews.news.detail.filter.CommentCalFilter;
import com.bxm.localnews.news.detail.filter.HotReplayFillFilter;
import com.bxm.localnews.news.detail.filter.ImageFillFilter;
import com.bxm.localnews.news.detail.filter.PlaceHolderFilter;
import com.bxm.localnews.news.detail.filter.RelationFillFilter;
import com.bxm.localnews.news.detail.filter.TagSwitchFilter;
import com.bxm.localnews.news.detail.filter.TopicFillFilter;
import com.bxm.localnews.news.detail.helper.ForumPostImageHelper;
import com.bxm.localnews.news.enums.DisplayAreaEnum;
import com.bxm.localnews.news.factory.ExtendFactory;
import com.bxm.localnews.news.model.param.ForumPostFillContext;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.newidea.component.annotations.FilterBean;
import com.bxm.newidea.component.filter.FilterChainExecutor;
import com.bxm.newidea.component.filter.IFilter;
import java.util.Collection;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;

@FilterBean(group="POST_LIST_FILTER")
public class PostInfoFillFilter
implements IFilter<ForumPostFillContext> {
    @Resource
    private FilterChainExecutor filterChainExecutor;
    @Resource
    private ForumPostImageHelper forumPostImageHelper;

    public void doFilter(ForumPostFillContext context) {
        context.getData().forEach(forumPostVo -> {
            forumPostVo.setPostContentImgList(forumPostVo.getPostImgList());
            PostDetailOriginalParam param = new PostDetailOriginalParam(forumPostVo.getId());
            param.setUserId(context.getUserId());
            param.setAreaCode(context.getAreaCode());
            ForumPostDetailContext detailContext = new ForumPostDetailContext(param);
            detailContext.setPostInfo((ForumPostVo)forumPostVo);
            detailContext.setLocation(context.getLocation());
            detailContext.choiceFilter(BaseInfoFillFilter.class).choiceFilter(ImageFillFilter.class).choiceFilter(TopicFillFilter.class).choiceFilter(RelationFillFilter.class).choiceFilter(CommentCalFilter.class).choiceFilter(TagSwitchFilter.class).choiceFilter(PlaceHolderFilter.class);
            if (context.isLoadHotReplay()) {
                detailContext.choiceFilter(HotReplayFillFilter.class);
            }
            this.filterChainExecutor.doFilter("POST_DETAIL_FILTER", (Object)detailContext);
            if (context.isFillTitle()) {
                forumPostVo.setTitle(ExtendFactory.getTitle((String)forumPostVo.getTitle(), (String)forumPostVo.getTextField()));
            }
            if (DisplayAreaEnum.OTHER.equals((Object)context.getDisplayArea())) {
                this.forumPostImageHelper.exchangeDetailPost((ForumPostVo)forumPostVo);
            } else if (DisplayAreaEnum.INDEX.equals((Object)context.getDisplayArea())) {
                this.forumPostImageHelper.exchangeCoverPost((ForumPostVo)forumPostVo);
            } else if (DisplayAreaEnum.IM.equals((Object)context.getDisplayArea())) {
                this.forumPostImageHelper.exchangeCoverPost((ForumPostVo)forumPostVo);
            }
            forumPostVo.setLeftRelyNum(Integer.valueOf(CollectionUtils.isNotEmpty((Collection)forumPostVo.getReplyInfo()) ? forumPostVo.getCommentCount() - forumPostVo.getReplyInfo().size() : forumPostVo.getCommentCount()));
        });
    }

    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }
}

