/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.list.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.integration.LocationIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.news.config.ForumProperties;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.enums.DisplayAreaEnum;
import com.bxm.localnews.news.list.PostListService;
import com.bxm.localnews.news.model.param.FollowUserForumsParam;
import com.bxm.localnews.news.model.param.ForumPostFillContext;
import com.bxm.localnews.news.model.param.ForumPostListUserQueryParam;
import com.bxm.localnews.news.model.param.HomePagePostParam;
import com.bxm.localnews.news.model.vo.FollowUserForumPostVo;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.util.FormPostContentUtil;
import com.bxm.localnews.news.util.ListUtil;
import com.bxm.newidea.component.filter.FilterChainExecutor;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class PostListServiceImpl
implements PostListService {
    private static final Logger log = LoggerFactory.getLogger(PostListServiceImpl.class);
    private LocationIntegrationService locationIntegrationService;
    private FilterChainExecutor filterChainExecutor;
    private ForumPostMapper forumPostMapper;
    private RedisStringAdapter redisStringAdapter;
    private UserIntegrationService userIntegrationService;
    private ForumProperties forumProperties;

    @Override
    public void fillExtInfo(ForumPostFillContext context) {
        if (CollectionUtils.isEmpty((Collection)context.getData())) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)context.getAreaCode()) && null == context.getLocation()) {
            context.setLocation(this.locationIntegrationService.getLocationByGeocode(context.getAreaCode()));
        }
        this.filterChainExecutor.parallelDoFilter("POST_LIST_FILTER", (Object)context);
    }

    @Override
    public PageWarper<ForumPostVo> getHomePagePostList(HomePagePostParam param) {
        PageWarper forumPostWarper = new PageWarper(this.forumPostMapper.listHomePagePostList(param));
        List forumPostVoList = forumPostWarper.getList();
        if (CollectionUtils.isNotEmpty((Collection)forumPostVoList)) {
            ForumPostFillContext context = ForumPostFillContext.builder().data(forumPostVoList).userId(param.getUserId()).areaCode(param.getAreaCode()).fillTitle(false).displayArea(DisplayAreaEnum.OTHER).build();
            this.fillExtInfo(context);
        }
        return forumPostWarper;
    }

    @Override
    public List<ForumPostVo> getRewardPostList() {
        String rewardList = this.redisStringAdapter.getString(RedisConfig.FORUM_POST_REWARD_LIST.copy());
        List forumPostVoList = StringUtils.isBlank((CharSequence)rewardList) ? this.forumPostMapper.getRewardPostList(Integer.valueOf(50)) : JSON.parseArray((String)rewardList, ForumPostVo.class);
        if (CollectionUtils.isNotEmpty((Collection)forumPostVoList)) {
            forumPostVoList.forEach(e -> FormPostContentUtil.replace(e, null));
        }
        return forumPostVoList;
    }

    @Override
    public List<ForumPostVo> getPostListByIds(String postIds) {
        List postIdList = ListUtil.convertStringToList((String)postIds);
        if (CollectionUtils.isEmpty((Collection)postIdList)) {
            return null;
        }
        List forumPostVoList = this.forumPostMapper.listPostByIds(postIdList);
        if (CollectionUtils.isNotEmpty((Collection)forumPostVoList)) {
            ForumPostFillContext context = ForumPostFillContext.builder().data(forumPostVoList).userId(null).areaCode(null).fillTitle(false).displayArea(DisplayAreaEnum.OTHER).build();
            this.fillExtInfo(context);
        }
        return forumPostVoList;
    }

    @Override
    public FollowUserForumPostVo getFollowedUserForumList(FollowUserForumsParam param) {
        if (Objects.isNull(param.getUserId())) {
            return new FollowUserForumPostVo();
        }
        FollowUserForumPostVo result = new FollowUserForumPostVo();
        ArrayList followedUserIds = this.userIntegrationService.getUserFollowedUserIds(param.getUserId());
        if (CollectionUtils.isEmpty((Collection)followedUserIds)) {
            return new FollowUserForumPostVo();
        }
        param.setFollowedUserIds(CollectionUtils.isNotEmpty(followedUserIds = followedUserIds.stream().filter(s -> s > 0L).collect(Collectors.toList())) ? followedUserIds : Lists.newArrayList((Object[])new Long[]{0L}));
        PageWarper pageWarper = new PageWarper(this.forumPostMapper.getForumListByFollowedUserIds(param));
        ForumPostFillContext context = ForumPostFillContext.builder().data(pageWarper.getList()).userId(param.getUserId()).fillTitle(false).loadHotReplay(true).displayArea(DisplayAreaEnum.OTHER).build();
        this.fillExtInfo(context);
        result.setShowFollowGuide(Integer.valueOf(followedUserIds.size() < this.forumProperties.getGuideShowFollowedNum() ? 1 : 0));
        result.setFollowGuideDesc(this.forumProperties.getGuideToFollowedText());
        result.setList(pageWarper);
        return result;
    }

    @Override
    public PageWarper<ForumPostVo> listForumPostByUser(ForumPostListUserQueryParam param) {
        PageWarper forumPostWarper = new PageWarper();
        if (null == param || null == param.getType()) {
            return null;
        }
        if (1 == param.getType()) {
            forumPostWarper = new PageWarper(this.forumPostMapper.listPostByIdsInUser(param));
            List forumPostVoList = forumPostWarper.getList();
            if (CollectionUtils.isNotEmpty((Collection)forumPostVoList)) {
                ForumPostFillContext context = ForumPostFillContext.builder().data(forumPostVoList).userId(param.getUserId()).areaCode(null).fillTitle(false).displayArea(DisplayAreaEnum.OTHER).build();
                this.fillExtInfo(context);
            }
        } else if (2 == param.getType()) {
            forumPostWarper = new PageWarper(this.forumPostMapper.getCollectPostList(param));
            List forumPostVoList = forumPostWarper.getList();
            if (CollectionUtils.isNotEmpty((Collection)forumPostVoList)) {
                ForumPostFillContext context = ForumPostFillContext.builder().data(forumPostVoList).userId(param.getUserId()).areaCode(null).fillTitle(true).displayArea(DisplayAreaEnum.OTHER).build();
                this.fillExtInfo(context);
            }
        } else if (3 == param.getType()) {
            HomePagePostParam postParam = new HomePagePostParam();
            postParam.setTargetUserId(param.getUserId());
            postParam.setUserId(param.getUserId());
            BeanUtils.copyProperties((Object)param, (Object)postParam);
            forumPostWarper = new PageWarper(this.forumPostMapper.listHomePagePostList(postParam));
            List forumPostVoList = forumPostWarper.getList();
            if (CollectionUtils.isNotEmpty((Collection)forumPostVoList)) {
                ForumPostFillContext context = ForumPostFillContext.builder().data(forumPostVoList).userId(param.getUserId()).areaCode(null).fillTitle(false).displayArea(DisplayAreaEnum.IM).build();
                this.fillExtInfo(context);
            }
        }
        return forumPostWarper;
    }

    public PostListServiceImpl(LocationIntegrationService locationIntegrationService, FilterChainExecutor filterChainExecutor, ForumPostMapper forumPostMapper, RedisStringAdapter redisStringAdapter, UserIntegrationService userIntegrationService, ForumProperties forumProperties) {
        this.locationIntegrationService = locationIntegrationService;
        this.filterChainExecutor = filterChainExecutor;
        this.forumPostMapper = forumPostMapper;
        this.redisStringAdapter = redisStringAdapter;
        this.userIntegrationService = userIntegrationService;
        this.forumProperties = forumProperties;
    }
}

