/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.note.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.news.config.ForumProperties;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.domain.MixedRecommendPoolMapper;
import com.bxm.localnews.news.enums.PostStatusEnum;
import com.bxm.localnews.news.enums.UrlCategoryEnum;
import com.bxm.localnews.news.enums.UrlPositionEnum;
import com.bxm.localnews.news.enums.UrlTypeEnum;
import com.bxm.localnews.news.factory.IUrlFactory;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.model.vo.NotePublishVo;
import com.bxm.localnews.news.model.vo.NoteVo;
import com.bxm.localnews.news.note.NoteService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class NoteServiceImpl
extends BaseService
implements NoteService {
    private static final Logger log = LoggerFactory.getLogger(NoteServiceImpl.class);
    @Resource
    private ForumPostMapper forumPostMapper;
    @Resource
    private MixedRecommendPoolMapper mixedRecommendPoolMapper;
    @Resource
    private ForumProperties forumProperties;
    @Resource
    private RedisStringAdapter redisStringAdapter;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;
    @Resource
    private UserIntegrationService userIntegrationService;
    @Resource
    private IUrlFactory iUrlFactory;

    @Override
    public Message delete(Long noteId) {
        Long userId = this.forumPostMapper.getUserIdByPostId(noteId);
        ForumPostVo forumPostVo = new ForumPostVo();
        forumPostVo.setId(noteId);
        forumPostVo.setStatus(Integer.valueOf(PostStatusEnum.USER_DELETE.getCode()));
        this.forumPostMapper.updateByPrimaryKeySelective(forumPostVo);
        this.mixedRecommendPoolMapper.deleteMixRecommandPoolById(noteId);
        this.userIntegrationService.addPostReplyNum(userId, Integer.valueOf(2));
        this.removeCache(userId);
        return Message.build((boolean)true);
    }

    @Override
    public NotePublishVo getNotePublish(Long userId) {
        NotePublishVo notePublishVo = new NotePublishVo();
        notePublishVo.setPublishNum(this.getPublishNum(userId));
        notePublishVo.setGuidance(this.forumProperties.getNoteGuidance());
        notePublishVo.setCarouselList(this.forumPostMapper.getCarouselNoteList());
        return notePublishVo;
    }

    @Override
    public List<NoteVo> batchGetUserNote(List<Long> userIdList, Long currentUserId) {
        List noteVoList;
        ArrayList<NoteVo> userNoteVoList = new ArrayList<NoteVo>();
        if (CollectionUtils.isEmpty(userIdList)) {
            return userNoteVoList;
        }
        boolean hasCurrent = false;
        if (currentUserId != null && userIdList.contains(currentUserId)) {
            userIdList.remove(currentUserId);
            hasCurrent = true;
        }
        if (CollectionUtils.isNotEmpty(userIdList)) {
            Set userIds = userIdList.stream().map(Object::toString).collect(Collectors.toSet());
            List userNoteCache = this.redisHashMapAdapter.multiGet(RedisConfig.USER_FORUM_NOTE, userIds, String.class);
            log.debug("\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u7528\u6237\u5c0f\u7eb8\u6761\u6570\u636e\uff1a" + JSON.toJSONString((Object)userNoteCache));
            if (CollectionUtils.isNotEmpty((Collection)userNoteCache)) {
                userNoteCache.forEach(userCache -> {
                    List noteVoList = JSON.parseArray((String)userCache, NoteVo.class);
                    if (CollectionUtils.isNotEmpty((Collection)noteVoList)) {
                        userIdList.remove(((NoteVo)noteVoList.get(0)).getUserId());
                        userNoteVoList.add((NoteVo)noteVoList.get(0));
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(userIdList)) {
                userNoteVoList.addAll(this.batchLoadUserNoteVoToRedis(userIdList, true));
            }
        }
        if (hasCurrent && CollectionUtils.isNotEmpty((Collection)(noteVoList = this.forumPostMapper.batchGetUserNotes(Collections.singletonList(currentUserId), Integer.valueOf(1))))) {
            userNoteVoList.add((NoteVo)noteVoList.get(0));
        }
        userNoteVoList.forEach(userNote -> this.completeNoteInfo((NoteVo)userNote, currentUserId));
        log.debug("\u8fd4\u56de\u7528\u6237\u5c0f\u7eb8\u6761\uff1a" + JSON.toJSONString(userNoteVoList));
        return userNoteVoList;
    }

    @Override
    public void cacheUserNote(Date startTime) {
        List userIdList = this.forumPostMapper.getUpdatedUser(startTime);
        this.batchLoadUserNoteVoToRedis(userIdList, true);
    }

    @Override
    public void removeCache(Long userId) {
        if (null != userId) {
            this.redisHashMapAdapter.remove(RedisConfig.USER_FORUM_NOTE, new String[]{userId.toString()});
        }
    }

    @Override
    public List<NoteVo> getUserNoteList(Long userId) {
        List noteVoList;
        if (null == userId) {
            return new ArrayList<NoteVo>();
        }
        String userNoteCache = (String)this.redisHashMapAdapter.get(RedisConfig.USER_FORUM_NOTE, userId.toString(), String.class);
        if (StringUtils.isNotBlank((String)userNoteCache) && CollectionUtils.isNotEmpty((Collection)(noteVoList = JSON.parseArray((String)userNoteCache, NoteVo.class)))) {
            return noteVoList;
        }
        return this.batchLoadUserNoteVoToRedis(Collections.singletonList(userId), false);
    }

    private List<NoteVo> batchLoadUserNoteVoToRedis(List<Long> userIdList, boolean getFirst) {
        ArrayList<NoteVo> resultList = new ArrayList<NoteVo>();
        if (CollectionUtils.isEmpty(userIdList)) {
            return resultList;
        }
        List noteList = this.forumPostMapper.batchGetUserNotes(userIdList, Integer.valueOf(0));
        if (CollectionUtils.isEmpty((Collection)noteList)) {
            return resultList;
        }
        Map<Long, List<NoteVo>> userNoteMap = noteList.stream().collect(Collectors.groupingBy(NoteVo::getUserId));
        HashMap userNoteStrMap = new HashMap();
        userIdList.forEach(userId -> {
            List noteVoList = (List)userNoteMap.get(userId);
            userNoteStrMap.put(userId.toString(), JSON.toJSONString((Object)noteVoList));
            if (CollectionUtils.isNotEmpty((Collection)noteVoList)) {
                if (getFirst) {
                    resultList.add((NoteVo)noteVoList.get(0));
                } else {
                    resultList.addAll(noteVoList);
                }
            }
        });
        if (userNoteMap.size() > 0) {
            this.redisHashMapAdapter.putAll(RedisConfig.USER_FORUM_NOTE, userNoteStrMap);
        }
        return resultList;
    }

    @Override
    public void completeNoteInfo(NoteVo noteVo, Long userId) {
        noteVo.setShareUrl(this.iUrlFactory.getAppUrl(UrlCategoryEnum.FORUM, UrlTypeEnum.SHARE, noteVo.getId(), userId));
        noteVo.setAppletShareUrl(this.iUrlFactory.getAppletUrl(UrlPositionEnum.POST, noteVo.getId(), userId));
        noteVo.setShareImg(noteVo.getUserImg());
    }

    private Integer getPublishNum(Long userId) {
        KeyGenerator key = this.getUserNotePublishKey(userId);
        if (this.redisStringAdapter.hasKey(key).booleanValue()) {
            return this.redisStringAdapter.getInt(key);
        }
        Integer publishNum = this.forumProperties.getUserPublishNum();
        this.redisStringAdapter.set(key, (Object)publishNum);
        this.redisStringAdapter.expire(key, (long)DateUtils.getCurSeconds());
        return publishNum;
    }

    private KeyGenerator getUserNotePublishKey(Long userId) {
        return RedisConfig.USER_NOTE_PUBLISH.copy().appendKey((Object)userId);
    }
}

