/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.post;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.news.create.process.PostProcess;
import com.bxm.localnews.news.model.enums.SpecialForumEnum;
import com.bxm.localnews.news.model.param.PostProcessContext;
import com.bxm.localnews.news.model.param.PostSpecialForumParam;
import com.bxm.newidea.component.vo.Message;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SpecialForumPostPoster {
    private static final Logger log = LoggerFactory.getLogger(SpecialForumPostPoster.class);
    @Autowired
    private List<PostProcess> postProcessList;
    private static final Map<SpecialForumEnum, PostProcess> POST_PROCESS_MAP = Maps.newHashMap();

    @PostConstruct
    public void init() {
        this.postProcessList.forEach(p -> POST_PROCESS_MAP.put(p.support(), (PostProcess)p));
    }

    public Message postSpecialForum(PostSpecialForumParam param) {
        PostProcess postProcess = this.findProcess(param.getType());
        if (postProcess == null) {
            log.warn("\u83b7\u53d6\u5e16\u5b50\u5904\u7406\u7c7b\u5931\u8d25\uff0c\u7c7b\u578b: {} \u6ca1\u6709\u53ef\u7528\u7684\u5e16\u5b50\u5904\u7406\u7c7b, param: {}", (Object)param.getType(), (Object)JSON.toJSONString((Object)param));
            return Message.build((boolean)false, (String)"\u53d1\u5e16\u5931\u8d25");
        }
        return postProcess.post(PostProcessContext.builder().param(param).build());
    }

    private PostProcess findProcess(Integer type) {
        if (Objects.isNull(type)) {
            return null;
        }
        return SpecialForumEnum.getByType((int)type).map(POST_PROCESS_MAP::get).orElse(null);
    }
}

