/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.post.impl;

import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.AdminCommonTagMapper;
import com.bxm.localnews.news.model.vo.AdminCommonTag;
import com.bxm.localnews.news.post.AdminCommonTagService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdminCommonTagServiceImpl
implements AdminCommonTagService {
    private final AdminCommonTagMapper adminCommonTagMapper;
    private Logger logger = LoggerFactory.getLogger(AdminCommonTagServiceImpl.class);
    private RedisHashMapAdapter redisHashMapAdapter;

    @Autowired
    public AdminCommonTagServiceImpl(AdminCommonTagMapper adminCommonTagMapper, RedisHashMapAdapter redisHashMapAdapter) {
        this.adminCommonTagMapper = adminCommonTagMapper;
        this.redisHashMapAdapter = redisHashMapAdapter;
    }

    @Override
    public long saveAndGetTag(String tagName) {
        this.logger.info("\u83b7\u53d6tagName:{}", (Object)tagName);
        long hashCode = tagName.hashCode();
        long collectionIndex = hashCode % 10L;
        KeyGenerator tagKey = RedisConfig.SPIDER_TAG_INDEX.copy().appendKey((Object)collectionIndex);
        Long id = (Long)this.redisHashMapAdapter.get(tagKey, tagName, Long.class);
        if (null == id) {
            AdminCommonTag tag = this.adminCommonTagMapper.findByName(tagName);
            if (tag == null) {
                tag = new AdminCommonTag();
                tag.setName(tagName);
                this.adminCommonTagMapper.insert(tag);
            }
            this.logger.info("tag.getId()={}", (Object)tag.getId());
            this.redisHashMapAdapter.put(tagKey, tagName, (Object)tag.getId());
            return tag.getId().intValue();
        }
        return id;
    }
}

