/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.post.impl;

import com.bxm.localnews.news.domain.AdminEditorMessageMapper;
import com.bxm.localnews.news.domain.AdminForumPostMapper;
import com.bxm.localnews.news.model.param.AdminEditorMessageParam;
import com.bxm.localnews.news.model.vo.AdminBasicEditorMessage;
import com.bxm.localnews.news.model.vo.AdminEditorMessage;
import com.bxm.localnews.news.post.AdminEditorMessageService;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.PageParam;
import com.bxm.newidea.component.vo.PageWarper;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdminEditorMessageServiceImpl
extends BaseService
implements AdminEditorMessageService {
    private final AdminEditorMessageMapper adminEditorMessageMapper;
    private final AdminForumPostMapper adminForumPostMapper;

    @Autowired
    public AdminEditorMessageServiceImpl(AdminEditorMessageMapper adminEditorMessageMapper, AdminForumPostMapper adminForumPostMapper) {
        this.adminEditorMessageMapper = adminEditorMessageMapper;
        this.adminForumPostMapper = adminForumPostMapper;
    }

    @Override
    public int doSaveOrUpdateEditorMessage(AdminEditorMessageParam param) {
        if (Objects.isNull(param.getId()) || param.getId() == 0L) {
            AdminEditorMessage adminEditorMessage = this.convert(param);
            return this.adminEditorMessageMapper.insertSelective(adminEditorMessage);
        }
        AdminEditorMessage adminEditorMessage = new AdminEditorMessage();
        BeanUtils.copyProperties((Object)param, (Object)adminEditorMessage);
        adminEditorMessage.setModifyTime(new Date());
        int result = this.adminEditorMessageMapper.updateByPrimaryKeySelective(adminEditorMessage);
        int newsNum = this.adminEditorMessageMapper.updateEditMessageById(param);
        int postNum = this.adminForumPostMapper.updateEditMessageById(param);
        this.logger.info("\u66f4\u65b0\u5e16\u5b50\u8868\u5bc4\u8bed\u6570\u91cf[{}],\u66f4\u65b0\u65b0\u95fb\u8868\u5bc4\u8bed\u6570\u91cf[{}]", (Object)postNum, (Object)newsNum);
        return result;
    }

    public AdminEditorMessage convert(AdminEditorMessageParam param) {
        AdminEditorMessage adminEditorMessage = new AdminEditorMessage();
        BeanUtils.copyProperties((Object)param, (Object)adminEditorMessage);
        Date current = new Date();
        adminEditorMessage.setCreateTime(current);
        adminEditorMessage.setModifyTime(current);
        adminEditorMessage.setCreateId(param.getUserId());
        return adminEditorMessage;
    }

    @Override
    public AdminEditorMessage getEditorMessage(Long id) {
        return this.adminEditorMessageMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<AdminBasicEditorMessage> listAll() {
        return this.adminEditorMessageMapper.getList(null);
    }

    @Override
    public PageWarper<AdminBasicEditorMessage> listPage(PageParam pageParam) {
        return new PageWarper(this.adminEditorMessageMapper.getList(pageParam));
    }

    @Override
    public int deleteById(Long id) {
        int count = this.adminEditorMessageMapper.deleteByPrimaryKey(id);
        int newsNum = this.adminEditorMessageMapper.deleteEditMessageById(id);
        int postNum = this.adminForumPostMapper.deleteEditMessageById(id);
        this.logger.info("\u66f4\u65b0\u5e16\u5b50\u8868\u5bc4\u8bed\u6570\u91cf[{}],\u66f4\u65b0\u65b0\u95fb\u8868\u5bc4\u8bed\u6570\u91cf[{}]", (Object)postNum, (Object)newsNum);
        return count;
    }
}

