/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.post.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.base.integration.DomainIntegrationService;
import com.bxm.localnews.common.constant.DomainScene;
import com.bxm.localnews.dto.MerchantMemberUserDTO;
import com.bxm.localnews.integration.LocationIntegrationService;
import com.bxm.localnews.integration.MerchantMemberIntegrationService;
import com.bxm.localnews.integration.NewsSeqComponent;
import com.bxm.localnews.integration.ShortLinkIntegrationService;
import com.bxm.localnews.integration.UserAccountIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.integration.VirtualUserIntegrationService;
import com.bxm.localnews.news.config.ForumProperties;
import com.bxm.localnews.news.domain.AdminEditorMessageMapper;
import com.bxm.localnews.news.domain.AdminForumPostMapper;
import com.bxm.localnews.news.domain.AdminMixedRecommendPoolMapper;
import com.bxm.localnews.news.domain.AdminTopicMapper;
import com.bxm.localnews.news.domain.activity.ForumPostActivityMapper;
import com.bxm.localnews.news.domain.activity.ForumPostShareCashInfoMapper;
import com.bxm.localnews.news.enums.PostStatusEnum;
import com.bxm.localnews.news.enums.PostTypeEnum;
import com.bxm.localnews.news.model.dto.AdminGetPostUrlDTO;
import com.bxm.localnews.news.model.dto.VirtualUserOverviewDTO;
import com.bxm.localnews.news.model.entity.activity.ForumPostActivityEntity;
import com.bxm.localnews.news.model.entity.activity.ForumPostShareCashInfoEntity;
import com.bxm.localnews.news.model.param.AdminForumPostParam;
import com.bxm.localnews.news.model.param.VirtualUserQueryParam;
import com.bxm.localnews.news.model.vo.AdminBaseForumPost;
import com.bxm.localnews.news.model.vo.AdminBaseForumPostExcelVO;
import com.bxm.localnews.news.model.vo.AdminEditorMessage;
import com.bxm.localnews.news.model.vo.AdminForumPost;
import com.bxm.localnews.news.model.vo.AdminTopic;
import com.bxm.localnews.news.model.vo.PostImg;
import com.bxm.localnews.news.note.NoteService;
import com.bxm.localnews.news.post.AdminForumPostService;
import com.bxm.localnews.news.post.PostTagService;
import com.bxm.localnews.news.topic.AdminTopicService;
import com.bxm.localnews.news.util.DealContentUtil;
import com.bxm.localnews.news.util.ImportUtils;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.localnews.url.ProtocolFactory;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AdminForumPostServiceImpl
extends BaseService
implements AdminForumPostService {
    private static final Logger log = LoggerFactory.getLogger(AdminForumPostServiceImpl.class);
    private AdminTopicMapper adminTopicMapper;
    private AdminForumPostMapper adminForumPostMapper;
    private AdminEditorMessageMapper adminEditorMessageMapper;
    private AdminMixedRecommendPoolMapper adminMixedRecommendPoolMapper;
    private LocationIntegrationService locationService;
    private AdminTopicService adminTopicService;
    private NewsSeqComponent newsSeqComponent;
    private ForumProperties forumProperties;
    private UserAccountIntegrationService userAccountIntegrationService;
    private DealContentUtil dealContentUtil;
    private UserIntegrationService userIntegrationService;
    private VirtualUserIntegrationService virtualUserIntegrationService;
    private DomainIntegrationService domainIntegrationService;
    private ShortLinkIntegrationService shortLinkIntegrationService;
    private ForumPostShareCashInfoMapper forumPostShareCashInfoMapper;
    private ForumPostActivityMapper forumPostActivityMapper;
    private MerchantMemberIntegrationService merchantMemberIntegrationService;
    private PostTagService postTagService;
    private NoteService noteService;

    @Override
    public PageWarper<AdminBaseForumPost> getApproveList(AdminForumPostParam param) {
        PageWarper forumList = new PageWarper(this.adminForumPostMapper.getList(param));
        if (CollectionUtils.isNotEmpty((Collection)forumList.getList())) {
            forumList.getList().parallelStream().forEach(this::completePostInfo);
        }
        return forumList;
    }

    @Override
    public List<AdminBaseForumPostExcelVO> getApproveListExcelVO(AdminForumPostParam param) {
        PageWarper<AdminBaseForumPost> approveList = this.getApproveList(param);
        return approveList.getList().stream().map(this::convert).collect(Collectors.toList());
    }

    private AdminBaseForumPostExcelVO convert(AdminBaseForumPost post) {
        byte yes = 1;
        AdminBaseForumPostExcelVO excelVO = new AdminBaseForumPostExcelVO();
        BeanUtils.copyProperties((Object)post, (Object)excelVO);
        excelVO.setId(Objects.toString(post.getId()));
        excelVO.setTitle(StringUtils.isBlank((CharSequence)post.getTitle()) ? post.getTextField() : post.getTitle());
        excelVO.setUserId(Objects.toString(post.getUserId()));
        excelVO.setIsBrilliant(Objects.equals(post.getIsBrilliant(), yes) ? "\u662f" : "\u5426");
        excelVO.setIsRecommend(Objects.equals(post.getIsRecommend(), yes) ? "\u662f" : "\u5426");
        excelVO.setIsRed(Objects.equals(post.getIsRed(), yes) ? "\u662f" : "\u5426");
        excelVO.setIsCash(Objects.equals(post.getIsCash(), yes) ? "\u662f" : "\u5426");
        excelVO.setCashReward(Objects.isNull(post.getCashReward()) ? "0" : Objects.toString(post.getCashReward()));
        excelVO.setIsBroke(Objects.equals(post.getIsBroke(), yes) ? "\u662f" : "\u5426");
        excelVO.setCreateTime(DateUtils.formatDateTime((Date)post.getCreateTime()));
        excelVO.setPublishTime(DateUtils.formatDateTime((Date)post.getPublishTime()));
        excelVO.setDisplayTime(DateUtils.formatDateTime((Date)post.getDisplayTime()));
        excelVO.setDeliveryType(Objects.equals(post.getDeliveryType(), 0) ? "\u5168\u56fd" : "\u5730\u65b9");
        excelVO.setPostType(Objects.equals(post.getPostType(), yes) ? "\u666e\u901a\u5e16\u5b50" : "\u5c0f\u7eb8\u6761");
        excelVO.setValidDate(DateUtils.formatDateTime((Date)post.getValidDate()));
        excelVO.setTopicIdList(Objects.toString(post.getTopicList().stream().map(AdminTopic::getTitle).collect(Collectors.toList())));
        excelVO.setModifyTime(DateUtils.formatDateTime((Date)post.getModifyTime()));
        excelVO.setIdentity(Objects.equals(post.getIdentity(), yes) ? "\u771f\u5b9e\u7528\u6237" : "\u9a6c\u7532\u53f7");
        excelVO.setIsValid(Objects.equals(post.getIsValid(), Boolean.TRUE) ? "\u672a\u8fc7\u671f" : "\u8fc7\u671f");
        return excelVO;
    }

    private String status(Integer status) {
        PostStatusEnum statusEnum = PostStatusEnum.getByCode((Integer)status);
        if (null == statusEnum) {
            return "\u65e0";
        }
        return statusEnum.getName();
    }

    @Override
    public AdminForumPost selectByPrimaryKey(Long id) {
        ForumPostShareCashInfoEntity shareCashInfoEntity;
        ForumPostActivityEntity forumPostActivityEntity;
        List videoList;
        List imgList;
        AdminEditorMessage adminEditorMessage;
        AdminForumPost adminForumPost = this.adminForumPostMapper.selectByPrimaryKey(id);
        if (null == adminForumPost) {
            return null;
        }
        this.completePostInfo(adminForumPost);
        if (adminForumPost.getEditorMessageId() != null && (adminEditorMessage = this.adminEditorMessageMapper.selectByPrimaryKey(adminForumPost.getEditorMessageId())) != null) {
            adminForumPost.setEditorMessageName(adminEditorMessage.getTemplateName());
        }
        VirtualUserQueryParam virtualUserQueryParam = new VirtualUserQueryParam();
        virtualUserQueryParam.setId(adminForumPost.getUserId());
        List virtualUserList = this.virtualUserIntegrationService.list(virtualUserQueryParam);
        if (CollectionUtils.isNotEmpty((Collection)virtualUserList)) {
            adminForumPost.setUserInfo(((VirtualUserOverviewDTO)virtualUserList.get(0)).getUserInfo());
        }
        List postImgList = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)adminForumPost.getImgList())) {
            postImgList = JSONArray.parseArray((String)adminForumPost.getImgList(), PostImg.class);
        }
        if (StringUtils.isBlank((CharSequence)adminForumPost.getCoverList()) && CollectionUtils.isNotEmpty(postImgList) && CollectionUtils.isNotEmpty(imgList = postImgList.stream().filter(e -> StringUtils.equals((CharSequence)e.getType(), (CharSequence)"IMG")).map(PostImg::getImgUrl).collect(Collectors.toList()))) {
            adminForumPost.setCoverList(JSONObject.toJSONString(imgList));
        }
        if (CollectionUtils.isNotEmpty(postImgList) && CollectionUtils.isNotEmpty(videoList = postImgList.stream().filter(e -> StringUtils.equals((CharSequence)e.getType(), (CharSequence)"VIDEO")).map(PostImg::getImgUrl).collect(Collectors.toList()))) {
            adminForumPost.setVideoPosterList(JSONObject.toJSONString(videoList));
        }
        if (StringUtils.isNotBlank((CharSequence)adminForumPost.getContent())) {
            adminForumPost.setContent(this.dealContentUtil.fixContent(adminForumPost.getContent()));
        }
        if (Objects.equals(adminForumPost.getActivityPost(), 1) && Objects.nonNull(forumPostActivityEntity = this.forumPostActivityMapper.selectByPostId(adminForumPost.getId()))) {
            BeanUtils.copyProperties((Object)forumPostActivityEntity, (Object)adminForumPost, (String[])new String[]{"id"});
            adminForumPost.setActivityStatus(forumPostActivityEntity.getStatus());
            MerchantMemberUserDTO relationMerchantInfo = this.merchantMemberIntegrationService.getRelationMerchantInfo(adminForumPost.getUserId());
            if (Objects.nonNull(relationMerchantInfo)) {
                adminForumPost.setMerchantId(relationMerchantInfo.getMerchantId());
                adminForumPost.setMerchantName(relationMerchantInfo.getMerchantName());
            }
        }
        if (Objects.equals(adminForumPost.getIsShareCash(), 1) && Objects.nonNull(shareCashInfoEntity = this.forumPostShareCashInfoMapper.getByPostId(adminForumPost.getId()))) {
            BeanUtils.copyProperties((Object)shareCashInfoEntity, (Object)adminForumPost, (String[])new String[]{"id"});
        }
        return adminForumPost;
    }

    @Override
    public Boolean hasCashPost(String ids) {
        List<Long> idList = this.parseIds(ids);
        if (CollectionUtils.isEmpty(idList)) {
            return false;
        }
        for (Long id : idList) {
            AdminForumPost post = this.selectByPrimaryKey(id);
            if (!Objects.equals(post.getIsCash(), (byte)1)) continue;
            return true;
        }
        return false;
    }

    private List<Long> parseIds(String ids) {
        if (StringUtils.isBlank((CharSequence)ids)) {
            return Lists.newArrayList();
        }
        return Arrays.stream(ids.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
    }

    @Override
    public int deleteOrRecover(String ids, Integer status, Byte deductGold) {
        List<Long> idList = this.parseIds(ids);
        if (CollectionUtils.isEmpty(idList)) {
            return 0;
        }
        for (Long id : idList) {
            AdminForumPost adminForumPost = this.adminForumPostMapper.selectByPrimaryKey(id);
            if (adminForumPost == null) {
                return 0;
            }
            adminForumPost.setStatus(status);
            adminForumPost.setIsRecommend(Byte.valueOf((byte)0));
            this.adminForumPostMapper.updateByIdPartSelective(adminForumPost);
            if (1 == status) {
                this.postTagService.savePostTag(adminForumPost);
                continue;
            }
            this.userIntegrationService.addPostReplyNum(adminForumPost.getUserId(), Integer.valueOf(2));
            if (null != deductGold && 1 == deductGold) {
                this.userAccountIntegrationService.deductUserGold(adminForumPost.getId(), adminForumPost.getUserId());
            }
            this.adminMixedRecommendPoolMapper.deleteByPrimaryKey(id);
            if (PostTypeEnum.NOTE.getCode() != adminForumPost.getPostType().byteValue()) continue;
            this.noteService.removeCache(adminForumPost.getUserId());
        }
        return 1;
    }

    @Override
    public Long getCreateId(Integer postType) {
        if (null == postType) {
            return this.newsSeqComponent.getPostId();
        }
        if (PostTypeEnum.ACTIVITY.getCode() == postType.intValue()) {
            return this.newsSeqComponent.getActivityPostId();
        }
        return this.newsSeqComponent.getPostId();
    }

    @Override
    public String getPostUrl(AdminGetPostUrlDTO adminGetPostUrlDTO) {
        if (Objects.equals(adminGetPostUrlDTO.getType(), 2)) {
            return ProtocolFactory.forumPost().app().postId(adminGetPostUrlDTO.getId()).build();
        }
        String areaCode = null;
        if (StringUtils.isNotBlank((CharSequence)adminGetPostUrlDTO.getAreaCode())) {
            areaCode = (String)Splitter.on((String)",").split((CharSequence)adminGetPostUrlDTO.getAreaCode()).iterator().next();
        }
        String postUrl = ProtocolFactory.forumPost().outer().userId(adminGetPostUrlDTO.getUserId()).postId(adminGetPostUrlDTO.getId()).channel(adminGetPostUrlDTO.getChannel()).domainViewScene(DomainScene.DomainViewScene.WX_JS_VIEW).cityName(adminGetPostUrlDTO.getCityName()).areaCode(areaCode).noExtend().build();
        return this.shortLinkIntegrationService.generateShortUrl(postUrl);
    }

    @Override
    public void importNotes(Long userId, MultipartFile ... multipartFiles) {
        if (null == multipartFiles) {
            return;
        }
        ArrayList<AdminForumPost> adminForumPostList = new ArrayList<AdminForumPost>();
        ArrayList<Long> postIdList = new ArrayList<Long>();
        for (MultipartFile multipartFile : multipartFiles) {
            List<List<String>> resultList = ImportUtils.readExcelFile(multipartFile);
            if (CollectionUtils.isEmpty(resultList)) continue;
            this.logger.debug("\u89e3\u6790\u7ed3\u679c\uff1a" + JSON.toJSONString(resultList));
            for (List<String> result : resultList) {
                AdminForumPost adminForumPost = this.getForumPost(userId, postIdList, result);
                if (adminForumPost == null) continue;
                adminForumPostList.add(adminForumPost);
            }
        }
        this.logger.debug("\u5c0f\u7eb8\u6761\u5217\u8868" + JSON.toJSONString(adminForumPostList));
        if (CollectionUtils.isNotEmpty(adminForumPostList)) {
            MybatisBatchBuilder.create(AdminForumPostMapper.class, adminForumPostList).run(AdminForumPostMapper::insertSelective);
            this.adminTopicService.batchUpdatePostTopic(this.forumProperties.getNoteTopicId(), postIdList);
            adminForumPostList.forEach(this.postTagService::resetForumPostTag);
        }
    }

    private AdminForumPost getForumPost(Long userId, List<Long> postIdList, List<String> result) {
        String content;
        AdminForumPost adminForumPost = new AdminForumPost();
        Long id = this.getCreateId(null);
        postIdList.add(id);
        adminForumPost.setId(id);
        adminForumPost.setCreateTime(new Date());
        adminForumPost.setModifyTime(new Date());
        adminForumPost.setCreator(userId);
        adminForumPost.setStatus(PostStatusEnum.NORMAL.getCode());
        adminForumPost.setTopicIdList(Collections.singletonList(this.forumProperties.getNoteTopicId()));
        adminForumPost.setPostType(Byte.valueOf(PostTypeEnum.NOTE.getCode()));
        String postUserId = result.get(0);
        if (StringUtils.isBlank((CharSequence)postUserId)) {
            return null;
        }
        adminForumPost.setUserId(Long.valueOf(postUserId));
        UserBean userBean = this.userIntegrationService.selectUserFromCache(adminForumPost.getUserId());
        if (null != userBean) {
            adminForumPost.setUserImg(userBean.getHeadImg());
            adminForumPost.setUserName(userBean.getNickname());
        }
        if (StringUtils.isBlank((CharSequence)(content = result.get(1)))) {
            return null;
        }
        adminForumPost.setTextField(content);
        adminForumPost.setContent(content);
        String time = result.get(2);
        if (StringUtils.isBlank((CharSequence)time)) {
            return null;
        }
        adminForumPost.setPublishTime(DateUtils.parseDateTime((String)time));
        adminForumPost.setDisplayTime(adminForumPost.getPublishTime());
        String validDay = result.get(3);
        if (StringUtils.isBlank((CharSequence)validDay)) {
            return null;
        }
        adminForumPost.setValidDay(Integer.valueOf(validDay));
        adminForumPost.setValidDate(DateUtils.addField((Date)adminForumPost.getDisplayTime(), (int)5, (int)adminForumPost.getValidDay()));
        adminForumPost.setDeliveryType(Integer.valueOf(0));
        if (result.size() > 4) {
            adminForumPost.setAreaCode(result.get(4));
            if (StringUtils.isNotBlank((CharSequence)adminForumPost.getAreaCode())) {
                adminForumPost.setDeliveryType(Integer.valueOf(1));
            }
        }
        return adminForumPost;
    }

    private <T extends AdminBaseForumPost> void completePostInfo(T forumPost) {
        if (StringUtils.isNotEmpty((CharSequence)forumPost.getAreaCode())) {
            String[] areaCodeArray = forumPost.getAreaCode().split(",");
            forumPost.setAreaDetail(this.locationService.batchGetDetailJson(areaCodeArray));
        }
        forumPost.setTopicList(this.adminTopicMapper.getListByPostId(forumPost.getId()));
        UserBean userBean = this.userIntegrationService.selectUserFromCache(forumPost.getUserId());
        forumPost.setUserState(userBean.getState() == null ? null : Integer.valueOf(userBean.getState().byteValue()));
        forumPost.setNickName(userBean.getNickname());
        forumPost.setLinkUrl(ProtocolFactory.forumPost().outer().noExtend().userId(forumPost.getUserId()).postId(forumPost.getId()).build());
        forumPost.setIdentity(Byte.valueOf((byte)(!Objects.equals(userBean.getState(), (byte)3) ? 1 : 0)));
        this.restorePluginId(forumPost);
        forumPost.setIsValid(Boolean.valueOf(2 == forumPost.getPostType() && new Date().before(forumPost.getValidDate())));
        forumPost.setIsPrePublish(Integer.valueOf(0));
        if (Objects.nonNull(forumPost.getPublishTime())) {
            forumPost.setIsPrePublish(Integer.valueOf(forumPost.getPublishTime().after(new Date()) ? 1 : 0));
        }
    }

    private <T extends AdminBaseForumPost> void restorePluginId(T post) {
        if (StringUtils.isNotBlank((CharSequence)post.getPlugins())) {
            JSONArray jsonArray = JSONArray.parseArray((String)post.getPlugins());
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject json = jsonArray.getJSONObject(i);
                if (!"VOTE".equals(json.get((Object)"type"))) continue;
                post.setVotePluginId(json.getString("id"));
            }
        }
    }

    public AdminForumPostServiceImpl(AdminTopicMapper adminTopicMapper, AdminForumPostMapper adminForumPostMapper, AdminEditorMessageMapper adminEditorMessageMapper, AdminMixedRecommendPoolMapper adminMixedRecommendPoolMapper, LocationIntegrationService locationService, AdminTopicService adminTopicService, NewsSeqComponent newsSeqComponent, ForumProperties forumProperties, UserAccountIntegrationService userAccountIntegrationService, DealContentUtil dealContentUtil, UserIntegrationService userIntegrationService, VirtualUserIntegrationService virtualUserIntegrationService, DomainIntegrationService domainIntegrationService, ShortLinkIntegrationService shortLinkIntegrationService, ForumPostShareCashInfoMapper forumPostShareCashInfoMapper, ForumPostActivityMapper forumPostActivityMapper, MerchantMemberIntegrationService merchantMemberIntegrationService, PostTagService postTagService, NoteService noteService) {
        this.adminTopicMapper = adminTopicMapper;
        this.adminForumPostMapper = adminForumPostMapper;
        this.adminEditorMessageMapper = adminEditorMessageMapper;
        this.adminMixedRecommendPoolMapper = adminMixedRecommendPoolMapper;
        this.locationService = locationService;
        this.adminTopicService = adminTopicService;
        this.newsSeqComponent = newsSeqComponent;
        this.forumProperties = forumProperties;
        this.userAccountIntegrationService = userAccountIntegrationService;
        this.dealContentUtil = dealContentUtil;
        this.userIntegrationService = userIntegrationService;
        this.virtualUserIntegrationService = virtualUserIntegrationService;
        this.domainIntegrationService = domainIntegrationService;
        this.shortLinkIntegrationService = shortLinkIntegrationService;
        this.forumPostShareCashInfoMapper = forumPostShareCashInfoMapper;
        this.forumPostActivityMapper = forumPostActivityMapper;
        this.merchantMemberIntegrationService = merchantMemberIntegrationService;
        this.postTagService = postTagService;
        this.noteService = noteService;
    }
}

