/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.post.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.integration.MessageService;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.news.content.ContentReplacer;
import com.bxm.localnews.news.domain.AdminForumPostMapper;
import com.bxm.localnews.news.model.constant.RedisCacheKey;
import com.bxm.localnews.news.model.dto.ContentContext;
import com.bxm.localnews.news.model.enums.ForumContentPlaceHolderEnum;
import com.bxm.localnews.news.model.param.ForumPostUserAtParam;
import com.bxm.localnews.news.model.param.ReplaceTopicNeedParam;
import com.bxm.localnews.news.model.vo.AdminForumPost;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.post.ForumPostContentService;
import com.bxm.localnews.news.statistics.ForumPostStatisticService;
import com.bxm.localnews.news.task.ForumPostUserAtTask;
import com.bxm.localnews.news.util.FormPostContentUtil;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.schedule.ScheduleService;
import com.bxm.newidea.component.schedule.builder.OnceTaskBuilder;
import com.bxm.newidea.component.schedule.task.ScheduleTask;
import com.bxm.newidea.component.schedule.task.TaskCallback;
import com.bxm.newidea.component.vo.BasicParam;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ForumPostContentServiceImpl
implements ForumPostContentService {
    private static final Logger log = LoggerFactory.getLogger(ForumPostContentServiceImpl.class);
    private static final String WST_USER_HREF = "a[" + ForumContentPlaceHolderEnum.USER_JUMP_URL.getPlaceHolder() + "]";
    private static final String POST_PROTOCOL = "wst://community/postDetail?postId=%s&tp=post";
    private final MessageService messageService;
    private final ContentReplacer contentReplacer;
    private final RedisStringAdapter redisStringAdapter;
    private final AdminForumPostMapper adminForumPostMapper;
    private final ScheduleService scheduleService;
    private final ForumPostUserAtTask forumPostUserAtTask;
    private final ForumPostStatisticService forumPostStatisticService;
    private static final long EXPIRE = 864000L;

    @Override
    public void afterCreate(AdminForumPost forumPostVo) {
        try {
            Document document = Jsoup.parse((String)forumPostVo.getContent());
            document.outputSettings().prettyPrint(true).indentAmount(1);
            Date now = new Date();
            if (Objects.isNull(forumPostVo.getPublishTime()) || forumPostVo.getPublishTime().before(now) || forumPostVo.getPublishTime().getTime() == now.getTime()) {
                this.processAtInfoAndPush(document, forumPostVo.getId(), Collections.emptyList());
            } else {
                ForumPostUserAtParam atParam = new ForumPostUserAtParam();
                atParam.setPostId(forumPostVo.getId());
                this.scheduleService.push((ScheduleTask)OnceTaskBuilder.builder((String)ForumPostUserAtTask.generateTaskName(forumPostVo.getId()), (Date)forumPostVo.getPublishTime(), (TaskCallback)this.forumPostUserAtTask).callbackParam((Object)atParam).build());
            }
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u5e16\u5b50\u5185\u5bb9\u5931\u8d25, forumPostVo: {}", (Object)JSON.toJSONString((Object)forumPostVo), (Object)e);
        }
    }

    @Override
    public void afterUp(ForumPostUserAtParam param) {
        AdminForumPost adminForumPost = this.adminForumPostMapper.selectByPrimaryKey(param.getPostId());
        if (Objects.nonNull(adminForumPost)) {
            Document document = Jsoup.parse((String)adminForumPost.getContent());
            document.outputSettings().prettyPrint(true).indentAmount(1);
            this.processAtInfoAndPush(document, adminForumPost.getId(), Collections.emptyList());
        }
    }

    @Override
    public void pushAtInfo(AdminForumPost forumPostVo) {
        try {
            Document document = Jsoup.parse((String)forumPostVo.getContent());
            document.outputSettings().prettyPrint(true).indentAmount(1);
            Date now = new Date();
            if (Objects.isNull(forumPostVo.getPublishTime()) || forumPostVo.getPublishTime().before(now) || forumPostVo.getPublishTime().getTime() == now.getTime()) {
                List lastUserIds = Lists.newArrayList();
                String s = (String)this.redisStringAdapter.get(this.getKey(forumPostVo.getId()), String.class);
                if (StringUtils.isNotBlank((CharSequence)s)) {
                    lastUserIds = JSON.parseArray((String)s, Long.class);
                }
                this.processAtInfoAndPush(document, forumPostVo.getId(), lastUserIds);
            }
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u5e16\u5b50\u5185\u5bb9\u5931\u8d25, forumPostVo: {}", (Object)JSON.toJSONString((Object)forumPostVo), (Object)e);
        }
    }

    private void push(Long userId, Long postId) {
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.JUMP_TYPE);
        info.setProtocol(String.format(POST_PROTOCOL, postId));
        PushMessage pushMessage = PushMessage.build();
        pushMessage.setPayloadInfo(info);
        pushMessage.setTitle("\u4f60\u7684\u597d\u53cb@\u4e86\u4f60");
        pushMessage.setContent("\u4f60\u7684\u597d\u53cb@\u4e86\u4f60\uff0c\u5feb\u6765\u770b\u770b");
        pushMessage.setPushReceiveScope(PushReceiveScope.pushSignle((Long)userId));
        if (log.isDebugEnabled()) {
            log.debug("\u7ed9\u7528\u6237: {} \u53d1\u9001@\u63a8\u9001: {}", (Object)userId, JSON.toJSON((Object)pushMessage));
        }
        this.messageService.pushMessage(pushMessage);
    }

    private KeyGenerator getKey(Long postId) {
        return RedisCacheKey.FORUM_AT_USER_IDS.copy().appendKey((Object)Objects.toString(postId));
    }

    private void processAtInfoAndPush(Document document, Long postId, List<Long> lastUserIds) {
        List<Long> userIds = this.processAtInfo(document);
        if (!CollectionUtils.isEmpty(userIds)) {
            this.redisStringAdapter.set(this.getKey(postId), (Object)JSON.toJSONString(userIds), 864000L);
            if (!CollectionUtils.isEmpty(lastUserIds)) {
                userIds = userIds.stream().filter(p -> !lastUserIds.contains(p)).collect(Collectors.toList());
            }
            userIds.forEach(p -> this.push((Long)p, postId));
        }
    }

    private List<Long> processAtInfo(Document document) {
        Elements select = document.select(WST_USER_HREF);
        if (Objects.nonNull(select) && !select.isEmpty()) {
            return select.stream().map(e -> {
                String wstUserHref = e.attr(ForumContentPlaceHolderEnum.USER_JUMP_URL.getPlaceHolder());
                if (StringUtils.isNotBlank((CharSequence)wstUserHref) && StringUtils.isNumeric((CharSequence)wstUserHref)) {
                    return Long.valueOf(wstUserHref);
                }
                return 0L;
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public void replacePlaceHolder(ForumPostVo forumPostVo, LocationDTO locationDTO, com.bxm.localnews.common.vo.BasicParam basicParam, Long userId) {
        this.replacePostTitleOrField(forumPostVo, locationDTO);
        forumPostVo.setContent(this.replacePlaceHolder(forumPostVo.getContent(), locationDTO, basicParam, userId));
        forumPostVo.setEditorMessage(this.replacePlaceHolder(forumPostVo.getEditorMessage(), locationDTO, basicParam, userId));
    }

    @Override
    public void replacePostTitleOrField(ForumPostVo forumPostVo, LocationDTO locationDTO) {
        if (locationDTO == null) {
            locationDTO = new LocationDTO();
        }
        forumPostVo.setEnablePlaceholder(Byte.valueOf((byte)1));
        FormPostContentUtil.replace(forumPostVo, locationDTO);
    }

    @Override
    public String replacePlaceHolder(String content, LocationDTO locationDTO, com.bxm.localnews.common.vo.BasicParam basicParam, Long userId) {
        if (Objects.isNull(locationDTO) || StringUtils.isBlank((CharSequence)content)) {
            return content;
        }
        ReplaceTopicNeedParam param = new ReplaceTopicNeedParam();
        param.merge((BasicParam)basicParam);
        param.setUserId(userId);
        param.setAreaName(locationDTO.getName());
        param.setAreaCode(locationDTO.getCode());
        ContentContext context = new ContentContext(content);
        context.addReplaceType(ForumContentPlaceHolderEnum.AREA_NAME, () -> ((LocationDTO)locationDTO).getName()).addReplaceType(ForumContentPlaceHolderEnum.AREA_NAME_2, () -> ((LocationDTO)locationDTO).getName()).addReplaceType(ForumContentPlaceHolderEnum.TOPIC_JUMP_URL, () -> param).addReplaceType(ForumContentPlaceHolderEnum.USER_JUMP_URL, () -> param).addReplaceType(ForumContentPlaceHolderEnum.LOTTERY_FLAUNT_JUMP_URL, () -> param);
        this.contentReplacer.replace(context);
        return context.getContent();
    }

    public ForumPostContentServiceImpl(MessageService messageService, ContentReplacer contentReplacer, RedisStringAdapter redisStringAdapter, AdminForumPostMapper adminForumPostMapper, ScheduleService scheduleService, ForumPostUserAtTask forumPostUserAtTask, ForumPostStatisticService forumPostStatisticService) {
        this.messageService = messageService;
        this.contentReplacer = contentReplacer;
        this.redisStringAdapter = redisStringAdapter;
        this.adminForumPostMapper = adminForumPostMapper;
        this.scheduleService = scheduleService;
        this.forumPostUserAtTask = forumPostUserAtTask;
        this.forumPostStatisticService = forumPostStatisticService;
    }
}

