/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.post.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.integration.LocationIntegrationService;
import com.bxm.localnews.news.config.UserProperties;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.detail.ForumPostDetailService;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.domain.ForumTopicMapper;
import com.bxm.localnews.news.domain.NewsReplyMapper;
import com.bxm.localnews.news.dto.BaseForumPostDTO;
import com.bxm.localnews.news.dto.ImgDTO;
import com.bxm.localnews.news.dto.RelationDTO;
import com.bxm.localnews.news.enums.PostTypeEnum;
import com.bxm.localnews.news.factory.ExtendFactory;
import com.bxm.localnews.news.image.ImageHelper;
import com.bxm.localnews.news.list.PostListService;
import com.bxm.localnews.news.model.dto.ForumPostBriefInfoDto;
import com.bxm.localnews.news.model.dto.InteractRankInfo;
import com.bxm.localnews.news.model.param.ForumPostFillContext;
import com.bxm.localnews.news.model.vo.ForumBasicVo;
import com.bxm.localnews.news.model.vo.ForumPlugin;
import com.bxm.localnews.news.model.vo.ForumPostClickCountVo;
import com.bxm.localnews.news.model.vo.ForumPostRankForUserVo;
import com.bxm.localnews.news.model.vo.ForumPostTitleInfoVo;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.model.vo.ForumRankVo;
import com.bxm.localnews.news.model.vo.PostClickCountVo;
import com.bxm.localnews.news.model.vo.RecommendUserFacadeVo;
import com.bxm.localnews.news.model.vo.TopicFacadeVO;
import com.bxm.localnews.news.model.vo.TopicVo;
import com.bxm.localnews.news.post.ForumPostFacadeService;
import com.bxm.localnews.news.topic.ForumTopicService;
import com.bxm.localnews.news.util.FormPostContentUtil;
import com.bxm.localnews.news.vo.PostImgVo;
import com.bxm.localnews.news.vo.UserImgVo;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.PageParam;
import com.github.pagehelper.page.PageMethod;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class ForumPostFacadeServiceImpl
implements ForumPostFacadeService {
    private static final Logger log = LogManager.getLogger(ForumPostFacadeServiceImpl.class);
    private final ForumPostMapper forumPostMapper;
    private final RedisSetAdapter redisSetAdapter;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final UserProperties userProperties;
    private final ForumTopicMapper forumTopicMapper;
    private final ForumTopicService forumTopicService;
    private final NewsReplyMapper newsReplyMapper;
    private final LocationIntegrationService locationIntegrationService;
    private final ForumPostDetailService forumPostDetailService;
    private final ImageHelper imageHelper;
    private final PostListService postListService;

    public ForumPostFacadeServiceImpl(ForumPostMapper forumPostMapper, RedisSetAdapter redisSetAdapter, RedisHashMapAdapter redisHashMapAdapter, UserProperties userProperties, ForumTopicMapper forumTopicMapper, ForumTopicService forumTopicService, NewsReplyMapper newsReplyMapper, LocationIntegrationService locationIntegrationService, ForumPostDetailService forumPostDetailService, ImageHelper imageHelper, PostListService postListService) {
        this.forumPostMapper = forumPostMapper;
        this.redisSetAdapter = redisSetAdapter;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.userProperties = userProperties;
        this.forumTopicMapper = forumTopicMapper;
        this.forumTopicService = forumTopicService;
        this.newsReplyMapper = newsReplyMapper;
        this.locationIntegrationService = locationIntegrationService;
        this.forumPostDetailService = forumPostDetailService;
        this.imageHelper = imageHelper;
        this.postListService = postListService;
    }

    @Override
    public ForumPostBriefInfoDto getBriefInfo(Long postId, Long userId, String areaCode, String ip) {
        ForumPostVo forumPostVo = this.forumPostDetailService.getBriefPost(postId, userId, areaCode);
        ForumPostBriefInfoDto briefInfoDto = new ForumPostBriefInfoDto();
        if (null != forumPostVo) {
            PostImgVo imgInfo = forumPostVo.getShareImg();
            if (null != imgInfo) {
                briefInfoDto.setConvertImgUrl(imgInfo.getImgUrl());
            }
            if (!CollectionUtils.isEmpty((Collection)forumPostVo.getPlugins())) {
                for (ForumPlugin plugin : forumPostVo.getPlugins()) {
                    if (!"VOTE".equals(plugin.getType())) continue;
                    briefInfoDto.setHasVote(Boolean.valueOf(true));
                    break;
                }
            }
            briefInfoDto.setId(postId);
            briefInfoDto.setTitle(this.getTitle(forumPostVo));
        }
        return briefInfoDto;
    }

    @Override
    public ForumPostBriefInfoDto getBriefInfo(Long postId) {
        return this.getBriefInfo(postId, null, null, null);
    }

    private String getTitle(ForumPostVo forumPostVo) {
        String title = forumPostVo.getTitle();
        if (StringUtils.isBlank((CharSequence)title) || PostTypeEnum.NOTE.getCode() == forumPostVo.getPostType().byteValue()) {
            title = StringUtils.substring((String)forumPostVo.getTextField(), (int)0, (int)50);
        }
        return title;
    }

    @Override
    public Integer getPublishPostNum(Long userId) {
        return this.forumPostMapper.selectPublishPostNumByUserId(userId);
    }

    @Override
    public List<ForumPostClickCountVo> getRecentPosts(Integer clickCountLimit) {
        return this.forumPostMapper.getRecentPosts(clickCountLimit, DateUtils.addField((Date)new Date(), (int)5, (int)-1));
    }

    @Override
    public List<PostClickCountVo> getUnFullClickPosts(PageParam param) {
        return PageMethod.startPage((Object)param).doSelectPage(() -> ((ForumPostMapper)this.forumPostMapper).getUnFullClickPosts());
    }

    @Override
    public List<ForumPostClickCountVo> getRecentRecommendPosts(Integer clickCountLimit) {
        return this.forumPostMapper.getRecentRecommendPosts(clickCountLimit, DateUtils.addField((Date)new Date(), (int)5, (int)-120));
    }

    @Override
    public void batchAddClick(List<ForumPostClickCountVo> forumPostClickList) {
        if (CollectionUtils.isNotEmpty(forumPostClickList)) {
            MybatisBatchBuilder.create(ForumPostMapper.class, forumPostClickList).run(ForumPostMapper::batchAddClick);
        }
    }

    @Override
    public BaseForumPostDTO getForumPostByUserId(Long userId, Long targetUserId, String areaCode) {
        boolean flag;
        KeyGenerator recentKey = RedisConfig.RECENT_DEVELOPMENTS.copy().appendKey((Object)String.valueOf(userId));
        ForumPostVo forumPostVo = this.forumPostMapper.selectPostByUserIdAndWeek(targetUserId);
        BaseForumPostDTO result = null;
        boolean bl = flag = Objects.nonNull(forumPostVo) && this.redisSetAdapter.exists(recentKey, (Object)forumPostVo.getId()) == false;
        if (flag) {
            List coverList = this.imageHelper.converSelect(forumPostVo.getCoverList(), forumPostVo.getPostImgList(), forumPostVo.getCoverSelect());
            forumPostVo.setEnablePlaceholder(Byte.valueOf((byte)1));
            FormPostContentUtil.replace(forumPostVo, this.locationIntegrationService.getLocationByGeocode(areaCode));
            result = BaseForumPostDTO.builder().id(forumPostVo.getId()).imgUrl(CollectionUtils.isEmpty((Collection)coverList) ? null : ((PostImgVo)coverList.get(0)).getImgUrl()).textField(forumPostVo.getTextField()).title(ExtendFactory.getTitle((String)forumPostVo.getTitle(), (String)forumPostVo.getTextField())).publishTime(forumPostVo.getPublishTime()).build();
            this.redisSetAdapter.add(recentKey, new Object[]{forumPostVo.getId()});
            this.redisSetAdapter.expire(recentKey, 604800L);
        }
        return result;
    }

    @Override
    public List<UserImgVo> batchGetUserImg(List<Long> userIdList, Long currentUserId) {
        List forumPostVoList;
        UserImgVo userImgVo;
        ArrayList<UserImgVo> userImgVoList = new ArrayList<UserImgVo>();
        if (CollectionUtils.isEmpty(userIdList)) {
            return userImgVoList;
        }
        boolean hasCurrent = false;
        if (currentUserId != null && userIdList.contains(currentUserId)) {
            userIdList.remove(currentUserId);
            hasCurrent = true;
        }
        if (CollectionUtils.isNotEmpty(userIdList)) {
            Set userIds = userIdList.stream().map(Object::toString).collect(Collectors.toSet());
            List userForumImgCache = this.redisHashMapAdapter.multiGet(RedisConfig.USER_FORUM_IMG, userIds, String.class);
            if (CollectionUtils.isNotEmpty((Collection)userForumImgCache)) {
                userForumImgCache.forEach(userCache -> {
                    UserImgVo userImgVo = (UserImgVo)JSON.parseObject((String)userCache, UserImgVo.class);
                    if (null != userImgVo) {
                        userIdList.remove(userImgVo.getUserId());
                        userImgVoList.add(userImgVo);
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(userIdList)) {
                userImgVoList.addAll(this.batchLoadUserImgVoToRedis(userIdList));
            }
        }
        if (hasCurrent && (userImgVo = this.convertPostToUserImg(forumPostVoList = this.forumPostMapper.batchGetUserPosts(Collections.singletonList(currentUserId), this.userProperties.getAdvertTopicId(), Integer.valueOf(1)), currentUserId)) != null) {
            userImgVoList.add(userImgVo);
        }
        return userImgVoList;
    }

    @Override
    public void cacheUserPostImg(Date startTime) {
        List userIdList = this.forumPostMapper.getUpdatedUser(startTime);
        this.batchLoadUserImgVoToRedis(userIdList);
    }

    @Override
    public TopicFacadeVO getTopicByForumId(Long forumId) {
        TopicVo topicVo;
        List relationList = this.forumTopicMapper.getPostTopicRelation(Collections.singletonList(forumId));
        if (CollectionUtils.isEmpty((Collection)relationList)) {
            return null;
        }
        List<TopicVo> topicVoList = this.forumTopicService.getTopicList(null);
        if (CollectionUtils.isNotEmpty(topicVoList)) {
            for (TopicVo topicVo2 : topicVoList) {
                if (!topicVo2.getId().equals(((RelationDTO)relationList.get(0)).getBid())) continue;
                return this.convert(topicVo2);
            }
        }
        if (Objects.nonNull(topicVo = this.forumTopicMapper.selectTopicById(((RelationDTO)relationList.get(0)).getBid(), null))) {
            return this.convert(topicVo);
        }
        return null;
    }

    @Override
    public TopicFacadeVO getTopicById(Long id) {
        TopicVo topicVo = this.forumTopicService.getTopicDetail(id, null, null);
        if (Objects.isNull(topicVo)) {
            return null;
        }
        return this.convert(topicVo);
    }

    private TopicFacadeVO convert(TopicVo topicVo) {
        TopicFacadeVO facadeVO = new TopicFacadeVO();
        facadeVO.setId(topicVo.getId());
        facadeVO.setTitle(topicVo.getTitle());
        facadeVO.setDescp(topicVo.getDescp());
        facadeVO.setImg(topicVo.getImg());
        facadeVO.setParticipantsNum(topicVo.getParticipantsNum());
        facadeVO.setAppletShareUrl(topicVo.getAppletShareUrl());
        facadeVO.setShareUrl(topicVo.getShareUrl());
        facadeVO.setLeadPostContent(topicVo.getLeadPostContent());
        facadeVO.setRecommendContent(topicVo.getRecommendContent());
        facadeVO.setJoinCode(topicVo.getJoinCode());
        facadeVO.setJoinHeadImgList(topicVo.getJoinHeadImgList());
        facadeVO.setContent(topicVo.getContent());
        return facadeVO;
    }

    private List<UserImgVo> batchLoadUserImgVoToRedis(List<Long> userIdList) {
        log.info("============\u9700\u8981\u4ece\u6570\u636e\u5e93\u83b7\u53d6\u56fe\u7247\u7684idList : {}", (Object)JSON.toJSONString(userIdList));
        ArrayList<UserImgVo> userImgVoList = new ArrayList<UserImgVo>();
        if (CollectionUtils.isEmpty(userIdList)) {
            return userImgVoList;
        }
        List forumPostVoList = this.forumPostMapper.batchGetUserPosts(userIdList, this.userProperties.getAdvertTopicId(), Integer.valueOf(0));
        log.info("==============\u6570\u636e\u5e93\u83b7\u53d6\u503c\u7ed3\u679c\u96c6 forumPostVoList \uff1a{}  ", (Object)JSON.toJSONString((Object)forumPostVoList));
        if (CollectionUtils.isEmpty((Collection)forumPostVoList)) {
            return userImgVoList;
        }
        Map<Long, List<ForumPostVo>> userForumPostMap = forumPostVoList.stream().collect(Collectors.groupingBy(ForumBasicVo::getUserId));
        HashMap userImgVoMap = Maps.newHashMap();
        userIdList.forEach(userId -> {
            log.info("== userId: {}", userId);
            UserImgVo userImgVo = this.convertPostToUserImg((List)userForumPostMap.get(userId), (Long)userId);
            log.info("== userImgVo: {}", (Object)JSON.toJSONString((Object)userImgVo));
            userImgVoMap.put(userId.toString(), JSON.toJSONString((Object)userImgVo));
            if (null != userImgVo) {
                userImgVoList.add(userImgVo);
            }
        });
        log.info("============= result : {}", (Object)JSON.toJSONString((Object)userImgVoMap));
        if (userImgVoMap.size() > 0) {
            this.redisHashMapAdapter.putAll(RedisConfig.USER_FORUM_IMG, (Map)userImgVoMap);
        }
        return userImgVoList;
    }

    private UserImgVo convertPostToUserImg(List<ForumPostVo> forumPostVos, Long userId) {
        if (CollectionUtils.isEmpty(forumPostVos)) {
            return null;
        }
        int size = 0;
        ArrayList<ImgDTO> imgDtoList = new ArrayList<ImgDTO>();
        for (ForumPostVo forumPostVo : forumPostVos) {
            List postImgVoList = forumPostVo.getPostImgList();
            if (CollectionUtils.isNotEmpty((Collection)postImgVoList)) {
                for (PostImgVo postImgVo : postImgVoList) {
                    if (!"IMG".equals(postImgVo.getType())) continue;
                    ImgDTO imgDto = new ImgDTO();
                    imgDto.setId(forumPostVo.getId());
                    imgDto.setCategory("POST");
                    imgDto.setType(postImgVo.getType());
                    imgDto.setImgUrl(postImgVo.getImgUrl());
                    imgDtoList.add(imgDto);
                    if (++size < 4) continue;
                    break;
                }
            }
            if (size < 4) continue;
            break;
        }
        UserImgVo userImgVo = new UserImgVo();
        userImgVo.setUserId(userId);
        userImgVo.setImgDtoList(imgDtoList);
        return userImgVo;
    }

    @Override
    public ForumPostVo getForumPostById(Long id) {
        return this.forumPostMapper.selectBasicPostById(id);
    }

    @Override
    public List<ForumRankVo> forumRank(String areaCode, List<Long> userIds) {
        List list = this.forumPostMapper.getForumRankInfo(areaCode, userIds);
        list.forEach(item -> item.setPostTitleInfo(this.fill(item.getUserId())));
        return list.size() > 0 ? list : new ArrayList();
    }

    private List<ForumPostTitleInfoVo> fill(Long userId) {
        List list = this.forumPostMapper.selectPostTitletByUserId(userId);
        ForumPostFillContext context = ForumPostFillContext.builder().data(list).fillTitle(true).loadCollectStatus(false).loadComment(false).loadHotReplay(false).loadLikeStatus(false).build();
        this.postListService.fillExtInfo(context);
        return list.stream().map(item -> {
            ForumPostTitleInfoVo forumPostTitleInfoVo = new ForumPostTitleInfoVo();
            forumPostTitleInfoVo.setId(item.getId());
            forumPostTitleInfoVo.setTitle(item.getTitle());
            return forumPostTitleInfoVo;
        }).collect(Collectors.toList());
    }

    @Override
    public ForumPostRankForUserVo forumRankForUser(Long userId) {
        return this.forumPostMapper.getForumRankInfoForUser(userId);
    }

    @Override
    public List<InteractRankInfo> getInteractRankInfo(String areaCode, int limitNum, List<Long> userIds) {
        return this.newsReplyMapper.selectInteractRankInfo(areaCode, limitNum, userIds);
    }

    @Override
    public Integer replyNumForUser(Long userId) {
        return this.newsReplyMapper.getReplyNumById(userId);
    }

    @Override
    public List<RecommendUserFacadeVo> getRecommendUserInfo(String areaCode, List<Long> userIds) {
        return this.forumPostMapper.getRecommendUserInfo(areaCode, CollectionUtils.isEmpty(userIds) ? Lists.newArrayList((Object[])new Long[]{0L}) : userIds);
    }
}

