/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.post.impl;

import com.alibaba.fastjson.JSONArray;
import com.bxm.localnews.integration.MissionIntegrationService;
import com.bxm.localnews.integration.UserAccountIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.news.constant.MemoryCacheKey;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.domain.ForumTopicMapper;
import com.bxm.localnews.news.domain.MixedRecommendPoolMapper;
import com.bxm.localnews.news.dto.NewsCompleTaskDTO;
import com.bxm.localnews.news.enums.PostStatusEnum;
import com.bxm.localnews.news.enums.TaskEnum;
import com.bxm.localnews.news.factory.ExtendFactory;
import com.bxm.localnews.news.model.dto.PostTopicDTO;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.post.ForumPostService;
import com.bxm.localnews.news.util.OssTransCodeUtils;
import com.bxm.localnews.news.vo.PostImgVo;
import com.bxm.localnews.news.vo.TranscodeMap;
import com.bxm.localnews.param.AccountGoldParam;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.sync.core.CacheHolder;
import com.bxm.newidea.component.vo.Message;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ForumPostServiceImpl
extends BaseService
implements ForumPostService {
    private static final Logger log = LogManager.getLogger(ForumPostServiceImpl.class);
    private ForumPostMapper forumPostMapper;
    private MixedRecommendPoolMapper mixedRecommendPoolMapper;
    private UserIntegrationService userIntegrationService;
    private UserAccountIntegrationService userAccountIntegrationService;
    private OssTransCodeUtils ossTransCodeUtils;
    private ForumTopicMapper forumTopicMapper;
    private MissionIntegrationService missionIntegrationService;
    private CacheHolder cacheHolder;

    @Override
    public Message deleteForumPost(Long id) {
        ForumPostVo forumPostVo = this.forumPostMapper.selectWithoutContent(id);
        String result = this.checkPostInfo(forumPostVo);
        if (StringUtils.isNotBlank((CharSequence)result)) {
            return Message.build((boolean)Boolean.FALSE, (String)result);
        }
        ForumPostVo updatePost = new ForumPostVo();
        updatePost.setId(id);
        updatePost.setModifyTime(new Date());
        updatePost.setStatus(PostStatusEnum.USER_DELETE.getCode());
        this.forumPostMapper.updateByPrimaryKeySelective(updatePost);
        this.mixedRecommendPoolMapper.deleteMixRecommandPoolById(id);
        Integer goldNum = this.userAccountIntegrationService.countGoldByPostId(id, forumPostVo.getUserId());
        if (null != goldNum && goldNum > 0) {
            String content = "\u5220\u9664\u3010" + ExtendFactory.getPostContent((String)forumPostVo.getTitle(), (String)forumPostVo.getTextField()) + "\u3011";
            this.userAccountIntegrationService.addGold(AccountGoldParam.buildPostDeleteParam((Long)forumPostVo.getUserId(), (int)(-goldNum.intValue()), (Long)id, (String)content));
        }
        this.userIntegrationService.addPostReplyNum(forumPostVo.getUserId(), Integer.valueOf(2));
        return Message.build((boolean)Boolean.TRUE);
    }

    @Override
    public Boolean getContentUpdate(Date lastRequestTime, String areaCode) {
        if (Objects.isNull(lastRequestTime)) {
            return true;
        }
        Date maxPublishTime = (Date)this.cacheHolder.get(MemoryCacheKey.LAST_POST_TIME_CACHE, areaCode);
        if (null != maxPublishTime) {
            return maxPublishTime.compareTo(lastRequestTime) > 0;
        }
        return false;
    }

    public void init() {
        this.cacheHolder.set(MemoryCacheKey.LAST_POST_TIME_CACHE, areaCode -> this.forumPostMapper.selectMaxPublishTime(areaCode), 200L, TimeUnit.SECONDS, 10L);
    }

    @Override
    public void execTransCode(Long postId, String imageList, List<PostImgVo> postImgList) {
        if (postImgList == null) {
            postImgList = Lists.newArrayList();
        }
        if (null != imageList) {
            postImgList.addAll(JSONArray.parseArray((String)imageList, PostImgVo.class));
        }
        postImgList.forEach(postImgVo -> {
            if ("VIDEO".equalsIgnoreCase(postImgVo.getType())) {
                this.ossTransCodeUtils.transcodeByOriginUrl(postImgVo.getVideoUrl(), postId, destUrl -> {
                    TranscodeMap transcodeMap = new TranscodeMap();
                    transcodeMap.setOriginUrl("");
                    transcodeMap.setDestUrl(destUrl);
                    transcodeMap.setPostId(postId);
                    this.forumPostMapper.batchUpdatePostVideo(transcodeMap);
                });
            }
        });
    }

    @Override
    @Async
    public void doTriggerUpdateInfo(Long userId, String nickname, String headImg) {
        List forumPostVoList = this.forumPostMapper.selectForumPostByUser(userId);
        for (ForumPostVo forumPostVo : forumPostVoList) {
            this.forumPostMapper.updateUserInfo(forumPostVo.getId(), userId, headImg, nickname);
        }
    }

    @Override
    public void updateTopic(Long postId, List<Long> topicIdList, Long secondTopicId) {
        if (null == postId) {
            return;
        }
        this.forumTopicMapper.batchDeleteTopic(postId);
        if (CollectionUtils.isNotEmpty(topicIdList)) {
            ArrayList list = new ArrayList();
            topicIdList.forEach(topicId -> list.add(this.getPostTopic(postId, (Long)topicId, secondTopicId)));
            this.forumTopicMapper.batchInsertTopic(list);
        }
    }

    private PostTopicDTO getPostTopic(Long postId, Long topicId, Long secondTopicId) {
        PostTopicDTO postTopicDTO = new PostTopicDTO();
        postTopicDTO.setId(this.nextSequence());
        postTopicDTO.setPostId(postId);
        postTopicDTO.setTopicId(topicId);
        postTopicDTO.setSecondTopicId(Long.valueOf(secondTopicId == null ? 0L : secondTopicId));
        return postTopicDTO;
    }

    private String checkPostInfo(ForumPostVo forumPostVo) {
        String message = "";
        if (forumPostVo == null) {
            message = "\u5e16\u5b50\u4e0d\u5b58\u5728";
        } else if (forumPostVo.getIsCash() == 1) {
            message = "\u73b0\u91d1\u5956\u52b1\u5185\u5bb9\u5220\u9664\u9700\u8981\u8054\u7cfb\u5ba2\u670d\u54e6";
        } else if (forumPostVo.getIsBroke() == 1) {
            message = "\u7206\u6599\u5185\u5bb9\u5220\u9664\u9700\u8981\u8054\u7cfb\u5ba2\u670d\u54e6";
        } else if (forumPostVo.getIsRecommend() == 1) {
            message = "\u4f18\u8d28\u5934\u6761\u5220\u9664\u9700\u8981\u8054\u7cfb\u5ba2\u670d\u54e6";
        } else if (forumPostVo.getIsBrilliant() == 1) {
            message = "\u7cbe\u534e\u5185\u5bb9\u5220\u9664\u9700\u8981\u8054\u7cfb\u5ba2\u670d\u54e6";
        }
        return message;
    }

    @Override
    public NewsCompleTaskDTO completeTask(ForumPostVo forumPostVo) {
        Long userId = forumPostVo.getUserId();
        Long postId = forumPostVo.getId();
        String content = "\u9996\u6b21\u53d1\u5e03\u3010" + ExtendFactory.getPostContent((String)forumPostVo.getTitle(), (String)forumPostVo.getTextField()) + "\u3011";
        NewsCompleTaskDTO newsCompleTaskDTO = this.missionIntegrationService.compleTask(userId, TaskEnum.TASK_FIRST_POST_INTIVATION.name(), postId.toString(), content);
        if (null == newsCompleTaskDTO || null == newsCompleTaskDTO.getGoldNum() || 0L == newsCompleTaskDTO.getGoldNum()) {
            content = "\u53d1\u5e03\u3010" + ExtendFactory.getPostContent((String)forumPostVo.getTitle(), (String)forumPostVo.getTextField()) + "\u3011";
            newsCompleTaskDTO = this.missionIntegrationService.compleTask(userId, TaskEnum.TASK_POST_INTIVATION.name(), postId.toString(), content);
        }
        return newsCompleTaskDTO;
    }

    public ForumPostServiceImpl(ForumPostMapper forumPostMapper, MixedRecommendPoolMapper mixedRecommendPoolMapper, UserIntegrationService userIntegrationService, UserAccountIntegrationService userAccountIntegrationService, OssTransCodeUtils ossTransCodeUtils, ForumTopicMapper forumTopicMapper, MissionIntegrationService missionIntegrationService, CacheHolder cacheHolder) {
        this.forumPostMapper = forumPostMapper;
        this.mixedRecommendPoolMapper = mixedRecommendPoolMapper;
        this.userIntegrationService = userIntegrationService;
        this.userAccountIntegrationService = userAccountIntegrationService;
        this.ossTransCodeUtils = ossTransCodeUtils;
        this.forumTopicMapper = forumTopicMapper;
        this.missionIntegrationService = missionIntegrationService;
        this.cacheHolder = cacheHolder;
    }
}

