/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.post.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.base.integration.DomainIntegrationService;
import com.bxm.localnews.common.constant.DomainScene;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.integration.LocationIntegrationService;
import com.bxm.localnews.integration.PushMsgIntegService;
import com.bxm.localnews.news.config.ForumProperties;
import com.bxm.localnews.news.config.NewsProperties;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.enums.DisplayAreaEnum;
import com.bxm.localnews.news.list.PostListService;
import com.bxm.localnews.news.model.dto.HotForumListShareDTO;
import com.bxm.localnews.news.model.param.ForumPostFillContext;
import com.bxm.localnews.news.model.param.ForumPostListQueryParam;
import com.bxm.localnews.news.model.param.HotForumListShareParam;
import com.bxm.localnews.news.model.param.HotForumsParam;
import com.bxm.localnews.news.model.vo.ForumBasicVo;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.model.vo.HotForumPostVo;
import com.bxm.localnews.news.model.vo.TopicHotForumGuideInfo;
import com.bxm.localnews.news.post.HotPostService;
import com.bxm.localnews.news.recommend.RecommendPostService;
import com.bxm.localnews.news.util.PlaceHolderUtil;
import com.bxm.localnews.news.vo.HotForumDateBean;
import com.bxm.localnews.news.vo.PostImgVo;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.vo.PageWarper;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class HotPostServiceImpl
implements HotPostService {
    private static final Logger log = LoggerFactory.getLogger(HotPostServiceImpl.class);
    @Resource
    private ForumPostMapper forumPostMapper;
    @Resource
    private ForumProperties forumProperties;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;
    @Resource
    private PostListService postListService;
    @Resource
    private RedisSetAdapter redisSetAdapter;
    @Resource
    private PushMsgIntegService pushMsgIntegService;
    @Resource
    private DomainIntegrationService domainIntegrationService;
    @Resource
    private LocationIntegrationService locationIntegrationService;
    @Resource
    private NewsProperties newsProperties;
    private RecommendPostService recommendPostService;

    private RecommendPostService getRecommendPostService() {
        if (null == this.recommendPostService) {
            this.recommendPostService = (RecommendPostService)SpringContextHolder.getBean(RecommendPostService.class);
        }
        return this.recommendPostService;
    }

    @Override
    public PageWarper<HotForumPostVo> hotForumPost(HotForumsParam param) {
        PageWarper forumPostPage = new PageWarper();
        if (Objects.isNull(param.getAreaCode())) {
            forumPostPage.setList(Collections.emptyList());
            return forumPostPage;
        }
        List<HotForumPostVo> hotForums = this.getHotForumList(param.getAreaCode());
        if (CollectionUtils.isNotEmpty(hotForums)) {
            List<HotForumPostVo> subForums;
            hotForums = param.getViewType() == 0 ? hotForums : hotForums.subList(0, this.forumProperties.getHotForumTopViewNum() < hotForums.size() ? this.forumProperties.getHotForumTopViewNum().intValue() : hotForums.size());
            int start = (param.getPageNum() - 1) * param.getPageSize();
            int end = param.getPageNum() * param.getPageSize();
            if (start < 0) {
                start = 0;
            }
            if (end > hotForums.size()) {
                end = hotForums.size();
            }
            if (CollectionUtils.isEmpty(subForums = hotForums.subList(start, end))) {
                forumPostPage.setList(Collections.emptyList());
                forumPostPage.setIsLastPage(true);
                forumPostPage.setHasNextPage(false);
                return forumPostPage;
            }
            List hotForumIds = subForums.stream().map(ForumBasicVo::getId).collect(Collectors.toList());
            List<HotForumPostVo> result = this.forumPostMapper.ForumsListByIds(hotForumIds);
            List<HotForumPostVo> innerHotForums = hotForums;
            result.forEach(item -> innerHotForums.forEach(hotForumPostVo -> {
                if (Objects.equals(hotForumPostVo.getId(), item.getId())) {
                    item.setHotRank(hotForumPostVo.getHotRank());
                    item.setHotNum(this.forumHotNum(item.getDisplayDateTime(), hotForumPostVo.getHotNum()));
                }
            }));
            result = result.stream().sorted(Comparator.comparing(HotForumPostVo::getHotRank)).collect(Collectors.toList());
            forumPostPage.setList(result);
            forumPostPage.setPageNum(param.getPageNum().intValue());
            forumPostPage.setPageSize(param.getPageSize().intValue());
            this.postListService.fillExtInfo(ForumPostFillContext.builder().data(forumPostPage.getList()).userId(param.getUserId()).areaCode(param.getAreaCode()).fillTitle(false).displayArea(DisplayAreaEnum.OTHER).build());
            if (CollectionUtils.isEmpty(result) || result.size() < param.getPageSize()) {
                forumPostPage.setIsLastPage(true);
                forumPostPage.setHasNextPage(false);
            } else {
                forumPostPage.setHasNextPage(true);
            }
        }
        return forumPostPage;
    }

    @Override
    public List<HotForumPostVo> getHotForumList(String areaCode) {
        TypeReference<List<HotForumPostVo>> typeReference = new TypeReference<List<HotForumPostVo>>(){};
        List hotForumPostVos = (List)this.redisHashMapAdapter.get(RedisConfig.FORUM_HOT_LIST.copy(), areaCode, (TypeReference)typeReference);
        if (CollectionUtils.isEmpty((Collection)hotForumPostVos)) {
            return this.loadFromDb(areaCode);
        }
        return hotForumPostVos;
    }

    @Override
    public List<HotForumPostVo> loadFromDb(String areaCode) {
        List hotForums = this.forumPostMapper.hotListPost(areaCode, this.forumProperties.getHotForumLimitNum().intValue(), this.forumProperties.getHotForumDaysLimit().intValue());
        for (int i = 0; i < hotForums.size(); ++i) {
            ((HotForumPostVo)hotForums.get(i)).setHotRank(Integer.valueOf(i + 1));
        }
        if (CollectionUtils.isNotEmpty((Collection)hotForums)) {
            this.pushMsgForHotForums(hotForums);
            this.redisHashMapAdapter.put(RedisConfig.FORUM_HOT_LIST.copy(), areaCode, (Object)hotForums);
            this.redisHashMapAdapter.expire(RedisConfig.FORUM_HOT_LIST.copy(), 86400L);
        }
        return hotForums;
    }

    private Integer forumHotNum(Date displayTime, Integer hotNumOlder) {
        List list = JSONObject.parseArray((String)this.forumProperties.getHotForumDate(), HotForumDateBean.class);
        int diffDays = DateUtils.getDiffDays((Date)new Date(), (Date)displayTime, (boolean)true);
        for (HotForumDateBean hotForumDateBean : list) {
            if (hotForumDateBean.getDays() != diffDays) continue;
            return hotForumDateBean.getOfferst().multiply(BigDecimal.valueOf(hotNumOlder.intValue())).intValue();
        }
        return hotNumOlder;
    }

    private void pushMsgForHotForums(List<HotForumPostVo> hotForums) {
        hotForums.forEach(forum -> {
            if (!this.redisSetAdapter.exists(RedisConfig.FORUM_HOT_PUSH_KEY.copy(), (Object)forum.getId()).booleanValue()) {
                this.pushMsgIntegService.pushHotForum(forum);
                this.savePushForumToRedis(forum.getId());
            }
        });
    }

    private void savePushForumToRedis(Long forumId) {
        this.redisSetAdapter.add(RedisConfig.FORUM_HOT_PUSH_KEY.copy(), new Object[]{forumId});
    }

    @Override
    public HotForumListShareDTO hotForumsShareBaseInfo(HotForumListShareParam param) {
        LocationDTO locationDTO = this.locationIntegrationService.getLocationByGeocode(param.getAreaCode());
        String shareH5host = this.domainIntegrationService.getOutSideShareBaseUrl(DomainScene.DomainViewScene.WX_JS_VIEW);
        String shareUrl = null;
        try {
            shareUrl = shareH5host + this.newsProperties.getHotForumShareUrl() + "?userId=" + param.getUserId() + "&areaCode=" + param.getAreaCode() + "&areaName=" + URLEncoder.encode(locationDTO.getName(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return HotForumListShareDTO.builder().userId(param.getUserId()).title("\u65b0\u9c9c\u51fa\u7089\uff01" + locationDTO.getName() + "\u4e00\u5468\u70ed\u95e8\u8bdd\u9898\u699c\uff01").contentDesc("\u6211\u6b63\u5728\u770b" + locationDTO.getName() + "\u70ed\u95e8\u5185\u5bb9,\u5feb\u6765\u4e00\u8d77\u770b\u770b\u5427").imgUrl(this.newsProperties.getShareImgUrl()).shareUrl(shareUrl).shareButtonText(this.newsProperties.getShareButtonText()).build();
    }

    @Override
    public TopicHotForumGuideInfo loadTopicHotPost(ForumPostListQueryParam param, BasicParam basicParam) {
        String subKey = param.getTopicId() + param.getAreaCode();
        TopicHotForumGuideInfo hotPost = (TopicHotForumGuideInfo)this.redisHashMapAdapter.get(RedisConfig.TOPIC_HOT_POST_CACHE_KEY, subKey, TopicHotForumGuideInfo.class);
        if (hotPost == null || hotPost.getExpiredTime() < System.currentTimeMillis()) {
            hotPost = this.getTopicHotPost(param, basicParam);
            hotPost.setExpiredTime(System.currentTimeMillis() + 300000L);
            this.redisHashMapAdapter.put(RedisConfig.TOPIC_HOT_POST_CACHE_KEY, subKey, (Object)hotPost);
        }
        return hotPost;
    }

    private TopicHotForumGuideInfo getTopicHotPost(ForumPostListQueryParam param, BasicParam basicParam) {
        TopicHotForumGuideInfo topicHotForumGuideInfo = new TopicHotForumGuideInfo();
        ForumPostListQueryParam newParam = new ForumPostListQueryParam();
        BeanUtils.copyProperties((Object)param, (Object)newParam);
        newParam.setPageNum(Integer.valueOf(1));
        newParam.setPageSize(Integer.valueOf(5));
        newParam.setType(Integer.valueOf(0));
        boolean flag = true;
        do {
            List<Long> postIdList;
            if (CollectionUtils.isNotEmpty(postIdList = this.getRecommendPostService().getRecommendPostIds(newParam, basicParam))) {
                List postList = this.forumPostMapper.listPostByIds(postIdList);
                for (ForumPostVo forumPostVo : postList) {
                    if (!CollectionUtils.isNotEmpty((Collection)forumPostVo.getPostImgList())) continue;
                    this.convent(topicHotForumGuideInfo, forumPostVo, param);
                    flag = false;
                    break;
                }
                if (!Objects.isNull(topicHotForumGuideInfo.getImg())) continue;
                newParam.setPageNum(Integer.valueOf(newParam.getPageNum() + 1));
                continue;
            }
            flag = false;
        } while (flag);
        return topicHotForumGuideInfo;
    }

    private void convent(TopicHotForumGuideInfo topicHotForumGuideInfo, ForumPostVo forumPostVo, ForumPostListQueryParam param) {
        topicHotForumGuideInfo.setImg(((PostImgVo)forumPostVo.getPostImgList().get(0)).getImgUrl());
        topicHotForumGuideInfo.setClickCount(forumPostVo.getClickCount());
        topicHotForumGuideInfo.setTitle(StringUtils.isNotBlank((CharSequence)forumPostVo.getTitle()) ? forumPostVo.getTitle() : (StringUtils.isNotBlank((CharSequence)forumPostVo.getTextField()) ? forumPostVo.getTextField() : "\u5206\u4eab\u56fe\u7247"));
        LocationDTO locationDTO = new LocationDTO();
        if (StringUtils.isNotBlank((CharSequence)param.getAreaCode())) {
            locationDTO = this.locationIntegrationService.getLocationByGeocode(param.getAreaCode());
        }
        String title = PlaceHolderUtil.replace((String)topicHotForumGuideInfo.getTitle(), (String)"areaname", (String)locationDTO.getName(), (String)"\u672c\u5730");
        topicHotForumGuideInfo.setTitle(title);
        topicHotForumGuideInfo.setId(forumPostVo.getId());
    }
}

