/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.post.impl;

import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.news.config.PostCountProperties;
import com.bxm.localnews.news.post.PostCountService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PostCountServiceImpl
implements PostCountService {
    private static final Logger log = LoggerFactory.getLogger(PostCountServiceImpl.class);
    private final PostCountProperties postCountProperties;
    private static final BigDecimal ONE_HUNDRED = BigDecimal.valueOf(100L);
    private final UserIntegrationService userIntegrationService;

    @Override
    public long getInitialBasicNum(String areaCode, boolean isRecommend) {
        int end;
        int start;
        BigDecimal localUserNum = this.postCountProperties.getDefaultGlobalUserNum();
        if (StringUtils.isNotBlank((CharSequence)areaCode)) {
            if (areaCode.contains(",")) {
                areaCode = areaCode.split(",")[0];
            }
            if (StringUtils.isNotBlank((CharSequence)areaCode)) {
                localUserNum = this.postCountProperties.getDefaultLocalUserNum();
                localUserNum = localUserNum.add(BigDecimal.valueOf(this.userIntegrationService.getRegisterUserCount(areaCode)));
            }
        }
        if (isRecommend) {
            start = this.postCountProperties.getMinRecommendDefaultInitialBasicNumRate();
            end = this.postCountProperties.getMaxRecommendDefaultInitialBasicNumRate();
        } else {
            start = this.postCountProperties.getMinDefaultInitialBasicNumRate();
            end = this.postCountProperties.getMaxDefaultInitialBasicNumRate();
        }
        int rate = RandomUtils.nextInt((int)start, (int)(end + 1));
        return localUserNum.multiply(BigDecimal.valueOf(rate)).divide(ONE_HUNDRED, 0, RoundingMode.DOWN).longValue();
    }

    @Override
    public long getInitialBasicNum(String areaCode, Byte isRecommend) {
        return this.getInitialBasicNum(areaCode, Objects.equals(isRecommend, (byte)1));
    }

    @Override
    public long getFinalClickCount(long realClickCount, String areaCode, boolean isRecommend) {
        return this.getFinalClickCount(realClickCount, this.getInitialBasicNum(areaCode, isRecommend));
    }

    @Override
    public long getFinalClickCount(long realClickCount, long initialBasicNum) {
        try {
            BigDecimal initialBasicNumCal = BigDecimal.valueOf(initialBasicNum);
            BigDecimal log2RealClickCount = realClickCount > 0L ? BigDecimal.valueOf(Math.log(realClickCount) / Math.log(2.0)).setScale(10, RoundingMode.DOWN) : BigDecimal.ZERO;
            BigDecimal realClickCountCal = BigDecimal.valueOf(realClickCount);
            return initialBasicNumCal.multiply(BigDecimal.ONE.add(log2RealClickCount.divide(BigDecimal.TEN, 0, RoundingMode.DOWN))).add(realClickCountCal).longValue();
        }
        catch (Exception e) {
            log.error("\u8ba1\u7b97\u9605\u8bfb\u91cf\u5931\u8d25\uff0crealClickCount: {}, initialBasicNum: {}", new Object[]{realClickCount, initialBasicNum, e});
            return 0L;
        }
    }

    public PostCountServiceImpl(PostCountProperties postCountProperties, UserIntegrationService userIntegrationService) {
        this.postCountProperties = postCountProperties;
        this.userIntegrationService = userIntegrationService;
    }
}

