/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.post.impl;

import com.bxm.localnews.facade.NewsSyncFeignService;
import com.bxm.localnews.news.config.BizConfigProperties;
import com.bxm.localnews.news.domain.AdminForumPostMapper;
import com.bxm.localnews.news.enums.NewsTagTypeEnum;
import com.bxm.localnews.news.model.param.Keyword;
import com.bxm.localnews.news.model.vo.AdminForumPost;
import com.bxm.localnews.news.model.vo.PendingContent;
import com.bxm.localnews.news.model.vo.PostTag;
import com.bxm.localnews.news.post.AdminCommonTagService;
import com.bxm.localnews.news.post.PostTagService;
import com.bxm.newidea.component.uuid.SequenceCreater;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class PostTagServiceImpl
implements PostTagService {
    private final AdminForumPostMapper adminForumPostMapper;
    private final BizConfigProperties bizConfigProperties;
    private final NewsSyncFeignService newsSyncService;
    private final SequenceCreater sequenceCreater;
    private final AdminCommonTagService adminCommonTagService;

    @Override
    public void resetForumPostTag(AdminForumPost adminForumPost) {
        this.adminForumPostMapper.deletePostTag(adminForumPost.getId());
        this.savePostTag(adminForumPost);
    }

    @Override
    public void savePostTag(AdminForumPost adminForumPost) {
        if (!this.bizConfigProperties.getEnablePostTagParse().booleanValue()) {
            return;
        }
        PendingContent pendingContent = new PendingContent();
        pendingContent.setTitle(adminForumPost.getTitle());
        pendingContent.setContent(adminForumPost.getContent());
        ResponseEntity responseEntity = this.newsSyncService.analysisContent(pendingContent);
        if (responseEntity.getStatusCode().isError()) {
            return;
        }
        List tagList = (List)responseEntity.getBody();
        if (CollectionUtils.isNotEmpty((Collection)tagList)) {
            for (Keyword keyword : tagList) {
                PostTag postTag = new PostTag();
                postTag.setId(this.sequenceCreater.nextLongId());
                postTag.setName(keyword.getName());
                postTag.setTagType(NewsTagTypeEnum.TITLE_TAG.getCode());
                postTag.setWeight(Double.valueOf(keyword.getTfidfvalue()));
                postTag.setPostId(adminForumPost.getId());
                postTag.setTagId(Long.valueOf(this.adminCommonTagService.saveAndGetTag(keyword.getName())));
                this.adminForumPostMapper.savePostTag(postTag);
            }
        }
    }

    public PostTagServiceImpl(AdminForumPostMapper adminForumPostMapper, BizConfigProperties bizConfigProperties, NewsSyncFeignService newsSyncService, SequenceCreater sequenceCreater, AdminCommonTagService adminCommonTagService) {
        this.adminForumPostMapper = adminForumPostMapper;
        this.bizConfigProperties = bizConfigProperties;
        this.newsSyncService = newsSyncService;
        this.sequenceCreater = sequenceCreater;
        this.adminCommonTagService = adminCommonTagService;
    }
}

