/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.recommend.impl;

import com.bxm.localnews.facade.UserFeignService;
import com.bxm.localnews.news.config.LocalCrumbsProperties;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.ForumTopicMapper;
import com.bxm.localnews.news.model.vo.FriendCrumbsExtData;
import com.bxm.localnews.news.model.vo.LocalCrumbs;
import com.bxm.localnews.news.model.vo.LocalCrumbsListVO;
import com.bxm.localnews.news.model.vo.TopicCrumbsExtData;
import com.bxm.localnews.news.model.vo.TopicVo;
import com.bxm.localnews.news.recommend.LocalCircleService;
import com.bxm.localnews.vo.VirtualUserInfo;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class LocalCircleServiceImpl
implements LocalCircleService {
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;
    @Resource
    private ForumTopicMapper forumTopicMapper;
    @Resource
    private LocalCrumbsProperties localCrumbsProperties;
    @Resource
    private UserFeignService userFeignService;

    @Override
    public LocalCrumbsListVO getLocalCrumbsInfo(String userId, String areaCode) {
        if (StringUtils.isBlank((CharSequence)areaCode)) {
            return this.getEmptyResult();
        }
        LocalCrumbsListVO localCrumbsListVO = new LocalCrumbsListVO();
        ArrayList<LocalCrumbs> localCrumbsList = new ArrayList<LocalCrumbs>();
        LocalCrumbs topicSquareCrumbs = new LocalCrumbs();
        LocalCrumbs cityFriendsCrumbs = new LocalCrumbs();
        localCrumbsList.add(topicSquareCrumbs);
        localCrumbsList.add(cityFriendsCrumbs);
        localCrumbsListVO.setLocalCrumbsList(localCrumbsList);
        topicSquareCrumbs.setName(this.localCrumbsProperties.getTopicSquareTitle());
        cityFriendsCrumbs.setName(this.localCrumbsProperties.getCityFriendsTitle());
        topicSquareCrumbs.setType(Integer.valueOf(1));
        cityFriendsCrumbs.setType(Integer.valueOf(2));
        topicSquareCrumbs.setBackgroundImgUrl(this.localCrumbsProperties.getTopicSquareImgUrl());
        cityFriendsCrumbs.setBackgroundImgUrl(this.localCrumbsProperties.getCityFriendsImgUrl());
        topicSquareCrumbs.setJumpUrl(this.localCrumbsProperties.getTopicSquareJumpUrl());
        cityFriendsCrumbs.setJumpUrl(this.localCrumbsProperties.getCityFriendJumpUrl());
        KeyGenerator nationalCrumbsTotal = this.getNationalAreaTotal();
        KeyGenerator topicSquareAreaTotal = this.getCrumbsAreaTotalKey(1);
        KeyGenerator topicSquareReadCount = this.getCrumbsReadCount(1, areaCode);
        KeyGenerator cityFriendsAreaTotal = this.getCrumbsAreaTotalKey(2);
        KeyGenerator cityFriendsReadCount = this.getCrumbsReadCount(2, areaCode);
        long postTotal = 0L;
        long noteTotal = 0L;
        Long areaPostTotal = (Long)this.redisHashMapAdapter.get(topicSquareAreaTotal, areaCode, Long.class);
        Long areaNoteTotal = (Long)this.redisHashMapAdapter.get(cityFriendsAreaTotal, areaCode, Long.class);
        Long nationalPostTotal = (Long)this.redisHashMapAdapter.get(nationalCrumbsTotal, "1", Long.class);
        Long nationalNoteTotal = (Long)this.redisHashMapAdapter.get(nationalCrumbsTotal, "2", Long.class);
        if (nationalPostTotal != null) {
            postTotal += nationalPostTotal.longValue();
        }
        if (nationalNoteTotal != null) {
            noteTotal += nationalNoteTotal.longValue();
        }
        if (areaPostTotal != null) {
            postTotal += areaPostTotal.longValue();
        }
        if (areaNoteTotal != null) {
            noteTotal += areaNoteTotal.longValue();
        }
        if (Boolean.FALSE.equals(this.redisHashMapAdapter.exists(topicSquareReadCount, userId))) {
            this.redisHashMapAdapter.put(topicSquareReadCount, userId, (Object)0);
        }
        if (Boolean.FALSE.equals(this.redisHashMapAdapter.exists(cityFriendsReadCount, userId))) {
            this.redisHashMapAdapter.put(cityFriendsReadCount, userId, (Object)0);
        }
        Long currentUserReadPostCount = (Long)this.redisHashMapAdapter.get(topicSquareReadCount, userId, Long.class);
        Long currentUserReadNoteCount = (Long)this.redisHashMapAdapter.get(cityFriendsReadCount, userId, Long.class);
        if (postTotal > 0L && postTotal > currentUserReadPostCount) {
            topicSquareCrumbs.setLatestCount(Long.valueOf(postTotal - currentUserReadPostCount));
        }
        if (noteTotal > 0L && noteTotal > currentUserReadNoteCount) {
            cityFriendsCrumbs.setLatestCount(Long.valueOf(noteTotal - currentUserReadNoteCount));
        }
        TopicVo topicLatest = this.forumTopicMapper.getTopicLatest(areaCode, Integer.valueOf(1));
        FriendCrumbsExtData friendCrumbsExtData = new FriendCrumbsExtData();
        TopicCrumbsExtData topicCrumbsExtData = new TopicCrumbsExtData();
        topicSquareCrumbs.setExtData((Object)topicCrumbsExtData);
        cityFriendsCrumbs.setExtData((Object)friendCrumbsExtData);
        topicCrumbsExtData.setLatestTopicId(topicLatest.getId());
        topicCrumbsExtData.setLatestTopicTitle("#" + topicLatest.getTitle() + "#");
        int headImgNum = 5;
        List<VirtualUserInfo> virtualUserList = this.getVirtualUserList(5);
        List headImageList = virtualUserList.stream().map(VirtualUserInfo::getHeadImg).collect(Collectors.toList());
        friendCrumbsExtData.setHeadImages(headImageList);
        return localCrumbsListVO;
    }

    private LocalCrumbsListVO getEmptyResult() {
        LocalCrumbsListVO emptyResult = new LocalCrumbsListVO();
        ArrayList<LocalCrumbs> localCrumbsList = new ArrayList<LocalCrumbs>();
        LocalCrumbs topicSquareCrumbs = new LocalCrumbs();
        topicSquareCrumbs.setName(this.localCrumbsProperties.getTopicSquareTitle());
        topicSquareCrumbs.setLatestCount(Long.valueOf(0L));
        topicSquareCrumbs.setType(Integer.valueOf(1));
        topicSquareCrumbs.setJumpUrl(this.localCrumbsProperties.getTopicSquareJumpUrl());
        topicSquareCrumbs.setBackgroundImgUrl(this.localCrumbsProperties.getTopicSquareImgUrl());
        topicSquareCrumbs.setExtData(new Object());
        LocalCrumbs cityFriendsCrumbs = new LocalCrumbs();
        cityFriendsCrumbs.setName(this.localCrumbsProperties.getCityFriendsTitle());
        cityFriendsCrumbs.setLatestCount(Long.valueOf(0L));
        cityFriendsCrumbs.setType(Integer.valueOf(2));
        cityFriendsCrumbs.setJumpUrl(this.localCrumbsProperties.getCityFriendJumpUrl());
        cityFriendsCrumbs.setBackgroundImgUrl(this.localCrumbsProperties.getCityFriendsImgUrl());
        cityFriendsCrumbs.setExtData(new Object());
        localCrumbsList.add(topicSquareCrumbs);
        localCrumbsList.add(cityFriendsCrumbs);
        emptyResult.setLocalCrumbsList(localCrumbsList);
        FriendCrumbsExtData friendCrumbsExtData = new FriendCrumbsExtData();
        TopicCrumbsExtData topicCrumbsExtData = new TopicCrumbsExtData();
        topicSquareCrumbs.setExtData((Object)topicCrumbsExtData);
        cityFriendsCrumbs.setExtData((Object)friendCrumbsExtData);
        topicCrumbsExtData.setLatestTopicId(null);
        topicCrumbsExtData.setLatestTopicTitle("");
        int headImgNum = 5;
        List<VirtualUserInfo> virtualUserList = this.getVirtualUserList(5);
        List headImageList = virtualUserList.stream().map(VirtualUserInfo::getHeadImg).collect(Collectors.toList());
        friendCrumbsExtData.setHeadImages(headImageList);
        return emptyResult;
    }

    @Override
    public Boolean reportCrumbsInfo(Long userId, String areaCode, Integer type) {
        if (StringUtils.isBlank((CharSequence)areaCode)) {
            return Boolean.TRUE;
        }
        KeyGenerator crumbsAreaTotal = this.getCrumbsAreaTotalKey(type);
        KeyGenerator crumbsNationalTotal = this.getNationalAreaTotal();
        KeyGenerator crumbsReadCount = this.getCrumbsReadCount(type, areaCode);
        if (type == 1) {
            long postTotal = 0L;
            Long areaPostTotal = (Long)this.redisHashMapAdapter.get(crumbsAreaTotal, areaCode, Long.class);
            Long nationalPostTotal = (Long)this.redisHashMapAdapter.get(crumbsNationalTotal, String.valueOf(type), Long.class);
            if (areaPostTotal != null) {
                postTotal += areaPostTotal.longValue();
            }
            if (nationalPostTotal != null) {
                postTotal += nationalPostTotal.longValue();
            }
            if (postTotal > 0L) {
                this.redisHashMapAdapter.put(crumbsReadCount, String.valueOf(userId), (Object)postTotal);
            }
        } else {
            long noteTotal = 0L;
            Long areaNoteTotal = (Long)this.redisHashMapAdapter.get(crumbsAreaTotal, areaCode, Long.class);
            Long nationalNoteTotal = (Long)this.redisHashMapAdapter.get(crumbsNationalTotal, String.valueOf(type), Long.class);
            if (areaNoteTotal != null) {
                noteTotal += areaNoteTotal.longValue();
            }
            if (nationalNoteTotal != null) {
                noteTotal += nationalNoteTotal.longValue();
            }
            if (noteTotal > 0L) {
                this.redisHashMapAdapter.put(crumbsReadCount, String.valueOf(userId), (Object)noteTotal);
            }
        }
        return Boolean.TRUE;
    }

    public List<VirtualUserInfo> getVirtualUserList(Integer num) {
        ResponseEntity response = this.userFeignService.getVirtualUserList(num);
        if (response.hasBody()) {
            return (List)response.getBody();
        }
        return Lists.newArrayList();
    }

    public KeyGenerator getCrumbsAreaTotalKey(int type) {
        return RedisConfig.CRUMBS_AREA_TOTAL.copy().appendKey((Object)type);
    }

    public KeyGenerator getCrumbsReadCount(int type, String areaCode) {
        return RedisConfig.CRUMBS_READ_COUNT.copy().appendKey((Object)type).appendKey((Object)areaCode);
    }

    public KeyGenerator getNationalAreaTotal() {
        return RedisConfig.NATIONAL_AREA_TOTAL.copy();
    }
}

