/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.recommend.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.integration.AdminMixRecommendPoolService;
import com.bxm.localnews.integration.AdvertIntegrationService;
import com.bxm.localnews.integration.NewsRecommendIntegrationService;
import com.bxm.localnews.news.config.AdvertProperties;
import com.bxm.localnews.news.config.BizConfigProperties;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.convert.ForumParamPageConvert;
import com.bxm.localnews.news.domain.AdminMixedRecommendPoolMapper;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.enums.DisplayAreaEnum;
import com.bxm.localnews.news.enums.MixRecommendTypeEnum;
import com.bxm.localnews.news.enums.PostStatusEnum;
import com.bxm.localnews.news.list.PostListService;
import com.bxm.localnews.news.model.param.ForumPostFillContext;
import com.bxm.localnews.news.model.param.ForumPostListQueryParam;
import com.bxm.localnews.news.model.vo.AdminForumPost;
import com.bxm.localnews.news.model.vo.AdminMixedRecommendPool;
import com.bxm.localnews.news.model.vo.AdvertVO;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.model.vo.TopicVo;
import com.bxm.localnews.news.post.HotPostService;
import com.bxm.localnews.news.recommend.RecommendPostService;
import com.bxm.localnews.news.recommend.TopicForumService;
import com.bxm.localnews.news.topic.ForumTopicService;
import com.bxm.localnews.news.util.ForumPostTypeUtil;
import com.bxm.localnews.news.util.VersionUtils;
import com.bxm.localnews.news.vo.AdvertIndexBean;
import com.bxm.localnews.param.ForumParam;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.vo.PageWarper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RecommendPostServiceImpl
implements RecommendPostService {
    private static final Logger log = LoggerFactory.getLogger(RecommendPostServiceImpl.class);
    private BizConfigProperties bizConfigProperties;
    private ForumPostMapper forumPostMapper;
    private PostListService postListService;
    private TopicForumService topicForumService;
    private HotPostService hotPostService;
    private AdvertProperties advertProperties;
    private AdvertIntegrationService advertIntegrationService;
    private ForumTopicService forumTopicService;
    private RedisHashMapAdapter redisHashMapAdapter;
    private NewsRecommendIntegrationService newsRecommendIntegrationService;
    private ForumParamPageConvert forumParamPageConvert;
    private AdminMixedRecommendPoolMapper adminMixedRecommendPoolMapper;
    private AdminMixRecommendPoolService adminMixRecommendPoolService;

    @Override
    public PageWarper<ForumPostVo> listForumPost(ForumPostListQueryParam param, BasicParam basicParam) {
        log.debug("\u83b7\u53d6\u63a8\u8350\u6d41,param:{}\uff0cbasicParam:{}", JSONObject.toJSON((Object)param), (Object)basicParam);
        PageWarper forumPostPage = new PageWarper();
        if (StringUtils.isBlank((CharSequence)param.getAreaCode())) {
            log.warn("\u83b7\u53d6\u63a8\u8350\u6d41\uff0c\u533a\u57df\u7f16\u7801\u4e3a\u7a7a\uff0c\u8fd4\u56de\u7a7a\u6570\u636e");
            forumPostPage.setList(Collections.emptyList());
            return forumPostPage;
        }
        List postIdList = PlatformEnum.APPLET.getCode() == basicParam.getPlatform() && this.bizConfigProperties.getAppletReviewEnable() != false && 3 == param.getType() ? this.forumPostMapper.listPostRecommend(param) : this.getRecommendPostIds(param, basicParam);
        if (CollectionUtils.isNotEmpty(postIdList)) {
            List postList = this.forumPostMapper.listPostByIds(postIdList);
            forumPostPage.setList(postList);
            forumPostPage.setPageNum(param.getPageNum().intValue());
            forumPostPage.setPageSize(param.getPageSize().intValue());
            ForumPostFillContext context = ForumPostFillContext.builder().data(forumPostPage.getList()).userId(param.getUserId()).areaCode(param.getAreaCode()).fillTitle(false).loadHotReplay(true).displayArea(DisplayAreaEnum.OTHER).build();
            this.postListService.fillExtInfo(context);
            if (3 == param.getType() && postIdList.size() >= 3) {
                if (VersionUtils.isHighVersion((String)basicParam.getCurVer(), (String)"2.5.0") > 0 && VersionUtils.isHighVersion((String)basicParam.getCurVer(), (String)"3.10.0") < 0) {
                    this.addRecommendTopic(param, (PageWarper<ForumPostVo>)forumPostPage, postList);
                }
                if (VersionUtils.isHighVersion((String)basicParam.getCurVer(), (String)"3.9.0") > 0) {
                    forumPostPage.setList((List)this.topicForumService.recommendTopic(postList, 2, param.getUserId(), param.getAreaCode()));
                }
            }
        }
        this.afterLogic(param, (PageWarper<ForumPostVo>)forumPostPage, basicParam);
        if (CollectionUtils.isEmpty((Collection)postIdList) || postIdList.size() < param.getPageSize()) {
            forumPostPage.setIsLastPage(true);
            forumPostPage.setHasNextPage(false);
        } else {
            forumPostPage.setHasNextPage(true);
        }
        log.debug("[listForumPost]\u62c9\u53d6\u5e16\u5b50\u5217\u8868\u5b8c\u6bd5");
        return forumPostPage;
    }

    private void afterLogic(ForumPostListQueryParam param, PageWarper<ForumPostVo> forumPostPage, BasicParam basicParam) {
        this.addAdvert(param, forumPostPage);
        if (param.getType() == 2 && VersionUtils.isHighVersion((String)basicParam.getCurVer(), (String)"3.9.0") > 0 && param.getPageNum() == 1 && CollectionUtils.isNotEmpty((Collection)forumPostPage.getList())) {
            ForumPostVo forumPostVo = new ForumPostVo();
            forumPostVo.setTopicHotForumGuideInfo(this.hotPostService.loadTopicHotPost(param, basicParam));
            List list = forumPostPage.getList();
            if (CollectionUtils.isEmpty((Collection)list)) {
                return;
            }
            list.add(0, forumPostVo);
            forumPostPage.setList(list);
        }
    }

    private void addAdvert(ForumPostListQueryParam param, PageWarper<ForumPostVo> forumPostPage) {
        if (StringUtils.isBlank((CharSequence)param.getAreaCode())) {
            log.warn("\u57ce\u5e02\u7f16\u7801\u4e3a\u7a7a \u8df3\u8fc7\u63d2\u5165\u5e7f\u544a\u4fe1\u606f\u6d41");
            return;
        }
        List list = forumPostPage.getList();
        if (CollectionUtils.isEmpty((Collection)list) || Objects.nonNull(param.getTopicId()) || Objects.nonNull(param.getChannelIds())) {
            return;
        }
        if (param.getPageNum() == 1) {
            List listIndex = JSONObject.parseArray((String)this.advertProperties.getForumIndex(), AdvertIndexBean.class);
            listIndex.forEach(advertIndexBean -> {
                List advertList = this.advertIntegrationService.getAdvertsByType(advertIndexBean.getAdvertType(), param.getAreaCode(), null);
                if (advertList.size() > 0) {
                    list.add(list.size() >= advertIndexBean.getIndex() ? advertIndexBean.getIndex() - 1 : list.size(), this.convert(advertList));
                }
            });
            forumPostPage.setList(list);
        }
    }

    private ForumPostVo convert(List<AdvertVO> list) {
        ForumPostVo forumPostVo = new ForumPostVo();
        forumPostVo.setAdvertList(list);
        return forumPostVo;
    }

    private void addRecommendTopic(ForumPostListQueryParam param, PageWarper<ForumPostVo> forumPostPage, List<ForumPostVo> postList) {
        if (StringUtils.isBlank((CharSequence)param.getAreaCode())) {
            log.warn("\u57ce\u5e02\u7f16\u7801\u4e3a\u7a7a\uff0c\u8c03\u8fc7\u63d2\u5165\u63a8\u8350\u8bdd\u9898");
            return;
        }
        List<Object> topicVoList = this.forumTopicService.getTopicList(param.getAreaCode());
        if (CollectionUtils.isNotEmpty(topicVoList)) {
            Integer order;
            if (topicVoList.size() > 6) {
                topicVoList = topicVoList.stream().limit(6L).collect(Collectors.toList());
            }
            if (null == (order = (Integer)this.redisHashMapAdapter.get(RedisConfig.USER_READ_RECOMMEND_TOPIC.copy(), param.getUserId() + "", Integer.class)) || (order = Integer.valueOf(order + 1)) >= topicVoList.size()) {
                order = 0;
            }
            this.redisHashMapAdapter.put(RedisConfig.USER_READ_RECOMMEND_TOPIC.copy(), param.getUserId() + "", (Object)order);
            TopicVo topic = (TopicVo)topicVoList.get(order);
            ArrayList<ForumPostVo> newPostList = new ArrayList<ForumPostVo>();
            for (int i = 0; i < postList.size(); ++i) {
                if (i == 3) {
                    ForumPostVo forumPostVo = new ForumPostVo();
                    forumPostVo.setRecommendTopicVo(topic);
                    newPostList.add(forumPostVo);
                }
                newPostList.add(postList.get(i));
            }
            forumPostPage.setList(newPostList);
        }
    }

    @Override
    public List<Long> getRecommendPostIds(ForumPostListQueryParam param, BasicParam basicParam) {
        ForumParam forumParam = (ForumParam)this.forumParamPageConvert.convert(param);
        Objects.requireNonNull(forumParam).setPlatform(Integer.valueOf(basicParam.getPlatform()));
        forumParam.setChannelIds(param.getChannelIds());
        return this.newsRecommendIntegrationService.recommendList(forumParam);
    }

    @Override
    public void updateRecommendWhenChanged(AdminForumPost adminForumPost) {
        Byte isBrilliant = adminForumPost.getIsBrilliant();
        Integer status = adminForumPost.getStatus();
        AdminMixedRecommendPool result = this.adminMixedRecommendPoolMapper.selectByPrimaryKey(adminForumPost.getId());
        if (Objects.equals(PostStatusEnum.NORMAL.getCode(), status)) {
            if (Objects.nonNull(result)) {
                Byte auto = result.getAuto();
                if (Objects.equals(isBrilliant, (byte)0) && (Objects.isNull(auto) || auto == 0)) {
                    this.adminMixedRecommendPoolMapper.deleteByPrimaryKey(result.getId());
                } else {
                    AdminMixedRecommendPool adminMixedRecommendPool = AdminMixedRecommendPool.builder().id(adminForumPost.getId()).title(adminForumPost.getTitle()).issueTime(adminForumPost.getDisplayTime()).publishTime(adminForumPost.getPublishTime()).author(adminForumPost.getUserName()).userId(adminForumPost.getUserId()).areaDetail(StringUtils.isNotBlank((CharSequence)adminForumPost.getAreaCode()) ? adminForumPost.getAreaCode() : null).weight(result.getWeight()).auto(result.getAuto()).recommendTime(result.getRecommendTime()).optimizationNotice(result.getOptimizationNotice()).deliveryType(adminForumPost.getDeliveryType()).type(ForumPostTypeUtil.getPostType(adminForumPost)).origin(MixRecommendTypeEnum.MIX_POST.getCode()).build();
                    this.adminMixRecommendPoolService.updateMixRecommend(adminMixedRecommendPool);
                }
            } else if (Objects.equals(isBrilliant, (byte)1)) {
                this.adminMixRecommendPoolService.addPostToRecommendPoolAuto(adminForumPost);
            }
        } else if (Objects.nonNull(result)) {
            this.adminMixedRecommendPoolMapper.deleteByPrimaryKey(result.getId());
        }
    }

    @Override
    public void cancelRecommend(Long postId) {
        this.adminMixedRecommendPoolMapper.deleteByPrimaryKey(postId);
    }

    public RecommendPostServiceImpl(BizConfigProperties bizConfigProperties, ForumPostMapper forumPostMapper, PostListService postListService, TopicForumService topicForumService, HotPostService hotPostService, AdvertProperties advertProperties, AdvertIntegrationService advertIntegrationService, ForumTopicService forumTopicService, RedisHashMapAdapter redisHashMapAdapter, NewsRecommendIntegrationService newsRecommendIntegrationService, ForumParamPageConvert forumParamPageConvert, AdminMixedRecommendPoolMapper adminMixedRecommendPoolMapper, AdminMixRecommendPoolService adminMixRecommendPoolService) {
        this.bizConfigProperties = bizConfigProperties;
        this.forumPostMapper = forumPostMapper;
        this.postListService = postListService;
        this.topicForumService = topicForumService;
        this.hotPostService = hotPostService;
        this.advertProperties = advertProperties;
        this.advertIntegrationService = advertIntegrationService;
        this.forumTopicService = forumTopicService;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.newsRecommendIntegrationService = newsRecommendIntegrationService;
        this.forumParamPageConvert = forumParamPageConvert;
        this.adminMixedRecommendPoolMapper = adminMixedRecommendPoolMapper;
        this.adminMixRecommendPoolService = adminMixRecommendPoolService;
    }
}

