/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.recommend.impl;

import com.bxm.localnews.news.config.NewsProperties;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.model.vo.TopicForumInfo;
import com.bxm.localnews.news.model.vo.TopicVo;
import com.bxm.localnews.news.recommend.TopicForumService;
import com.bxm.localnews.news.topic.ForumTopicService;
import com.bxm.localnews.news.vo.News4Client;
import com.bxm.localnews.news.vo.PostImgVo;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class TopicForumServiceImpl
implements TopicForumService {
    private static final Logger log = LogManager.getLogger(TopicForumServiceImpl.class);
    private NewsProperties newsProperties;
    private ForumPostMapper forumPostMapper;
    private RedisHashMapAdapter redisHashMapAdapter;
    private ForumTopicService forumTopicService;
    private static final int TOUTIAO_INDEX = 5;
    private static final int BENDIQUAN_INDEX = 3;

    @Override
    public List<TopicForumInfo> loadForumInfosByTopicId(Long topicId, String areaCode) {
        ArrayList<TopicForumInfo> result = new ArrayList<TopicForumInfo>();
        String subKey = topicId.toString().trim() + "#" + areaCode.trim();
        List forumPostVos = this.forumPostMapper.getForumListByTopicId(topicId, this.newsProperties.getTopicForumLimit(), areaCode);
        if (CollectionUtils.isEmpty((Collection)forumPostVos)) {
            TopicForumInfo topicForumInfo = TopicForumInfo.builder().newsId(Long.valueOf(0L)).headImg("null").img("null").nickName("null").userId(Long.valueOf(0L)).build();
            result.add(topicForumInfo);
            this.redisHashMapAdapter.put(this.buildKey(), subKey, result);
            return result;
        }
        forumPostVos.forEach(forumPostVo -> {
            TopicForumInfo topicForumInfo = TopicForumInfo.builder().newsId(forumPostVo.getId()).userId(forumPostVo.getUserId()).nickName(Objects.nonNull(forumPostVo.getUserName()) ? forumPostVo.getUserName() : null).img(((PostImgVo)forumPostVo.getPostImgList().get(0)).getImgUrl()).headImg(Objects.nonNull(forumPostVo.getUserImg()) ? forumPostVo.getUserImg() : null).build();
            result.add(topicForumInfo);
        });
        this.redisHashMapAdapter.put(this.buildKey(), subKey, result);
        return result;
    }

    @Override
    public List<TopicForumInfo> getForumInfosByTopicId(Long topicId, String areaCode) {
        TypeReference<List<TopicForumInfo>> typeReference = new TypeReference<List<TopicForumInfo>>(){};
        List<TopicForumInfo> result = (List<TopicForumInfo>)this.redisHashMapAdapter.get(this.buildKey(), topicId.toString().trim() + "#" + areaCode.trim(), (TypeReference)typeReference);
        return CollectionUtils.isNotEmpty((Collection)result) ? result : this.loadForumInfosByTopicId(topicId, areaCode);
    }

    @Override
    public Object recommendTopic(Object param, Integer type, Long userId, String areaCode) {
        log.info("areaCode : {}", (Object)areaCode);
        List<Object> topicVoList = this.forumTopicService.getTopicList(areaCode);
        if (CollectionUtils.isEmpty(topicVoList)) {
            return param;
        }
        log.info("==========recommendTopic \u539f\u59cb\u8bdd\u9898\u5217\u8868 \uff1a {}", topicVoList);
        if (topicVoList.size() > this.newsProperties.getRecommendTopicOrderNum()) {
            topicVoList = topicVoList.stream().limit(this.newsProperties.getRecommendTopicOrderNum()).collect(Collectors.toList());
        }
        log.info("==========recommendTopic \u53d6\u6743\u91cd\u524d6\u8bdd\u9898\u5217\u8868 \uff1a {}", topicVoList);
        topicVoList = topicVoList.stream().filter(item -> {
            List<TopicForumInfo> list1 = this.getForumInfosByTopicId(item.getId(), areaCode);
            log.info("==========recommendTopic \u5e16\u5b50\u4fe1\u606f \uff0ctopicId : {},\u5e26\u56fe\u5217\u8868 list1 : {}", (Object)item.getId(), list1);
            item.setTopicForums(list1);
            return list1.size() >= this.newsProperties.getTopicForumLimit();
        }).collect(Collectors.toList());
        log.info("==========recommendTopic \u8fc7\u6ee4\u540e \uff1a {}", topicVoList);
        if (CollectionUtils.isEmpty(topicVoList)) {
            return param;
        }
        Integer order = (Integer)this.redisHashMapAdapter.get(RedisConfig.USER_READ_RECOMMEND_TOPIC.copy(), userId + "", Integer.class);
        if (null == order || (order = Integer.valueOf(order + 1)) >= topicVoList.size()) {
            order = 0;
        }
        log.info("==========recommendTopic \u987a\u5e8f order \uff1a {}", (Object)order);
        this.redisHashMapAdapter.put(RedisConfig.USER_READ_RECOMMEND_TOPIC.copy(), userId + "", (Object)order);
        TopicVo topic = (TopicVo)topicVoList.get(order);
        Date now = new Date();
        topic.setHasReward(Integer.valueOf(DateUtils.before((Date)now, (Date)topic.getRewardEndTime()) && DateUtils.after((Date)now, (Date)topic.getRewardStartTime()) ? 1 : 0));
        if (type == 1) {
            News4Client news4Client = new News4Client();
            news4Client.setRecommendTopicVo(topic);
            List news4Clients = (List)param;
            if (news4Clients.size() >= 5) {
                news4Clients.add(4, news4Client);
            }
            return news4Clients;
        }
        if (type == 2) {
            List postList = (List)param;
            ForumPostVo forumPostVo = new ForumPostVo();
            forumPostVo.setRecommendTopicVo(topic);
            if (postList.size() >= 3) {
                postList.add(2, forumPostVo);
            }
            return postList;
        }
        return param;
    }

    private KeyGenerator buildKey() {
        return RedisConfig.FORUM_LIMITNUM_TOPIC_NEW.copy();
    }

    public TopicForumServiceImpl(NewsProperties newsProperties, ForumPostMapper forumPostMapper, RedisHashMapAdapter redisHashMapAdapter, ForumTopicService forumTopicService) {
        this.newsProperties = newsProperties;
        this.forumPostMapper = forumPostMapper;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.forumTopicService = forumTopicService;
    }
}

