/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.statistics.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.integration.LocationIntegrationService;
import com.bxm.localnews.integration.MissionIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.news.config.ReplyConfigProperties;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.ForumPostLikeMapper;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.domain.ForumTopicMapper;
import com.bxm.localnews.news.domain.NewsReplyMapper;
import com.bxm.localnews.news.domain.UserReplyMapper;
import com.bxm.localnews.news.dto.CalculatePostDTO;
import com.bxm.localnews.news.model.vo.ForumPostStatistic;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.model.vo.NewsReply;
import com.bxm.localnews.news.model.vo.PostCount;
import com.bxm.localnews.news.model.vo.TopicVo;
import com.bxm.localnews.news.model.vo.UserReply;
import com.bxm.localnews.news.statistics.ForumPostStatisticService;
import com.bxm.localnews.vo.VirtualUserInfo;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.sync.core.CacheHolder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ForumPostStatisticServiceImpl
extends BaseService
implements ForumPostStatisticService {
    private static final Logger log = LogManager.getLogger(ForumPostStatisticServiceImpl.class);
    @Resource
    private ForumTopicMapper forumTopicMapper;
    @Resource
    private NewsReplyMapper newsReplyMapper;
    @Resource
    private UserReplyMapper userReplyMapper;
    @Resource
    private ForumPostLikeMapper forumPostLikeMapper;
    @Resource
    private ForumPostMapper forumPostMapper;
    @Resource
    private UserIntegrationService userIntegrationService;
    @Resource
    private LocationIntegrationService locationIntegrationService;
    @Resource
    private MissionIntegrationService missionIntegrationService;
    @Resource
    private ReplyConfigProperties replyConfigProperties;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;
    @Resource
    private CacheHolder cacheHolder;

    @Override
    public void doConsumeRecommendedCount(List<Long> ids, Long userId) {
        List forumPostStatisticList = ids.stream().map(id -> ForumPostStatistic.buildRecommend((Long)id, (Integer)1)).collect(Collectors.toList());
        MybatisBatchBuilder.create(ForumPostMapper.class, forumPostStatisticList).run(ForumPostMapper::updateStatisticByPrimaryKeySelective);
    }

    @Override
    public void doSyncPostStaticInfo() {
        List list = this.forumPostMapper.selectNotExitReplyAndLikeInfo();
        ArrayList paramList = Lists.newArrayList();
        list.forEach(postId -> {
            boolean flag;
            List forumPostLikes;
            ForumPostStatistic forumPostStatistic = new ForumPostStatistic();
            forumPostStatistic.setId(postId);
            List replyList = this.newsReplyMapper.selectPostReplyByNewsIdOrderByAddTime(postId);
            if (CollectionUtils.isNotEmpty((Collection)replyList)) {
                forumPostStatistic.setReplyInfo(JSON.toJSONString((Object)replyList));
            }
            if (CollectionUtils.isNotEmpty((Collection)(forumPostLikes = this.forumPostLikeMapper.selectByPostIdAndOrderByAddtime(postId)))) {
                forumPostStatistic.setLikeInfo(JSON.toJSONString((Object)forumPostLikes));
            }
            boolean bl = flag = !StringUtils.isBlank((String)forumPostStatistic.getLikeInfo()) || !StringUtils.isBlank((String)forumPostStatistic.getReplyInfo());
            if (flag) {
                paramList.add(forumPostStatistic);
            }
        });
        MybatisBatchBuilder.create(ForumPostMapper.class, (Collection)paramList).run(ForumPostMapper::updateStatisticByPrimaryKeySelective);
    }

    @Override
    public List<CalculatePostDTO> calculatePostCount() {
        ArrayList result = Lists.newArrayList();
        List newPostCount = this.forumPostMapper.selectNewPostCount();
        List unreviewedCounts = this.forumPostMapper.selectPendingReviewCount();
        newPostCount.forEach(e -> {
            CalculatePostDTO calculatePostDTO = new CalculatePostDTO();
            if (StringUtils.isNotBlank((String)e.getAreaCode())) {
                LocationDTO location = this.locationIntegrationService.getLocationByGeocode(e.getAreaCode());
                calculatePostDTO.setAreaName(location.getName());
                calculatePostDTO.setAreaCode(e.getAreaCode());
            } else {
                calculatePostDTO.setAreaName("\u5176\u4ed6\u5730\u533a");
                calculatePostDTO.setAreaCode("");
            }
            calculatePostDTO.setNewPostCount(e.getNum());
            Integer unReviewed = unreviewedCounts.stream().filter(k -> StringUtils.equalsIgnoreCase((String)e.getAreaCode(), (String)k.getAreaCode())).findFirst().map(PostCount::getNum).orElse(0);
            calculatePostDTO.setPendingReviewCount(unReviewed);
            int userCount = this.forumPostMapper.selectUserCount(e.getAreaCode());
            calculatePostDTO.setUserCount(Integer.valueOf(userCount));
            result.add(calculatePostDTO);
        });
        return result;
    }

    @Override
    public void calcParticipantsNum() {
        this.logger.info("calculate participants num start. ");
        this.calcAllParticipantsNum();
        this.calcAreaParticipantsNum();
        this.logger.info("calculate participants num end. ");
    }

    private void calcAllParticipantsNum() {
        List topicVoList = this.forumTopicMapper.getTopicList(null, null);
        if (CollectionUtils.isNotEmpty((Collection)topicVoList)) {
            for (TopicVo topicVo : topicVoList) {
                Integer participantsNum = this.getParticipantsNum(topicVo.getId(), null);
                this.forumTopicMapper.updateTopic(topicVo.getId(), participantsNum);
            }
        }
    }

    private void calcAreaParticipantsNum() {
        List areaRelationVoList = this.forumTopicMapper.getAreaRelationList();
        if (CollectionUtils.isNotEmpty((Collection)areaRelationVoList)) {
            areaRelationVoList.stream().filter(e -> null != e.getType() && null != e.getRelationId() && StringUtils.isNotBlank((String)e.getAreaCode())).forEach(e -> {
                if (2 == e.getType()) {
                    Integer participantsNum = this.getParticipantsNum(e.getRelationId(), e.getAreaCode());
                    this.forumTopicMapper.updateAreaParticipantsNum(e.getId(), participantsNum);
                }
            });
        }
    }

    private Integer getParticipantsNum(Long topicId, String areaCode) {
        List postIdList;
        Integer participantsNum = this.forumPostMapper.calcPostNum(null, topicId, areaCode);
        if (null == participantsNum) {
            participantsNum = 0;
        }
        if (CollectionUtils.isNotEmpty((Collection)(postIdList = this.forumPostMapper.getPostIdList(null, topicId, areaCode)))) {
            for (Long postId : postIdList) {
                Integer replyNum = this.newsReplyMapper.calcReplyNum(postId);
                if (replyNum == null) continue;
                participantsNum = participantsNum + replyNum;
            }
        }
        return participantsNum;
    }

    @Override
    @Async
    public void addPostReply(ForumPostVo forumPostVo) {
        try {
            List list = this.newsReplyMapper.selectRandomReplyLibrary(this.replyConfigProperties.getNewReportId(), 24);
            List userList = this.userIntegrationService.getVirtualUserListNew(Integer.valueOf(24), (List)Lists.newArrayList((Object[])new Integer[]{1, 2, 3}), forumPostVo.getAreaCode());
            int choiceNum = ThreadLocalRandom.current().nextInt(3, 6);
            this.addNewsReplyDo(forumPostVo, System.currentTimeMillis(), this.subList(list, 0, choiceNum), this.subList(userList, 0, choiceNum));
            choiceNum = ThreadLocalRandom.current().nextInt(3, 6);
            this.addNewsReplyDo(forumPostVo, System.currentTimeMillis() + 86400000L, this.subList(list, 5, choiceNum), this.subList(userList, 5, choiceNum));
            choiceNum = ThreadLocalRandom.current().nextInt(1, 2);
            this.addNewsReplyDo(forumPostVo, System.currentTimeMillis() + 172800000L, this.subList(list, 10, choiceNum), this.subList(userList, 10, choiceNum));
        }
        catch (Exception e) {
            log.error("\u589e\u52a0\u8bc4\u8bba\u5931\u8d25, forumPostVo: {}", (Object)JSON.toJSONString((Object)forumPostVo), (Object)e);
        }
    }

    private <T> List<T> subList(List<T> list, int start, int limit) {
        return list.stream().skip(start).limit(limit).collect(Collectors.toList());
    }

    private void addNewsReplyDo(ForumPostVo forumPostVo, long currentTime, List<String> list, List<VirtualUserInfo> userList) {
        if (CollectionUtils.isEmpty(list) || CollectionUtils.isEmpty(userList)) {
            return;
        }
        int i = 0;
        for (String replyContent : list) {
            int nextTime = ThreadLocalRandom.current().nextInt(120000);
            VirtualUserInfo virtualUser = userList.get(i);
            NewsReply newsReply = new NewsReply();
            newsReply.setAddTime(new Date(currentTime + (long)nextTime));
            newsReply.setDeleteFlag((byte)0);
            newsReply.setHeadImg(virtualUser.getHeadImg());
            newsReply.setId(this.nextSequence());
            newsReply.setLevel(Byte.valueOf((byte)0));
            newsReply.setLikeCount(Integer.valueOf(0));
            newsReply.setNewsId(forumPostVo.getId());
            newsReply.setReplyContent(replyContent);
            newsReply.setType(Byte.valueOf((byte)3));
            newsReply.setParentId(Long.valueOf(0L));
            newsReply.setStatus(Byte.valueOf((byte)0));
            newsReply.setUserId(virtualUser.getId());
            newsReply.setUserNickname(virtualUser.getNickname());
            newsReply.setInteractiveCount(Integer.valueOf(0));
            newsReply.setRootId(Long.valueOf(0L));
            newsReply.setReplyUserType(Integer.valueOf(1));
            this.newsReplyMapper.insertSelective(newsReply);
            UserReply userReply = new UserReply();
            BeanUtils.copyProperties((Object)newsReply, (Object)userReply);
            this.userReplyMapper.insertSelective(userReply);
            ++i;
        }
    }

    @Override
    public void addCrumbsTotal(Integer deliveryType, String areaCode, Byte postType) {
        if (deliveryType != null && deliveryType == 0) {
            KeyGenerator crumbsNationalTotal = this.getNationalAreaTotal();
            if (postType != null) {
                boolean exists = this.redisHashMapAdapter.exists(crumbsNationalTotal, postType.toString());
                if (exists) {
                    this.redisHashMapAdapter.increment(crumbsNationalTotal, postType.toString(), 1);
                } else {
                    boolean initNum = true;
                    this.redisHashMapAdapter.put(crumbsNationalTotal, postType.toString(), (Object)1);
                }
            }
        }
        if (deliveryType != null && deliveryType == 1 && postType != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)areaCode)) {
            String[] areaCodes = areaCode.split(",");
            this.logger.info("\u65b0\u589e\u533a\u57df\u5e16\u5b50\u6216\u5c0f\u7eb8\u6761\uff0cpostType:{},\u533a\u57df\u7f16\u7801\uff1a{}", (Object)postType, (Object)areaCode);
            for (String areaCodeItem : areaCodes) {
                KeyGenerator crumbsAreaTotal = this.getCrumbsAreaTotalKey(postType.byteValue());
                boolean exists = this.redisHashMapAdapter.exists(crumbsAreaTotal, areaCodeItem);
                if (exists) {
                    this.redisHashMapAdapter.increment(crumbsAreaTotal, areaCodeItem, 1);
                    continue;
                }
                boolean initNum = true;
                this.redisHashMapAdapter.put(crumbsAreaTotal, areaCodeItem, (Object)1);
            }
        }
    }

    private KeyGenerator getNationalAreaTotal() {
        return RedisConfig.NATIONAL_AREA_TOTAL.copy();
    }

    private KeyGenerator getCrumbsAreaTotalKey(int type) {
        return RedisConfig.CRUMBS_AREA_TOTAL.copy().appendKey((Object)type);
    }
}

