/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.task;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.news.model.vo.ForumPostClickCountVo;
import com.bxm.localnews.news.model.vo.PostClickCountVo;
import com.bxm.localnews.news.post.ForumPostFacadeService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.bxm.newidea.component.vo.PageParam;
import com.xxl.job.core.biz.model.ReturnT;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CalcPostClickCountNewTask
extends AbstractCronTask<String> {
    private static final Logger log = LoggerFactory.getLogger(CalcPostClickCountNewTask.class);
    private static final Integer BATCH_SIZE = 50;
    @Resource
    private ForumPostFacadeService forumPostFacadeService;

    protected ReturnT<String> service(String param) {
        List<PostClickCountVo> postClickCountVos;
        log.info(".....................................\u65b0\u7248\u672c\uff08\u5b50\u9675\u7248\uff09\u5e16\u5b50\u9605\u8bfb\u6570\u76f8\u5173\u8ba1\u7b97 begin...................................");
        PageParam page = new PageParam();
        int pager = 1;
        page.setPageSize(BATCH_SIZE);
        byte yes = 1;
        do {
            List<ForumPostClickCountVo> forumPostClickList;
            page.setPageNum(Integer.valueOf(pager++));
            postClickCountVos = this.forumPostFacadeService.getUnFullClickPosts(page);
            if (log.isDebugEnabled()) {
                log.debug("page: {} \u83b7\u53d6\u5230\u7684\u9700\u8981\u8ba1\u7b97\u5e16\u5b50\u7684\u5217\u8868: {}", (Object)(pager - 1), (Object)JSON.toJSONString(postClickCountVos));
            }
            if (!CollectionUtils.isNotEmpty(forumPostClickList = postClickCountVos.stream().map(p -> {
                long currentFinalClickCount;
                boolean isRecommend = Objects.equals(p.getIsRecommend(), yes);
                int clickCount = Objects.equals(p.getIsBroke(), yes) || Objects.equals(p.getIsBrilliant(), yes) || Objects.equals(p.getIsRed(), yes) || Objects.equals(p.getIsCash(), yes) ? RandomUtils.nextInt((int)500, (int)1001) : (isRecommend ? RandomUtils.nextInt((int)100, (int)500) : RandomUtils.nextInt((int)40, (int)60));
                long currentClickCount = Objects.isNull(p.getClickCount()) ? 0L : p.getClickCount();
                long l = currentFinalClickCount = Objects.isNull(p.getFinalClickCount()) ? 0L : p.getFinalClickCount();
                if ((long)clickCount + currentClickCount > currentFinalClickCount) {
                    clickCount = (int)(currentFinalClickCount - currentClickCount);
                }
                ForumPostClickCountVo forumPostClickCountVo = new ForumPostClickCountVo();
                forumPostClickCountVo.setId(p.getId());
                forumPostClickCountVo.setClickCount(Integer.valueOf(clickCount));
                return forumPostClickCountVo;
            }).collect(Collectors.toList()))) continue;
            this.forumPostFacadeService.batchAddClick(forumPostClickList);
        } while (!CollectionUtils.isEmpty(postClickCountVos));
        log.info(".....................................\u65b0\u7248\u672c\uff08\u5b50\u9675\u7248\uff09\u5e16\u5b50\u9605\u8bfb\u6570\u76f8\u5173\u8ba1\u7b97 end...................................");
        return ReturnT.SUCCESS;
    }

    public String taskName() {
        return "calcPostClickCountNewTask";
    }

    public String cron() {
        return "30 1/1 * * * ? ";
    }

    public String description() {
        return "\u65b0\u7248\u672c\uff08\u5b50\u9675\u7248\uff09\u5b9a\u65f6\u589e\u52a0\u5e16\u5b50\u9605\u8bfb\u6570\u4efb\u52a1";
    }
}

