/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.task;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.integration.MessageService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.model.vo.NoteExtraVo;
import com.bxm.localnews.news.model.vo.NoteVo;
import com.bxm.localnews.vo.UserFuns;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.bxm.newidea.component.tools.DateUtils;
import com.google.common.collect.Lists;
import com.xxl.job.core.biz.model.ReturnT;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class NoteLeadTask
extends AbstractCronTask<String> {
    private static final Logger log = LoggerFactory.getLogger(NoteLeadTask.class);
    @Resource
    private ForumPostMapper forumPostMapper;
    @Resource
    private RedisSetAdapter redisSetAdapter;
    @Resource
    private UserIntegrationService userIntegrationService;
    @Resource
    private MessageService messageService;

    protected ReturnT<String> service(String param) {
        Map<Long, List<NoteExtraVo>> userNoteMap;
        List userFunsList;
        log.info(".....................................\u5c0f\u7eb8\u6761\u5f15\u5bfc\u4efb\u52a1 begin...................................");
        Date endTime = new Date();
        Integer hour = DateUtils.getField((Date)endTime, (int)11);
        Date startTime = 10 == hour ? DateUtils.addField((Date)endTime, (int)11, (int)-16) : DateUtils.addField((Date)endTime, (int)11, (int)-8);
        List noteList = this.forumPostMapper.getNoteListByTime(startTime, endTime);
        if (!CollectionUtils.isEmpty((Collection)noteList) && !CollectionUtils.isEmpty((Collection)(userFunsList = this.userIntegrationService.getUserFuns((List)Lists.newArrayList((userNoteMap = noteList.stream().collect(Collectors.groupingBy(NoteVo::getUserId))).keySet()))))) {
            HashMap<Long, NoteExtraVo> sendUserNoteMap = new HashMap<Long, NoteExtraVo>();
            for (UserFuns userFuns : userFunsList) {
                Set chatNoteIdSet = this.redisSetAdapter.getAllMembers(this.getUserReadNoteKey(userFuns.getFunsUserId(), userFuns.getUserId()), Long.class);
                log.debug("\u7528\u6237\u5173\u6ce8\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)userFuns) + "\uff0c\u804a\u8fc7\u7684\u5c0f\u7eb8\u6761\uff1a" + JSON.toJSONString((Object)chatNoteIdSet));
                List<NoteExtraVo> userNoteList = userNoteMap.get(userFuns.getUserId());
                if (CollectionUtils.isEmpty(userNoteList)) continue;
                for (NoteExtraVo note : userNoteList) {
                    NoteExtraVo sendNote;
                    if (StringUtils.isNotBlank((String)note.getAreaCode()) && !note.getAreaCode().contains(userFuns.getFunsAreaCode()) || !CollectionUtils.isEmpty((Collection)chatNoteIdSet) && chatNoteIdSet.contains(note.getId()) || (sendNote = (NoteExtraVo)sendUserNoteMap.get(userFuns.getFunsUserId())) != null && (sendNote.getClickCount() > note.getClickCount() || sendNote.getClickCount().equals(note.getClickCount()) && sendNote.getDisplayTime().after(note.getDisplayTime()))) continue;
                    sendUserNoteMap.put(userFuns.getFunsUserId(), note);
                }
            }
            if (!CollectionUtils.isEmpty(sendUserNoteMap)) {
                sendUserNoteMap.forEach((userId, noteExtraVo) -> this.messageService.pushLeadNote(userId, noteExtraVo));
            }
        }
        log.info(".....................................\u5c0f\u7eb8\u6761\u5f15\u5bfc\u4efb\u52a1 end.....................................");
        return ReturnT.SUCCESS;
    }

    public String taskName() {
        return "noteLeadTask";
    }

    public String cron() {
        return "0 0 10,18 * * ? *";
    }

    public String description() {
        return "\u5c0f\u7eb8\u6761\u5f15\u5bfc\u4efb\u52a1";
    }

    private KeyGenerator getUserReadNoteKey(Long userId, Long targetUserId) {
        return RedisConfig.USER_READ_NOTE.copy().appendKey((Object)(userId + "_" + targetUserId));
    }
}

