/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.task;

import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.recommend.TopicForumService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RecommendTopicForForumInfoTask
extends AbstractCronTask<String> {
    private static final Logger log = LoggerFactory.getLogger(RecommendTopicForForumInfoTask.class);
    @Resource
    private TopicForumService topicForumService;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;

    protected ReturnT<String> service(String s) {
        Set topicIdStr = this.redisHashMapAdapter.keys(this.buildKey());
        topicIdStr.forEach(idStr -> {
            String[] idStrInfos = idStr.split("#");
            if (idStrInfos.length >= 2) {
                this.topicForumService.loadForumInfosByTopicId(Long.parseLong(idStrInfos[0]), idStrInfos[1]);
            } else {
                log.error("\u5e16\u5b50\u4fe1\u606f\u6d41\u4e2d\u63d2\u5165\u8bdd\u9898\u65f6\u7684\u5e16\u5b50\u56fe\u7247\u4fe1\u606f, \u7f13\u5b58\u5e16\u5b50\u4fe1\u606f\u4e0d\u5408\u6cd5\uff1a{}", idStr);
            }
        });
        return ReturnT.SUCCESS;
    }

    public String taskName() {
        return "syncRecommendTopicForumTask";
    }

    public String cron() {
        return "0 /20 * * * ? ";
    }

    public String description() {
        return "\u540c\u6b65\u63d2\u5165\u63a8\u8350\u8bdd\u9898\u5e16\u5b50\u56fe\u7247\u5185\u5bb9";
    }

    private KeyGenerator buildKey() {
        return RedisConfig.FORUM_LIMITNUM_TOPIC_NEW.copy();
    }
}

