/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.topic.filter;

import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.domain.ForumTopicMapper;
import com.bxm.localnews.news.domain.NewsReplyMapper;
import com.bxm.localnews.news.model.vo.TopicVo;
import com.bxm.localnews.news.topic.context.TopicContext;
import com.bxm.newidea.component.annotations.FilterBean;
import com.bxm.newidea.component.filter.IFilter;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

@FilterBean(group="TOPIC_FILL_FILTER")
public class TopicJoinerFilter
implements IFilter<TopicContext> {
    private ForumTopicMapper forumTopicMapper;
    private NewsReplyMapper newsReplyMapper;
    private static final int JOIN_USER_NUM = 5;

    public void doFilter(TopicContext context) {
        TopicVo topicVo = context.getTopic();
        List postHeadImgList = this.forumTopicMapper.getPostHeadImgList(topicVo.getId());
        if (CollectionUtils.isEmpty((Collection)postHeadImgList)) {
            return;
        }
        HashSet joinHeadImgSet = new HashSet(postHeadImgList);
        if (joinHeadImgSet.size() < 5) {
            List likeHeadImgList;
            List postIdList = this.forumTopicMapper.getPostIdListByTopicId(topicVo.getId());
            boolean isNotEnough = false;
            if (CollectionUtils.isNotEmpty((Collection)postIdList)) {
                for (Long postId : postIdList) {
                    List replyHeadImgList = this.newsReplyMapper.getReplyHeadImgList(postId);
                    if (!CollectionUtils.isNotEmpty((Collection)replyHeadImgList)) continue;
                    joinHeadImgSet.addAll(replyHeadImgList);
                    if (joinHeadImgSet.size() < 5) continue;
                    break;
                }
                if (joinHeadImgSet.size() < 5) {
                    isNotEnough = true;
                }
            }
            if (isNotEnough && CollectionUtils.isNotEmpty((Collection)(likeHeadImgList = this.forumTopicMapper.getLikeHeadImgList(topicVo.getId())))) {
                joinHeadImgSet.addAll(likeHeadImgList);
            }
        }
        topicVo.setJoinHeadImgList(joinHeadImgSet.stream().limit(5L).collect(Collectors.toList()));
    }

    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }

    public TopicJoinerFilter(ForumTopicMapper forumTopicMapper, NewsReplyMapper newsReplyMapper) {
        this.forumTopicMapper = forumTopicMapper;
        this.newsReplyMapper = newsReplyMapper;
    }
}

