/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.topic.filter;

import com.bxm.localnews.news.constant.MemoryCacheKey;
import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.domain.ForumTopicMapper;
import com.bxm.localnews.news.model.vo.TopicVo;
import com.bxm.localnews.news.topic.context.TopicContext;
import com.bxm.newidea.component.annotations.FilterBean;
import com.bxm.newidea.component.filter.IFilter;
import com.bxm.newidea.component.sync.core.CacheHolder;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FilterBean(group="TOPIC_FILL_FILTER")
public class TopicParticipantNumFilter
implements IFilter<TopicContext> {
    private static final Logger log = LoggerFactory.getLogger(TopicParticipantNumFilter.class);
    private CacheHolder cacheHolder;
    private ForumTopicMapper forumTopicMapper;

    public void doFilter(TopicContext context) {
        TopicVo topicVo = context.getTopic();
        if (null != context.getLocation() && StringUtils.isNotBlank((CharSequence)context.getLocation().getCode())) {
            topicVo.setParticipantsNum(this.loadParticipantNum(topicVo.getId(), context.getLocation().getCode(), topicVo.getParticipantsNum()));
        }
    }

    private Long loadParticipantNum(Long topicId, String areaCode, Long defaultNum) {
        String subKey = topicId + areaCode;
        Long num = (Long)this.cacheHolder.get(MemoryCacheKey.TOPIC_PARTICIPANT_NUM, subKey);
        if (null == num) {
            num = this.forumTopicMapper.getParticipantsNum(topicId, areaCode);
            if (num == null || num <= 0L) {
                num = defaultNum;
            }
            Long finalNum = num;
            this.cacheHolder.set(MemoryCacheKey.TOPIC_PARTICIPANT_NUM, key -> finalNum, 1000L, TimeUnit.MINUTES, 1L);
        }
        return num;
    }

    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }

    public TopicParticipantNumFilter(CacheHolder cacheHolder, ForumTopicMapper forumTopicMapper) {
        this.cacheHolder = cacheHolder;
        this.forumTopicMapper = forumTopicMapper;
    }
}

