/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.topic.filter;

import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.news.config.ForumProperties;
import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.model.vo.TopicVo;
import com.bxm.localnews.news.topic.context.TopicContext;
import com.bxm.localnews.news.util.PlaceHolderUtil;
import com.bxm.newidea.component.annotations.FilterBean;
import com.bxm.newidea.component.filter.IFilter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FilterBean(group="TOPIC_FILL_FILTER")
public class TopicPlaceHolderFilter
implements IFilter<TopicContext> {
    private static final Logger log = LoggerFactory.getLogger(TopicPlaceHolderFilter.class);
    private ForumProperties forumProperties;

    public void doFilter(TopicContext context) {
        String recommendContent;
        TopicVo topicVo = context.getTopic();
        LocationDTO location = context.getLocation();
        if (location == null) {
            location = new LocationDTO();
        }
        if (StringUtils.isBlank((CharSequence)(recommendContent = topicVo.getRecommendContent()))) {
            recommendContent = this.forumProperties.getDefaultRecommendContent();
        }
        topicVo.setRecommendContent(this.replaceVariable(recommendContent, topicVo, location));
        topicVo.setGuidePopText(this.replaceVariable(topicVo.getGuidePopText(), topicVo, location));
    }

    private String replaceVariable(String content, TopicVo topicVo, LocationDTO location) {
        content = PlaceHolderUtil.replace((String)content, (String)"areaname", (String)location.getName(), (String)"\u5168\u56fd");
        content = PlaceHolderUtil.replace((String)content, (String)"areaName", (String)location.getName(), (String)"\u5168\u56fd");
        return PlaceHolderUtil.replace((String)content, (String)"topicname", (String)topicVo.getTitle(), (String)"\u8bdd\u9898");
    }

    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }

    public TopicPlaceHolderFilter(ForumProperties forumProperties) {
        this.forumProperties = forumProperties;
    }
}

