/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.topic.filter;

import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.enums.UrlCategoryEnum;
import com.bxm.localnews.news.enums.UrlPositionEnum;
import com.bxm.localnews.news.enums.UrlTypeEnum;
import com.bxm.localnews.news.factory.IUrlFactory;
import com.bxm.localnews.news.model.vo.TopicVo;
import com.bxm.localnews.news.topic.context.TopicContext;
import com.bxm.newidea.component.annotations.FilterBean;
import com.bxm.newidea.component.filter.IFilter;
import com.bxm.newidea.component.tools.DateUtils;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FilterBean(group="TOPIC_FILL_FILTER")
public class TopicRuntimeFilter
implements IFilter<TopicContext> {
    private static final Logger log = LoggerFactory.getLogger(TopicRuntimeFilter.class);
    private IUrlFactory iUrlFactory;

    public void doFilter(TopicContext context) {
        TopicVo topicVo = context.getTopic();
        if (Objects.nonNull(topicVo.getHasReward()) && topicVo.getHasReward() == 1) {
            Date now = new Date();
            if (Objects.nonNull(topicVo.getRewardEndTime()) && Objects.nonNull(topicVo.getRewardStartTime())) {
                topicVo.setHasReward(Integer.valueOf(DateUtils.before((Date)now, (Date)topicVo.getRewardEndTime()) && DateUtils.after((Date)now, (Date)topicVo.getRewardStartTime()) ? 1 : 0));
            }
        }
        topicVo.setAppletShareUrl(this.iUrlFactory.getAppletUrl(UrlPositionEnum.TOPIC, topicVo.getId(), context.getUserId()));
        topicVo.setShareUrl(this.iUrlFactory.getAppUrl(UrlCategoryEnum.FORUM, UrlTypeEnum.TOPIC, topicVo.getId(), context.getUserId()));
    }

    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }

    public TopicRuntimeFilter(IUrlFactory iUrlFactory) {
        this.iUrlFactory = iUrlFactory;
    }
}

