/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.topic.impl;

import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.integration.LocationIntegrationService;
import com.bxm.localnews.news.config.ForumProperties;
import com.bxm.localnews.news.constant.MemoryCacheKey;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.ForumTopicMapper;
import com.bxm.localnews.news.model.vo.TopicVo;
import com.bxm.localnews.news.topic.ForumTopicService;
import com.bxm.localnews.news.topic.context.TopicContext;
import com.bxm.localnews.news.topic.filter.TopicGuidePopFilter;
import com.bxm.localnews.news.topic.filter.TopicJoinerFilter;
import com.bxm.localnews.news.topic.filter.TopicParticipantNumFilter;
import com.bxm.localnews.news.topic.filter.TopicPlaceHolderFilter;
import com.bxm.localnews.news.topic.filter.TopicRuntimeFilter;
import com.bxm.localnews.news.topic.filter.TopicSecondInfoFilter;
import com.bxm.newidea.component.filter.FilterChainExecutor;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.sync.core.CacheHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ForumTopicServiceImpl
extends BaseService
implements ForumTopicService {
    private ForumTopicMapper forumTopicMapper;
    private ForumProperties forumProperties;
    private RedisHashMapAdapter redisHashMapAdapter;
    private LocationIntegrationService locationIntegrationService;
    private FilterChainExecutor filterChainExecutor;
    private CacheHolder cacheHolder;
    public static final String DEFAULT_INVALID_TOPIC_ID = "0";

    @Override
    public List<TopicVo> loadTopicByIds(String topicIds, LocationDTO location, Long userId) {
        ArrayList<TopicVo> topicVoList = new ArrayList<TopicVo>();
        if (StringUtils.isNotBlank((CharSequence)topicIds)) {
            String[] topicIdArr = topicIds.split(",");
            if (topicIdArr.length == 1 && Objects.equals(topicIdArr[0], DEFAULT_INVALID_TOPIC_ID)) {
                return Collections.emptyList();
            }
            for (String topicId : topicIdArr) {
                TopicVo cacheTopic = this.getCacheTopic(Long.valueOf(topicId));
                TopicContext context = TopicContext.builder().topic(cacheTopic).location(location).userId(userId).build();
                this.filterChainExecutor.choice(TopicRuntimeFilter.class).choice(TopicPlaceHolderFilter.class).doFilter("TOPIC_FILL_FILTER", (Object)context);
                topicVoList.add(cacheTopic);
            }
        }
        return topicVoList;
    }

    @Override
    public List<TopicVo> listTopic(String areaCode, Integer size, Long userId, Integer postPage) {
        if (StringUtils.isBlank((CharSequence)areaCode)) {
            this.logger.warn("\u6839\u636e\u5730\u533a\u83b7\u53d6\u8bdd\u9898\u5217\u8868 \u533a\u57df\u7f16\u7801\u4e3a\u7a7a");
            return Collections.emptyList();
        }
        if (Objects.isNull(userId)) {
            this.logger.warn("\u6839\u636e\u5730\u533a\u83b7\u53d6\u8bdd\u9898\u5217\u8868 \u7528\u6237id\u4e3a\u7a7a");
            return Collections.emptyList();
        }
        List<TopicVo> topicVoList = this.getTopicList(areaCode);
        if (Objects.equals(postPage, 1)) {
            Long noteTopicId = this.forumProperties.getNoteTopicId();
            for (TopicVo topicVo : topicVoList) {
                if (!Objects.equals(topicVo.getId(), noteTopicId)) continue;
                topicVoList.remove(topicVo);
                break;
            }
        }
        if (size != null && size == 2) {
            Collections.shuffle(topicVoList);
            return topicVoList.stream().limit(size.intValue()).collect(Collectors.toList());
        }
        return topicVoList;
    }

    @Override
    public List<TopicVo> getTopicList(String areaCode) {
        if (StringUtils.isBlank((CharSequence)areaCode)) {
            areaCode = DEFAULT_INVALID_TOPIC_ID;
        }
        LocationDTO location = this.locationIntegrationService.getLocationByGeocode(areaCode);
        List topicIdList = (List)this.cacheHolder.get(MemoryCacheKey.TOPIC_AREA_CACHE, areaCode);
        ArrayList result = Lists.newArrayList();
        for (Long topicId : topicIdList) {
            TopicVo cacheTopic = this.getCacheTopic(topicId);
            TopicContext context = TopicContext.builder().topic(cacheTopic).location(location).build();
            this.filterChainExecutor.choice(TopicRuntimeFilter.class).choice(TopicPlaceHolderFilter.class).choice(TopicParticipantNumFilter.class).doFilter("TOPIC_FILL_FILTER", (Object)context);
            result.add(cacheTopic);
        }
        return result;
    }

    @Override
    public List<TopicVo> getHotTopicList(String areaCode) {
        return this.getTopicList(areaCode).stream().filter(topicVo -> topicVo.getHot() == 1).collect(Collectors.toList());
    }

    @Override
    public TopicVo getTopicDetail(Long id, Long userId, String areaCode) {
        TopicVo topicVo = this.getCacheTopic(id);
        TopicContext context = TopicContext.builder().topic(topicVo).location(this.locationIntegrationService.getLocationByGeocode(areaCode)).userId(userId).build();
        this.filterChainExecutor.choice(TopicRuntimeFilter.class).choice(TopicPlaceHolderFilter.class).choice(TopicParticipantNumFilter.class).doFilter("TOPIC_FILL_FILTER", (Object)context);
        return topicVo;
    }

    @Override
    public TopicVo getTopicDetailNew(Long id, Long userId, String areaCode, Integer type) {
        TopicContext context = TopicContext.builder().topic(this.getCacheTopic(id)).location(this.locationIntegrationService.getLocationByGeocode(areaCode)).userId(userId).popType(type).build();
        this.filterChainExecutor.choice(TopicRuntimeFilter.class).choice(TopicPlaceHolderFilter.class).choice(TopicGuidePopFilter.class).doFilter("TOPIC_FILL_FILTER", (Object)context);
        return context.getTopic();
    }

    @Override
    public void removeCache(Long topicId) {
        this.loadTopicToRedis(topicId);
        this.cacheHolder.sendClearCmd(MemoryCacheKey.TOPIC_AREA_CACHE);
        this.cacheHolder.sendEvictCmd(MemoryCacheKey.TOPIC_CACHE, new String[]{topicId.toString()});
    }

    @Override
    public void reloadCache() {
        Set keys = this.redisHashMapAdapter.keys(RedisConfig.TOPIC_DETAIL);
        for (String key : keys) {
            this.loadTopicToRedis(Long.valueOf(key));
        }
    }

    private TopicVo getCacheTopic(Long topicId) {
        return (TopicVo)this.cacheHolder.get(MemoryCacheKey.TOPIC_CACHE, topicId.toString());
    }

    @PostConstruct
    public void init() {
        this.cacheHolder.set(MemoryCacheKey.TOPIC_CACHE, id -> {
            TopicVo topic = (TopicVo)this.redisHashMapAdapter.get(RedisConfig.TOPIC_DETAIL, id, TopicVo.class);
            if (topic == null) {
                topic = this.loadTopicToRedis(Long.valueOf(id));
            }
            return topic;
        }, 1000L, TimeUnit.MINUTES, 5L);
        this.cacheHolder.set(MemoryCacheKey.TOPIC_AREA_CACHE, this::getAreaTopicList, 500L, TimeUnit.MINUTES, 2L);
    }

    private List<Long> getAreaTopicList(String areaCode) {
        if (StringUtils.isBlank((CharSequence)areaCode) || DEFAULT_INVALID_TOPIC_ID.equals(areaCode)) {
            areaCode = null;
        }
        List topicList = this.forumTopicMapper.getTopicList(areaCode, Integer.valueOf(1));
        return topicList.stream().map(TopicVo::getId).collect(Collectors.toList());
    }

    private TopicVo loadTopicToRedis(Long topicId) {
        TopicVo topic = this.forumTopicMapper.selectTopicDetail(topicId);
        if (null == topic) {
            topic = new TopicVo();
            topic.setId(topicId);
            return topic;
        }
        TopicContext context = new TopicContext();
        context.setTopic(topic);
        this.filterChainExecutor.choice(TopicJoinerFilter.class).choice(TopicSecondInfoFilter.class).doFilter("TOPIC_FILL_FILTER", (Object)context);
        this.redisHashMapAdapter.put(RedisConfig.TOPIC_DETAIL, topicId.toString(), (Object)topic);
        return topic;
    }

    public ForumTopicServiceImpl(ForumTopicMapper forumTopicMapper, ForumProperties forumProperties, RedisHashMapAdapter redisHashMapAdapter, LocationIntegrationService locationIntegrationService, FilterChainExecutor filterChainExecutor, CacheHolder cacheHolder) {
        this.forumTopicMapper = forumTopicMapper;
        this.forumProperties = forumProperties;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.locationIntegrationService = locationIntegrationService;
        this.filterChainExecutor = filterChainExecutor;
        this.cacheHolder = cacheHolder;
    }
}

