/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.topic.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.integration.LocationIntegrationService;
import com.bxm.localnews.news.config.NewsProperties;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.model.vo.TopicVo;
import com.bxm.localnews.news.post.ForumPostFacadeService;
import com.bxm.localnews.news.topic.TopicPopService;
import com.bxm.localnews.news.vo.TopicPopInfoBean;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class TopicPopServiceImpl
implements TopicPopService {
    private RedisSetAdapter redisSetAdapter;
    private NewsProperties newsProperties;
    private ForumPostFacadeService forumPostFacadeService;
    private LocationIntegrationService locationIntegrationService;

    @Override
    public void loadTopicPop(TopicVo topicInfo, Integer type, Long userId, LocationDTO location) {
        List popInfo = JSONObject.parseArray((String)this.newsProperties.getTopicPopInfo(), TopicPopInfoBean.class);
        if (Objects.isNull(popInfo)) {
            return;
        }
        Long topicId = topicInfo.getId();
        for (TopicPopInfoBean topicPopInfoBean : popInfo) {
            if (!Objects.equals(type, topicPopInfoBean.getPopType()) && !Objects.equals(topicPopInfoBean.getTopicId(), topicInfo.getId())) continue;
            boolean hasPopRecord = this.redisSetAdapter.exists(this.buildKeyForPop(topicId, topicPopInfoBean.getPopType()), (Object)userId);
            if (hasPopRecord) {
                topicInfo.setGuidePopFlag(Integer.valueOf(0));
            } else {
                boolean hasPostRecord = this.forumPostFacadeService.getPublishPostNum(userId) > 0;
                topicInfo.setGuidePopFlag(Integer.valueOf(hasPostRecord ? 1 : 0));
            }
            if (topicInfo.getGuidePopFlag() != 1) break;
            topicInfo.setType(topicPopInfoBean.getPopType());
            topicInfo.setGuidePopText(this.replace(topicPopInfoBean.getPopText(), location.getCode()));
            this.guidePopSaveToRedis(userId, topicId, topicPopInfoBean.getPopType());
            break;
        }
    }

    private String replace(String popText, String areaCode) {
        LocationDTO locationDTO;
        String areaName = "\u5168\u56fd";
        if (StringUtils.isNotBlank((CharSequence)areaCode) && (locationDTO = this.locationIntegrationService.getLocationByGeocode(areaCode)) != null && StringUtils.isNotBlank((CharSequence)locationDTO.getName())) {
            areaName = locationDTO.getName();
        }
        return popText.replace("{areaname}", areaName);
    }

    private void guidePopSaveToRedis(Long userId, Long topicId, Integer type) {
        this.redisSetAdapter.add(this.buildKeyForPop(topicId, type), new Object[]{userId});
        this.redisSetAdapter.expire(this.buildKeyForPop(topicId, type), 31104000L);
    }

    private KeyGenerator buildKeyForPop(Long topicId, Integer type) {
        if (Objects.nonNull(type)) {
            return RedisConfig.TOPIC_DETAIL_GUIDE_HAS_POP_LIST.copy().appendKey((Object)(topicId.toString() + "#" + type.toString()));
        }
        return RedisConfig.TOPIC_DETAIL_GUIDE_HAS_POP_LIST.copy().appendKey((Object)(topicId.toString() + "#0"));
    }

    public TopicPopServiceImpl(RedisSetAdapter redisSetAdapter, NewsProperties newsProperties, ForumPostFacadeService forumPostFacadeService, LocationIntegrationService locationIntegrationService) {
        this.redisSetAdapter = redisSetAdapter;
        this.newsProperties = newsProperties;
        this.forumPostFacadeService = forumPostFacadeService;
        this.locationIntegrationService = locationIntegrationService;
    }
}

