/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.util;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.news.model.vo.AdminForumPost;
import com.bxm.localnews.news.model.vo.PostImg;
import com.bxm.newidea.component.enums.FileTypeEnum;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;
import com.bxm.newidea.component.tools.HtmlContentUtils;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class DealContentUtil {
    private static final Logger log = LoggerFactory.getLogger(DealContentUtil.class);
    @Resource
    private AliyunOSSService aliyunOSSService;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;

    public void analyzeContent(AdminForumPost adminForumPost) {
        if (StringUtils.isNotBlank((CharSequence)adminForumPost.getContent())) {
            ArrayList<PostImg> postImgList = new ArrayList<PostImg>();
            ArrayList<String> imgList = new ArrayList<String>();
            String content = this.extractVideoAndImg(adminForumPost.getContent(), postImgList, imgList);
            adminForumPost.setContent(content);
            List postImgTempList = imgList.stream().map(PostImg::buildImg).collect(Collectors.toList());
            postImgList.addAll(postImgTempList);
            adminForumPost.setImgList(JSONObject.toJSONString(postImgList));
            adminForumPost.setTextField(this.getForumPostTextFiled(content));
        }
    }

    private String getForumPostTextFiled(String content) {
        Document document = Jsoup.parse((String)content);
        Elements elements = document.select("p");
        StringBuilder sb = new StringBuilder();
        for (Element element : elements) {
            String text = element.text();
            String result = HtmlContentUtils.delHtmlTags((String)text);
            if (!StringUtils.isNotBlank((CharSequence)result)) continue;
            if (sb.length() == 0) {
                sb.append(result);
                continue;
            }
            sb.append("\n").append(result);
        }
        return sb.toString();
    }

    public String extractVideoAndImg(String content, List<PostImg> postImgList, List<String> imgList) {
        Document document = Jsoup.parse((String)content);
        document.outputSettings().prettyPrint(true).indentAmount(1);
        this.dealWithVideo(document, postImgList);
        this.dealWithImg(document, imgList);
        return document.body().html().replace("\n", "");
    }

    private void dealWithVideo(Document document, List<PostImg> postImgList) {
        Elements elements = document.select("video");
        if (null != elements) {
            for (Element element : elements) {
                String src = element.attr("src");
                if (StringUtils.isBlank((CharSequence)src)) continue;
                String poster = element.attr("poster");
                if (StringUtils.isEmpty((CharSequence)poster)) {
                    String url = src;
                    int lastIndex = src.lastIndexOf("?");
                    if (-1 != lastIndex) {
                        url = src.substring(0, lastIndex);
                    }
                    String baseName = FilenameUtils.getBaseName((String)url);
                    DefaultKeyGenerator videoCacheKey = DefaultKeyGenerator.build((String)"cache", (String)"static", (String)"videoinfo");
                    Map videoCacheInfo = (Map)this.redisHashMapAdapter.get((KeyGenerator)videoCacheKey, baseName, Map.class);
                    if (videoCacheInfo != null && !videoCacheInfo.isEmpty()) {
                        String size = videoCacheInfo.get("size") == null ? "0" : videoCacheInfo.get("size").toString();
                        String duration = videoCacheInfo.get("duration") == null ? "0" : videoCacheInfo.get("duration").toString();
                        String imgUrl = videoCacheInfo.get("imgUrl") == null ? "" : videoCacheInfo.get("imgUrl").toString();
                        element.attr("poster", imgUrl);
                        element.attr("size", size);
                        element.attr("duration", duration);
                        log.debug("video\u6807\u7b7e\u7ecf\u5904\u7406\u540e:{}", (Object)element.html());
                    }
                }
                PostImg img = new PostImg();
                img.setType("VIDEO");
                img.setImgUrl(element.attr("poster"));
                img.setVideoUrl(element.attr("src"));
                img.setSize(element.attr("size") == null ? "0" : element.attr("size"));
                img.setDuration(Long.valueOf(element.attr("duration") == null ? 0L : NumberUtils.toLong((String)element.attr("duration"), (long)0L)));
                postImgList.add(img);
            }
        }
    }

    public void dealWithImg(Document document, List<String> imgList) {
        Elements imgElements = document.select("img");
        if (null != imgElements) {
            for (Element element : imgElements) {
                boolean isExist = true;
                String src = element.attr("src");
                if (StringUtils.isBlank((CharSequence)src)) {
                    isExist = false;
                    src = element.attr("data-src");
                    if (StringUtils.isNotBlank((CharSequence)src)) {
                        isExist = true;
                    }
                }
                if (isExist) {
                    int lastIndex;
                    if (!src.contains("wstong.com")) {
                        if (StringUtils.isBlank((CharSequence)(src = this.uploadImgToOssBySrc(src)))) {
                            element.remove();
                            continue;
                        }
                        element.attr("src", src);
                    }
                    if (-1 != (lastIndex = src.lastIndexOf("?"))) {
                        src = src.substring(0, lastIndex);
                        element.attr("src", src);
                    }
                    imgList.add(src);
                    continue;
                }
                element.remove();
            }
        }
    }

    public String fixContent(String content) {
        Document document = Jsoup.parse((String)content);
        document.outputSettings().prettyPrint(true).indentAmount(1);
        Elements elements = document.select("img");
        if (null != elements) {
            for (Element element : elements) {
                String src = element.attr("src");
                if (StringUtils.isBlank((CharSequence)src) && StringUtils.isBlank((CharSequence)(src = element.attr("data-src")))) continue;
                String url = src;
                int lastIndex = src.lastIndexOf("?");
                if (-1 != lastIndex) {
                    url = src.substring(0, lastIndex);
                }
                url = url + "?x-oss-process=style/mcompress";
                element.attr("src", url);
            }
        }
        return document.body().html().replace("\n", "");
    }

    public String uploadImgToOssBySrc(String src) {
        RestTemplate template = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        try {
            String fileType;
            src = URLDecoder.decode(src, "UTF-8");
            log.debug("src:[{}]", (Object)src);
            ResponseEntity response = template.exchange(src, HttpMethod.GET, httpEntity, byte[].class, new Object[0]);
            HttpHeaders responseHeaders = response.getHeaders();
            List fileTypes = responseHeaders.get((Object)"content-type");
            if (!CollectionUtils.isEmpty((Collection)fileTypes)) {
                fileType = (String)fileTypes.get(0);
                if (StringUtils.isBlank((CharSequence)(fileType = this.getExtNameByContentType(fileType)))) {
                    fileType = "jpg";
                }
            } else {
                fileType = "jpg";
            }
            String fileName = RandomStringUtils.random((int)8, (boolean)true, (boolean)false) + "." + fileType;
            return this.aliyunOSSService.upload((byte[])response.getBody(), fileName);
        }
        catch (Exception e) {
            log.error("\u7b2c\u4e09\u65b9\u56fe\u7247\u4e0a\u4f20\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    private String getExtNameByContentType(String contentType) {
        FileTypeEnum[] values;
        for (FileTypeEnum fileType : values = FileTypeEnum.values()) {
            if (!fileType.getContentType().equals(contentType)) continue;
            return fileType.getExtName();
        }
        return null;
    }
}

