/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.util;

import com.bxm.localnews.common.vo.IP;
import com.bxm.newidea.component.tools.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriUtils;

public class IPConvertUtil {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final int DEFAULT_TIME_OUT = 20000;
    private static final Logger logger = LoggerFactory.getLogger(IPConvertUtil.class);
    private static int offset;
    private static int[] index;
    private static boolean initd;
    private static ByteBuffer dataBuffer;
    private static ByteBuffer indexBuffer;
    private static ReentrantLock lock;

    private static void init() {
        if (!initd) {
            return;
        }
        if (dataBuffer == null) {
            logger.debug("init load ip file");
            try {
                IPConvertUtil.load();
            }
            catch (Exception e) {
                logger.error("IP\u5de5\u5177\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
            }
            logger.debug("load success ip file");
        }
        initd = false;
    }

    public static IP find(String ip) {
        IPConvertUtil.init();
        try {
            Object[] array = IPConvertUtil.findIp(ip);
            if (ArrayUtils.isEmpty((Object[])array)) {
                return null;
            }
            if (array.length > 11) {
                return new IP((String)array[0], (String)array[1], (String)array[2], (String)array[3], (String)array[4], (String)array[5], (String)array[6], (String)array[7], (String)array[8], (String)array[9], NumberUtils.toInt((String)array[10], (int)-1), (String)array[11]);
            }
            if (array.length > 2) {
                return new IP((String)array[0], (String)array[1], (String)array[2]);
            }
        }
        catch (Exception e) {
            logger.error("ip\u5de5\u5177\u8c03\u7528\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u521d\u59cb\u5316");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] findIp(String ip) {
        byte[] areaBytes;
        String[] ips = ip.split("\\.");
        int prefix_value = Integer.valueOf(ips[0]) * 256 + Integer.valueOf(ips[1]);
        long ip2long_value = IPConvertUtil.ip2long(ip);
        int start = index[prefix_value];
        int max_comp_len = offset - 262144 - 4;
        long index_offset = -1L;
        int index_length = -1;
        byte b = 0;
        for (start = start * 9 + 262144; start < max_comp_len; start += 9) {
            long tmpInt = IPConvertUtil.int2long(indexBuffer.getInt(start));
            if (tmpInt < ip2long_value) continue;
            index_offset = IPConvertUtil.bytesToLong(b, indexBuffer.get(start + 6), indexBuffer.get(start + 5), indexBuffer.get(start + 4));
            index_length = ((0xFF & indexBuffer.get(start + 7)) << 8) + (0xFF & indexBuffer.get(start + 8));
            break;
        }
        lock.lock();
        try {
            dataBuffer.position(offset + (int)index_offset - 262144);
            areaBytes = new byte[index_length];
            dataBuffer.get(areaBytes, 0, index_length);
        }
        finally {
            lock.unlock();
        }
        return new String(areaBytes, Charset.forName(DEFAULT_CHARSET)).split("\t", -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getBytesByFile() {
        String urlStr = "http://bxm-guide.oss-cn-shanghai.aliyuncs.com/dist/IP_File/ipipnet.datx";
        InputStream is = null;
        ByteArrayOutputStream os = null;
        byte[] buff = new byte[1024];
        int len = 0;
        try {
            URL url = new URL(UriUtils.encodePath((String)urlStr, (String)DEFAULT_CHARSET));
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestProperty("Content-Type", "plain/text;charset=UTF-8");
            conn.setRequestProperty("charset", DEFAULT_CHARSET);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setRequestMethod("GET");
            conn.setReadTimeout(20000);
            conn.connect();
            is = conn.getInputStream();
            os = new ByteArrayOutputStream();
            while ((len = is.read(buff)) != -1) {
                os.write(buff, 0, len);
            }
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            logger.error("\u53d1\u8d77\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.error("\u3010\u5173\u95ed\u6d41\u5f02\u5e38\u3011");
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    logger.error("\u3010\u5173\u95ed\u6d41\u5f02\u5e38\u3011");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getBytesByFile(File ipFile) throws IOException {
        FileInputStream fin = null;
        long len = ipFile.length();
        byte[] bs = new byte[new Long(len).intValue()];
        try {
            int i;
            fin = new FileInputStream(ipFile);
            int readBytesLength = 0;
            while ((i = ((InputStream)fin).available()) > 0) {
                ((InputStream)fin).read(bs, readBytesLength, i);
                readBytesLength += i;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            try {
                if (fin != null) {
                    ((InputStream)fin).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return bs;
    }

    private static long bytesToLong(byte a, byte b, byte c, byte d) {
        return IPConvertUtil.int2long((a & 0xFF) << 24 | (b & 0xFF) << 16 | (c & 0xFF) << 8 | d & 0xFF);
    }

    private static int str2Ip(String ip) {
        String[] ss = ip.split("\\.");
        int a = Integer.parseInt(ss[0]);
        int b = Integer.parseInt(ss[1]);
        int c = Integer.parseInt(ss[2]);
        int d = Integer.parseInt(ss[3]);
        return a << 24 | b << 16 | c << 8 | d;
    }

    private static long ip2long(String ip) {
        return IPConvertUtil.int2long(IPConvertUtil.str2Ip(ip));
    }

    private static long int2long(int i) {
        long l = (long)i & Integer.MAX_VALUE;
        if (i < 0) {
            l |= 0x80000000L;
        }
        return l;
    }

    private static void load() {
        lock.lock();
        try {
            File file = IPConvertUtil.getIpFile();
            byte[] bytes = IPConvertUtil.getBytesByFile(file);
            dataBuffer = ByteBuffer.wrap(bytes);
            dataBuffer.position(0);
            offset = dataBuffer.getInt();
            byte[] indexBytes = new byte[offset];
            dataBuffer.get(indexBytes, 0, offset - 4);
            indexBuffer = ByteBuffer.wrap(indexBytes);
            indexBuffer.order(ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < 256; ++i) {
                for (int j = 0; j < 256; ++j) {
                    IPConvertUtil.index[i * 256 + j] = indexBuffer.getInt();
                }
            }
            indexBuffer.order(ByteOrder.BIG_ENDIAN);
        }
        catch (Exception e) {
            throw new RuntimeException("load", e);
        }
        finally {
            lock.unlock();
        }
    }

    private static File getIpFile() {
        String lastVersion = "http://bxm-guide.oss-cn-shanghai.aliyuncs.com/dist/IP_File/ipipnet.datx";
        String fileName = StringUtils.substringAfterLast((String)lastVersion, (String)"/");
        String rootPath = com.bxm.newidea.component.tools.FileUtils.getClassRootPath();
        File appFile = new File(rootPath + fileName);
        if (appFile.exists()) {
            return appFile;
        }
        try {
            FileUtils.copyURLToFile((URL)new URL(lastVersion), (File)appFile);
        }
        catch (IOException e) {
            logger.error("ip\u5b58\u653e\u7684\u914d\u7f6e\u6587\u4ef6\u8def\u5f84\u4e0d\u6b63\u786e", (Throwable)e);
        }
        return appFile;
    }

    static {
        index = new int[65536];
        initd = true;
        lock = new ReentrantLock();
    }
}

