package com.bxm.localnews.news.convert.impl;

import com.bxm.localnews.news.vo.ForumPostVo;
import com.bxm.localnews.news.vo.ForumTopPost;
import com.google.common.base.Converter;
import org.springframework.stereotype.Component;

import java.util.Objects;
import java.util.stream.Collectors;

@Component
public class ForumTopPostConvert extends Converter<ForumPostVo, ForumTopPost> {

    @Override
    protected ForumTopPost doForward(ForumPostVo forumPostVo) {
        ForumTopPost forumTopPost = new ForumTopPost();
        forumTopPost.setAddTime(forumPostVo.getCreateTime());
        forumTopPost.setAreaCode(forumPostVo.getAreaCode());
        forumTopPost.setId(forumPostVo.getId());
        forumTopPost.setDisplayTime(forumPostVo.getDisplayDateTime());
        forumTopPost.setForumId(forumPostVo.getForumId());
        forumTopPost.setTopicIds(forumPostVo.getTopicIdList().stream().filter(Objects::nonNull).collect(Collectors.toList()));
        return forumTopPost;
    }

    @Override
    protected ForumPostVo doBackward(ForumTopPost forumTopPost) {
        return null;
    }
}
