package com.bxm.localnews.news.convert.impl;

import com.bxm.localnews.news.param.HomeRecommendParam;
import com.bxm.localnews.news.vo.NewsRecommendParam;
import com.google.common.base.Converter;
import org.springframework.stereotype.Component;

@Component
public class NewsRecommendConvert extends Converter<HomeRecommendParam, NewsRecommendParam> {

    @Override
    protected NewsRecommendParam doForward(HomeRecommendParam homeRecommendParam) {
        //如果是在提审中
        NewsRecommendParam newsRecommendParam = new NewsRecommendParam();
        newsRecommendParam.setAreaCode(homeRecommendParam.getAreaCode());
        newsRecommendParam.setCurPage(homeRecommendParam.getPageNum());
        newsRecommendParam.setKindId(homeRecommendParam.getKindId());
        newsRecommendParam.setPagesize(homeRecommendParam.getPageSize());
        if (homeRecommendParam.getRecommendType() != null) {
            newsRecommendParam.setType((byte) homeRecommendParam.getRecommendType().intValue());
        } else {
            newsRecommendParam.setType((byte) 1);
        }
        newsRecommendParam.setUserId(homeRecommendParam.getUserId());
        return newsRecommendParam;
    }

    @Override
    protected HomeRecommendParam doBackward(NewsRecommendParam newsRecommendParam) {
        return null;
    }
}
