package com.bxm.localnews.news.service;

import com.bxm.localnews.news.param.NoteParam;
import com.bxm.localnews.news.vo.NotePublishVo;
import com.bxm.localnews.news.vo.NoteVo;
import com.bxm.newidea.component.vo.Message;

import java.util.Date;
import java.util.List;

/**
 * 小纸条相关服务
 */
public interface NoteService {

    /**
     * 发布小纸条
     *
     * @param noteParam
     * @return
     */
    Message create(NoteParam noteParam);

    /**
     * 删除小纸条
     *
     * @param noteId
     * @return
     */
    Message delete(Long noteId);

    /**
     * 获取小纸条发布页面参数
     *
     * @param userId
     * @return
     */
    NotePublishVo getNotePublish(Long userId);

    /**
     * 批量获取用户小纸条
     *
     * @param userIdList
     * @param currentUserId
     * @return
     */
    List<NoteVo> batchGetUserNote(List<Long> userIdList, Long currentUserId);

    /**
     * 批量缓存一定时间内更新的用户小纸条
     *
     * @return
     */
    void cacheUserNote(Date startTime);

    /**
     * 获取用户小纸条列表
     *
     * @param userId
     * @return
     */
    List<NoteVo> getUserNoteList(Long userId);
}
