package com.bxm.localnews.news.service;

import com.bxm.localnews.news.dto.UserLikeDTO;
import org.springframework.http.HttpStatus;

import java.util.Date;
import java.util.List;

/**
 * 用户新闻阅读标签服务接口
 * @author liujia 2018/7/31 10:44
 */
public interface UserTagService {

    /**
     * 复制用户标签
     * @param fromUid 来源用户0
     * @param toUid   目标用户
     * @param time    限定时间内的标签
     * @return
     */
    int doCopyTags(Long fromUid, Long toUid, Date time);

    /**
     * 统计用户的点赞数
     * @param userIds
     * @return
     */
    List<UserLikeDTO> getLikeNumByUserIds(List<Long> userIds);
}
