package com.bxm.localnews.news.service;

import com.bxm.localnews.news.dto.VideoReplyDto;
import com.bxm.localnews.news.param.VideoReplyLikeParam;
import com.bxm.localnews.news.param.VideoReplyListQueryParam;
import com.bxm.localnews.news.param.VideoReplyParam;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;

/**
 * 小视频回复接口
 */
public interface VideoReplyService {

    /**
     * 用途：分页查询小视频回复列表（包含id，头像，名称，回复点赞数）
     * @param param
     * @return
     */
    PageWarper<VideoReplyDto> queryByPageSize(VideoReplyListQueryParam param);

    /**
     * 用途：用户对视频进行评论，或者对评论进行回复,更新新闻信息
     * @param videoReplyParam
     * @return
     */
    Message replyVideo(VideoReplyParam videoReplyParam);

    /**
     * 用途：用户对小视频的评论进行点赞后，都在服务端处理并输送至redis阻塞队列，等待
     * 消费端，每5秒钟消费一次,更新评论信息
     * @param videoReplyLikeParam
     */
    Message produceVideoReplyLike(VideoReplyLikeParam videoReplyLikeParam);

}
