package com.bxm.localnews.news.service.impl;

import com.bxm.component.mybatis.utils.BatchHelper;
import com.bxm.localnews.news.domain.InitTagMapper;
import com.bxm.localnews.news.domain.UserTagMapper;
import com.bxm.localnews.news.service.InitTagService;
import com.bxm.localnews.news.vo.InitTag;
import com.bxm.localnews.news.vo.UserTag;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class InitTagServiceImpl extends BaseService implements InitTagService {

    private InitTagMapper initTagMapper;

    @Autowired
    public InitTagServiceImpl(InitTagMapper initTagMapper) {
        this.initTagMapper = initTagMapper;
    }

    @Override
    public Message createInitTags(Long userId) {
        Assert.notNull(userId, "userId must has text");
        List<InitTag> initTagList = initTagMapper.selectAllTag();
        List<UserTag> userTags = initTagList.stream().map(e -> {
            UserTag userTag = new UserTag();
            userTag.setName(e.getName());
            userTag.setRatio(e.getRatio());
            userTag.setTagType(e.getTagType());
            return userTag;
        }).collect(Collectors.toList());

        Date current = new Date();
        new BatchHelper<UserTagMapper, UserTag>(UserTagMapper.class, userTags) {

            @Override
            protected int invoke(UserTag element) {
                element.setId(nextId());
                element.setUserId(userId);
                element.setStatus((byte) 1);
                element.setUpdateTime(current);
                return mapper.insert(element);
            }
        };
        return Message.build(true);
    }

}
