package com.bxm.localnews.news.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.news.config.ForumProperties;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.NewsShieldMapper;
import com.bxm.localnews.news.enums.NewsShieldEnum;
import com.bxm.localnews.news.param.NewsShieldParam;
import com.bxm.localnews.news.service.NewsShieldService;
import com.bxm.localnews.news.vo.NewsShield;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.service.BaseService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

@Slf4j
@Service
@AllArgsConstructor(onConstructor_ = {@Autowired})
public class NewsNewsShieldServiceImpl extends BaseService implements NewsShieldService {

    private final NewsShieldMapper newsShieldMapper;

    private final HttpClientService httpClientService;

    private final ForumProperties forumProperties;

    private final RedisSetAdapter redisSetAdapter;

    @Override
    public void save(NewsShieldParam newsShieldParam) {
        //插入数据库
        NewsShield newsShield = new NewsShield();
        BeanUtils.copyProperties(newsShieldParam, newsShield);
        newsShield.setId(nextSequence());
        newsShield.setAddTime(new Date());
        newsShieldMapper.insert(newsShield);

        //如果是屏蔽用户和屏蔽此条就放进redis中
        KeyGenerator keyGenerator;
        if (NewsShieldEnum.SHIELD_NEWS.getCode() == newsShieldParam.getShieldType()) {
            keyGenerator = RedisConfig.NEWS_SHIELD.copy().appendKey("detail").appendKey(newsShieldParam.getUserId());
            redisSetAdapter.add(keyGenerator, newsShieldParam.getShieldNewsId());
        } else if (NewsShieldEnum.SHIELD_USER.getCode() == newsShieldParam.getShieldType()) {
            keyGenerator = RedisConfig.NEWS_SHIELD.copy().appendKey("user").appendKey(newsShieldParam.getUserId());
            redisSetAdapter.add(keyGenerator, newsShieldParam.getShieldUserId());
        }

        //如果是广告和违法就推送至钉钉
        if (NewsShieldEnum.SHIELD_ADVERT.getCode() == newsShieldParam.getShieldType()
                || NewsShieldEnum.SHIELD_ILLEGAL.getCode() == newsShieldParam.getShieldType()) {
            StringBuilder content = new StringBuilder();
            content.append("------")
                    .append(DateFormatUtils.format(new Date(), "MM月dd日HH时mm分"))
                    .append("------\n");

            content.append("昵称：[ID=").append(newsShieldParam.getUserId()).append("]\n");
            content.append("内容标题：[ID=").append(newsShieldParam.getShieldNewsId()).append("]\n");
            if (3 == newsShieldParam.getShieldType()) {
                content.append("投诉类型：[投诉广告]");
            } else {
                content.append("投诉类型：[内容涉嫌违法]");
            }

            JSONObject text = new JSONObject();
            text.put("content", content);
            JSONObject msg = new JSONObject();
            msg.put("msgtype", "text");
            msg.put("text", text);
            String response = httpClientService.doPostJson(forumProperties.getCalculatePostWebhook(), msg.toJSONString());
            log.debug("dingding response:{}", response);
        }
    }
}
