package com.bxm.localnews.news.service.impl;

import com.bxm.component.mybatis.utils.BatchHelper;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.domain.UserReplyMapper;
import com.bxm.localnews.news.domain.UserTagMapper;
import com.bxm.localnews.news.dto.UserLikeDTO;
import com.bxm.localnews.news.service.UserTagService;
import com.bxm.localnews.news.vo.UserTag;
import com.bxm.newidea.component.service.BaseService;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service
public class UserTagServiceImpl extends BaseService implements UserTagService {

    private UserTagMapper userTagMapper;

    private ForumPostMapper forumPostMapper;

    private UserReplyMapper userReplyMapper;

    public UserTagServiceImpl(UserTagMapper userTagMapper,
                              ForumPostMapper forumPostMapper,
                              UserReplyMapper userReplyMapper) {
        this.userTagMapper = userTagMapper;
        this.forumPostMapper = forumPostMapper;
        this.userReplyMapper = userReplyMapper;
    }

    @Override
    public int doCopyTags(Long fromUid, Long toUid, Date time) {
        List<UserTag> userTags = userTagMapper.getUserTag(fromUid);
        Date current = new Date();
        new BatchHelper<UserTagMapper, UserTag>(UserTagMapper.class, userTags) {

            @Override
            protected int invoke(UserTag element) {
                element.setId(nextId());
                element.setUserId(toUid);
                element.setUpdateTime(current);
                return mapper.insert(element);
            }
        };
        return 1;
    }

    @Override
    public List<UserLikeDTO> getLikeNumByUserIds(List<Long> userIds) {
        List<UserLikeDTO> result = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(userIds)){
            userIds.forEach(e->{
                UserLikeDTO userLikeDTO = new UserLikeDTO();
                userLikeDTO.setUserId(e);
                Integer postNum  = forumPostMapper.getPostLikeNumByUserId(e);
                Integer replyNum  = userReplyMapper.selectReplyLikeNumByUserId(e);
                userLikeDTO.setLikeNum(postNum+replyNum);
                result.add(userLikeDTO);
            });
        }
        return result;
    }

}
