package com.bxm.localnews.news.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.integration.NewsRecommendIntegrationService;
import com.bxm.localnews.news.dto.VideoDto;
import com.bxm.localnews.news.param.VideoQueryParam;
import com.bxm.localnews.news.service.VideoRecommendService;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;

@Service
public class VideoRecommendServiceImpl extends BaseService implements VideoRecommendService {

    private NewsRecommendIntegrationService newsRecommendIntegrationService;

    @Autowired
    public VideoRecommendServiceImpl(NewsRecommendIntegrationService newsRecommendIntegrationService) {
        this.newsRecommendIntegrationService = newsRecommendIntegrationService;
    }

    @Override
    public List<VideoDto> execRecommend(VideoQueryParam param) {
        List<VideoDto> result = newsRecommendIntegrationService.recommendVideoList(param.getUserId(),
                param.getPageSize());

        //将小视频的URL中的特殊字符进行转码
        if (CollectionUtils.isNotEmpty(result)) {
            result.forEach(video -> {
                String videoUrl = video.getVideoUrl();
                video.setVideoUrl(videoAddressConversion(videoUrl));
            });
        }

        return result;
    }

    @Override
    public String videoAddressConversion(String oldAddress) {
        if (StringUtils.isBlank(oldAddress)){
            return  oldAddress;
        }

        int fistQuestionMarkIndex = StringUtils.indexOf(oldAddress, "?") + 1;
        String firstPart = StringUtils.substring(oldAddress, 0, fistQuestionMarkIndex);
        oldAddress = StringUtils.substring(oldAddress, fistQuestionMarkIndex);
        try {
            String queryPart = URLEncoder.encode(oldAddress, StandardCharsets.UTF_8.name());
            queryPart = StringUtils.replace(queryPart, "%25", "%");
            queryPart = StringUtils.replace(queryPart, "%26", "&");
            queryPart = StringUtils.replace(queryPart, "%3D", "=");
            return firstPart + queryPart;
        } catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), e);
            return oldAddress;
        }

    }
}


















