package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.news.domain.*;
import com.bxm.localnews.news.dto.NewsReplyDTO;
import com.bxm.localnews.news.dto.VideoReplyDto;
import com.bxm.localnews.news.param.*;
import com.bxm.localnews.news.service.*;
import com.bxm.localnews.news.vo.*;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
@Deprecated
public class VideoReplyServiceImpl extends BaseService implements VideoReplyService {

    private final VideoMapper videoMapper;

    private final VideoReplyLikeMapper videoReplyLikeMapper;

    private final UserIntegrationService userIntegrationService;

    private final NewsReplyMapper newsReplyMapper;

    private final NewNewsReplyService newsReplyService;

    private final UserReplyMapper userReplyMapper;

    @Autowired
    public VideoReplyServiceImpl(
                                 VideoMapper videoMapper, VideoReplyLikeMapper videoReplyLikeMapper,
                                 UserIntegrationService userIntegrationService,NewsReplyMapper newsReplyMapper,
                                 NewNewsReplyService newsReplyService,UserReplyMapper userReplyMapper) {
        this.videoMapper = videoMapper;
        this.videoReplyLikeMapper = videoReplyLikeMapper;
        this.userIntegrationService = userIntegrationService;
        this.newsReplyMapper = newsReplyMapper;
        this.newsReplyService = newsReplyService;
        this.userReplyMapper= userReplyMapper;
    }

    @Override
    public PageWarper<VideoReplyDto> queryByPageSize(VideoReplyListQueryParam param) {

        NewsReplyParam newsReplyParam = new NewsReplyParam();
        newsReplyParam.setPageNum(param.getPageNum());
        newsReplyParam.setPageSize(param.getPageSize());
        newsReplyParam.setUserId(param.getUserId());
        newsReplyParam.setNewsId(param.getVideoId());
        List<VideoReplyDto> videoReplyDtoList = new ArrayList<>();

        PageWarper<NewsReplyDTO> newsReplyDTOPageWarper = new PageWarper<>(this.newsReplyMapper.queryVideoReplyByPageSize(newsReplyParam));
        List<NewsReplyDTO> newsReplyDTOList = newsReplyDTOPageWarper.getList();
        for (NewsReplyDTO newsReplyDTO:newsReplyDTOList) {
            VideoReplyDto videoReplyDto = new VideoReplyDto();
            if (isLike(newsReplyDTO.getUserId(),newsReplyDTO.getId())) {
                videoReplyDto.setIsLike(1);
            }
            videoReplyDto.setAddTime(newsReplyDTO.getAddTime());
            videoReplyDto.setComment(newsReplyDTO.getReplyContent());
            videoReplyDto.setDeleleFlag(newsReplyDTO.getDeleteFlag());
            videoReplyDto.setId(newsReplyDTO.getId());
            videoReplyDto.setLikeCount(newsReplyDTO.getLikeCount());
            videoReplyDto.setUserId(newsReplyDTO.getUserId());
            videoReplyDto.setUserImg(newsReplyDTO.getHeadImg());
            videoReplyDto.setUserName(newsReplyDTO.getUserNickname());

            if (newsReplyDTO.getParentId()!=0) {
                NewsReply sourceReply = newsReplyMapper.selectByPrimaryKey(newsReplyDTO.getParentId());
                if (null != sourceReply) {
                    VideoReplyDto vSourceReply = new VideoReplyDto();
                    if (isLike(sourceReply.getUserId(),sourceReply.getId())) {
                        vSourceReply.setIsLike(1);
                    }
                    vSourceReply.setAddTime(sourceReply.getAddTime());
                    vSourceReply.setComment(sourceReply.getReplyContent());
                    vSourceReply.setDeleleFlag(sourceReply.getDeleteFlag());
                    vSourceReply.setId(sourceReply.getId());
                    vSourceReply.setLikeCount(sourceReply.getLikeCount());
                    vSourceReply.setUserId(sourceReply.getUserId());
                    vSourceReply.setUserImg(sourceReply.getHeadImg());
                    vSourceReply.setUserName(sourceReply.getUserNickname());
                    videoReplyDto.setSourceReply(vSourceReply);
                }

            }
            videoReplyDtoList.add(videoReplyDto);
        }

        return new PageWarper<>(videoReplyDtoList);
    }


    /**
     * 判断当前用户是否对此回复点赞
     * @param userId
     * @param replyId
     * @return
     */
    private boolean isLike(Long userId, Long replyId) {
        VideoReplyLike videoReplyLike = videoReplyLikeMapper.selectByModel(new VideoReplyLike(replyId, userId));
        return null != videoReplyLike;
    }

    @Override
    public Message replyVideo(VideoReplyParam videoReplyParam) {
        if (!checkReplyParam(videoReplyParam)) {
            return Message.build(false, "参数验证错误");
        }
        NewsReply newsReply = new NewsReply();
        newsReply.setType((byte) 2);
        newsReply.setNewsId(videoReplyParam.getVideoId());
        newsReply.setRootId(0L);
        newsReply.setParentId(0L);
        newsReply.setLevel((byte) 0);
        newsReply.setStatus((byte) 1);
        newsReply.setLikeCount(0);
        newsReply.setId(nextSequence());
        newsReply.setReplyContent(videoReplyParam.getComment());
        if (videoReplyParam.getReplyId() != null ) {
            NewsReply newsReplyDb = newsReplyMapper.selectByPrimaryKey(videoReplyParam.getReplyId());
            if (newsReplyDb != null) {
                UserBean userInfoDTO = userIntegrationService.selectUserFromCache(newsReplyDb.getUserId());
                if (null!=userInfoDTO) {
                    newsReply.setParentUserNickname(userInfoDTO.getNickname());
                    newsReply.setParentUserId(userInfoDTO.getId());
                    newsReply.setParentHeadImg(userInfoDTO.getHeadImg());
                }
                newsReply.setParentId(newsReplyDb.getId());
                newsReply.setRootId(newsReplyDb.getRootId());
                Byte level = newsReplyDb.getLevel();
                if (level == 0) {
                    newsReply.setLevel((byte) 1);
                    newsReply.setRootId(newsReplyDb.getId());
                } else {
                    newsReply.setLevel((byte) 2);
                    newsReply.setRootId(newsReplyDb.getRootId());
                }
            }
        }

        UserBean userInfoDTO = userIntegrationService.selectUserFromCache(videoReplyParam.getUserId());
        if (null!=userInfoDTO) {
            newsReply.setUserNickname(userInfoDTO.getNickname());
            newsReply.setUserId(userInfoDTO.getId());
            newsReply.setHeadImg(userInfoDTO.getHeadImg());
        }

        int count = newsReplyMapper.insertSelective(newsReply);
        UserReply userReply = new UserReply();
        BeanUtils.copyProperties(newsReply,userReply);
        userReplyMapper.insertSelective(userReply);
        // 更新新闻评论数
        if (count>0) {
            Video video = videoMapper.selectByPrimaryKey(videoReplyParam.getVideoId());
            if (null != video) {
                Video videoUp = new Video();
                videoUp.setId(videoReplyParam.getVideoId());
                videoUp.setCommentCount(video.getCommentCount() + 1);
                videoMapper.updateByPrimaryKeySelective(videoUp);
            }
        }
        return Message.build(true);
    }

    /**
     * 评论回复时验证参数
     * @param videoReplyParam
     * @return
     */
    private boolean checkReplyParam(VideoReplyParam videoReplyParam) {
        if (null == videoReplyParam.getUserId()
                || null == videoReplyParam.getComment() || null == videoReplyParam.getVideoId()) {
            return false;
        }
        return true;
    }



    @Override
    public Message produceVideoReplyLike(VideoReplyLikeParam videoReplyLikeParam) {
        if (!checkLikeParam(videoReplyLikeParam)) {
            return Message.build(false, "参数验证错误");
        }

        NewsReplyLikeParam newsReplyLikeParam = new NewsReplyLikeParam();
        newsReplyLikeParam.setReplyId(videoReplyLikeParam.getReplyId());
        newsReplyLikeParam.setType(videoReplyLikeParam.getType());
        newsReplyLikeParam.setUserId(videoReplyLikeParam.getUserId());
        return newsReplyService.doProduceNewsReplyLike(newsReplyLikeParam);

    }

    /**
     * 评论点赞时验证参数
     * @param videoReplyLikeParam
     * @return
     */
    private boolean checkLikeParam(VideoReplyLikeParam videoReplyLikeParam) {
        if (null == videoReplyLikeParam.getReplyId() || null == videoReplyLikeParam.getUserId()) {
            return false;
        }
        return true;
    }

}
