package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.VideoBlackMapper;
import com.bxm.localnews.news.domain.VideoMapper;
import com.bxm.localnews.news.domain.VideoShareMapper;
import com.bxm.localnews.news.domain.VideoViewMapper;
import com.bxm.localnews.news.param.VideoBlackParam;
import com.bxm.localnews.news.param.VideoShareParam;
import com.bxm.localnews.news.param.VideoViewParam;
import com.bxm.localnews.news.service.VideoStatisticService;
import com.bxm.localnews.news.vo.Video;
import com.bxm.localnews.news.vo.VideoBlack;
import com.bxm.localnews.news.vo.VideoShare;
import com.bxm.localnews.news.vo.VideoView;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.service.BaseService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service
public class VideoStatisticServiceImpl extends BaseService implements VideoStatisticService {

    @Autowired
    VideoBlackMapper videoBlackMapper;

    @Autowired
    VideoShareMapper videoShareMapper;

    @Autowired
    VideoViewMapper videoViewMapper;

    @Autowired
    VideoMapper videoMapper;

    @Autowired
    RedisListAdapter redisListAdapter;

    @Async
    @Override
    public void videoBlackConsume(VideoBlackParam videoBlackParam) {
        if (null != videoBlackParam) {
            VideoBlack videoBlack = new VideoBlack();
            BeanUtils.copyProperties(videoBlackParam, videoBlack);
            videoBlack.setId(nextSequence());
            videoBlack.setAddTime(new Date());
            videoBlackMapper.insertSelective(videoBlack);
        }
    }

    @Async
    @Override
    public void videoShareConsume(VideoShareParam videoShareParam) {
        if (null != videoShareParam) {
            //更新新闻分享数量
            Video videoUp = new Video();
            videoUp.setId(videoShareParam.getVideoId());
            videoUp.setShareCount((long) 1);
            videoMapper.updateStatisticByPrimaryKeySelective(videoUp);
        }
    }

    @Async
    @Override
    public void videoViewConsume(VideoViewParam videoViewParam) {
        if (null != videoViewParam) {
            VideoView videoView = new VideoView();
            BeanUtils.copyProperties(videoViewParam, videoView);
            videoView.setId(nextSequence());
            videoViewMapper.insertSelective(videoView);
            //更新新闻点击播放数
            Video videoUp = new Video();
            videoUp.setId(videoView.getVideoId());
            videoUp.setClickCount((long) 1);
            videoMapper.updateStatisticByPrimaryKeySelective(videoUp);

        }
    }

    @Override
    public void videoCommentsConsume(Long userId,Long videoId) {
        Video videoUp = new Video();
        videoUp.setId(videoId);
        videoUp.setCommentCount((long) 1);
        videoMapper.updateStatisticByPrimaryKeySelective(videoUp);

    }
}
