package com.bxm.localnews.news.task;

import com.bxm.localnews.news.service.ForumPostStatisticService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 创建即发布的周期定时任务
 */
@Component
@Slf4j
public class PostLikeRefreshTask extends AbstractCronTask<String> {

    @Resource
    private ForumPostStatisticService forumPostStatisticService;

    @Override
    protected ReturnT<String> service(String param) {
        log.info("定时修改帖子点赞数据..............");
        forumPostStatisticService.doRefreshLikeInfo();
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "postLikeRefreshTask";
    }

    @Override
    public String cron() {
        return "0 3/5 * * * ? ";
    }

    @Override
    public String description() {
        return "定时修改帖子点赞数据";
    }

}
