package com.bxm.localnews.news.timer;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.vo.ForumPostVo;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * 帖子定时
 */
@Component
@Slf4j
public class ForumSchedule {

    @Resource
    private ForumPostMapper forumPostMapper;

    @Resource
    private RedisStringAdapter redisStringAdapter;

    /**
     * 每五分钟将轮播帖子同步到缓存
     */
    @Scheduled(cron="0 0/5 * * * ?")
    public void synchronizeRewardList(){
        List<ForumPostVo> forumPostVoList = forumPostMapper.getRewardPostList(50);
        if (CollectionUtils.isNotEmpty(forumPostVoList)) {
            redisStringAdapter.set(RedisConfig.FORUM_POST_REWARD_LIST.copy(), JSON.toJSONString(forumPostVoList));
        }
    }
}
