/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.convert.impl;

import com.bxm.localnews.news.convert.Converter;
import com.bxm.localnews.news.domain.ForumTopicMapper;
import com.bxm.localnews.news.util.AreaCodeUtils;
import com.bxm.localnews.news.util.UploadUtils;
import com.bxm.localnews.news.vo.ForumBasicVo;
import com.bxm.localnews.news.vo.ForumPostVo;
import com.bxm.localnews.news.vo.PostImgVo;
import com.bxm.localnews.news.vo.TopicVo;
import com.bxm.newidea.component.emoji.EmojiCodeParser;
import com.bxm.newidea.component.service.BaseService;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ForumBasicConvert
extends BaseService
implements Converter<ForumBasicVo, ForumPostVo> {
    private final ForumTopicMapper forumTopicMapper;
    private final UploadUtils uploadUtils;

    @Override
    public ForumPostVo convert(ForumBasicVo data) {
        TopicVo topic;
        ForumPostVo forumPostVo = new ForumPostVo();
        data.setTextField(EmojiCodeParser.replaceSoftbankEmoji((String)data.getTextField()));
        BeanUtils.copyProperties((Object)data, (Object)forumPostVo);
        if (Objects.nonNull(data.getIsNewReport()) && data.getIsNewReport() == 1) {
            forumPostVo.setStatus(Integer.valueOf(6));
        } else {
            forumPostVo.setStatus(Integer.valueOf(2));
        }
        if (StringUtils.isBlank((CharSequence)forumPostVo.getLocation())) {
            forumPostVo.setLocation(null);
        }
        forumPostVo.setDeliveryType(Integer.valueOf(0));
        if (StringUtils.isNotBlank((CharSequence)forumPostVo.getAreaCode())) {
            forumPostVo.setDeliveryType(Integer.valueOf(1));
            forumPostVo.setAreaCode(AreaCodeUtils.completeAreaCode((String)forumPostVo.getAreaCode()));
        }
        if (CollectionUtils.isNotEmpty((Collection)data.getTopicIdList()) && (topic = this.forumTopicMapper.selectTopicById((Long)data.getTopicIdList().get(0), null)) != null) {
            data.setForumContent(topic.getContent());
        }
        StringBuilder content = new StringBuilder("<p>");
        if (StringUtils.isNotBlank((CharSequence)forumPostVo.getTextField())) {
            content.append(forumPostVo.getTextField().replaceAll("\\n", "</p><p>"));
        }
        content.append("</p>");
        if (StringUtils.isNotBlank((CharSequence)forumPostVo.getExtraContent())) {
            content.append("<p>");
            content.append(forumPostVo.getExtraContent());
            content.append("</p>");
        }
        if (CollectionUtils.isNotEmpty((Collection)forumPostVo.getPostImgList())) {
            this.dealPostImgList(forumPostVo, content);
        }
        forumPostVo.setContent(content.toString());
        if (StringUtils.isBlank((CharSequence)data.getLocation())) {
            forumPostVo.setLocation(null);
        }
        return forumPostVo;
    }

    private void dealPostImgList(ForumPostVo forumPostVo, StringBuilder content) {
        forumPostVo.getPostImgList().forEach(e -> {
            if (StringUtils.isBlank((CharSequence)e.getType())) {
                e.setType("IMG");
            }
        });
        List postVideoList = forumPostVo.getPostImgList().stream().filter(e -> "VIDEO".equals(e.getType())).collect(Collectors.toList());
        List postImgList = forumPostVo.getPostImgList().stream().filter(e -> "IMG".equals(e.getType())).collect(Collectors.toList());
        for (PostImgVo postImgVo : postVideoList) {
            if (!StringUtils.isNotBlank((CharSequence)postImgVo.getVideoUrl())) continue;
            content.append("<p>&nbsp;<video controls=\"controls\" src=\"");
            content.append(postImgVo.getVideoUrl());
            content.append("\" poster=\"");
            content.append(postImgVo.getImgUrl());
            content.append("\" size=\"");
            content.append(postImgVo.getSize() == null ? Integer.valueOf(0) : postImgVo.getSize());
            content.append("\" duration=\"");
            content.append(postImgVo.getDuration() == null ? 0L : postImgVo.getDuration());
            content.append("\"></video>&nbsp;</p>");
        }
        for (PostImgVo postImgVo : postImgList) {
            String imgUrl = postImgVo.getImgUrl();
            if (!imgUrl.contains("wstong.com")) {
                imgUrl = this.uploadUtils.uploadImgToOssBySrc(imgUrl);
            }
            if (!StringUtils.isNotBlank((CharSequence)postImgVo.getImgUrl())) continue;
            content.append("<p><img src=\"");
            content.append(imgUrl);
            content.append("\"></img></p>");
        }
        postVideoList.addAll(postImgList);
        forumPostVo.setPostImgList(postVideoList);
    }

    @Autowired
    public ForumBasicConvert(ForumTopicMapper forumTopicMapper, UploadUtils uploadUtils) {
        this.forumTopicMapper = forumTopicMapper;
        this.uploadUtils = uploadUtils;
    }
}

