/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.convert.impl;

import com.bxm.localnews.news.dto.ForumPostCreateDTO;
import com.bxm.localnews.news.dto.NewsCompleTaskDTO;
import com.bxm.localnews.news.enums.UrlCategoryEnum;
import com.bxm.localnews.news.enums.UrlPositionEnum;
import com.bxm.localnews.news.enums.UrlTypeEnum;
import com.bxm.localnews.news.factory.IUrlFactory;
import com.bxm.localnews.news.vo.ForumPostVo;
import com.bxm.localnews.news.vo.PostImgVo;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ForumPostCreateConvert {
    @Autowired
    private IUrlFactory iUrlFactory;

    public ForumPostCreateDTO generateForumPost(ForumPostVo forumPostVo, NewsCompleTaskDTO newsCompleTaskDTO, Long userId) {
        ForumPostCreateDTO.ForumPost forumPost = new ForumPostCreateDTO.ForumPost();
        forumPost.setId(forumPostVo.getId());
        if (CollectionUtils.isNotEmpty((Collection)forumPostVo.getPostImgList())) {
            forumPost.setPostImgUrl(((PostImgVo)forumPostVo.getPostImgList().get(0)).getImgUrl());
        }
        forumPost.setTextField(forumPostVo.getTextField());
        forumPost.setTitle(forumPostVo.getTitle());
        ForumPostCreateDTO forumPostCreateDTO = new ForumPostCreateDTO();
        forumPostCreateDTO.setGoldNum(Long.valueOf(Objects.isNull(newsCompleTaskDTO.getGoldNum()) ? 0L : newsCompleTaskDTO.getGoldNum()));
        forumPostCreateDTO.setTaskName(newsCompleTaskDTO.getTaskName());
        forumPostCreateDTO.setTotalGold(newsCompleTaskDTO.getTotalGold());
        forumPostCreateDTO.setShareUrl(this.iUrlFactory.getAppUrl(UrlCategoryEnum.FORUM, UrlTypeEnum.SHARE, forumPostVo.getId(), userId));
        forumPostCreateDTO.setAppletShareUrl(this.iUrlFactory.getAppletUrl(UrlPositionEnum.POST, forumPostVo.getId(), userId));
        forumPostCreateDTO.setForumPost(forumPost);
        return forumPostCreateDTO;
    }
}

