/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.convert.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.news.config.UserProperties;
import com.bxm.localnews.news.convert.Converter;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.domain.NewsReplyMapper;
import com.bxm.localnews.news.domain.VideoMapper;
import com.bxm.localnews.news.enums.NewsConstant;
import com.bxm.localnews.news.enums.ReplyStatusEnum;
import com.bxm.localnews.news.enums.ReplyTypeEnum;
import com.bxm.localnews.news.param.NewsReplyAddParam;
import com.bxm.localnews.news.vo.ForumPostVo;
import com.bxm.localnews.news.vo.NewsReply;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.newidea.component.service.BaseService;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NewsReplyConver
extends BaseService
implements Converter<NewsReplyAddParam, NewsReply> {
    private final UserIntegrationService userIntegrationService;
    private final UserProperties userProperties;
    private final VideoMapper videoMapper;
    private final NewsReplyMapper newsReplyMapper;
    private final ForumPostMapper forumPostMapper;

    @Autowired
    public NewsReplyConver(UserIntegrationService userIntegrationService, UserProperties userProperties, VideoMapper videoMapper, NewsReplyMapper newsReplyMapper, ForumPostMapper forumPostMapper) {
        this.userIntegrationService = userIntegrationService;
        this.userProperties = userProperties;
        this.videoMapper = videoMapper;
        this.newsReplyMapper = newsReplyMapper;
        this.forumPostMapper = forumPostMapper;
    }

    @Override
    public NewsReply convert(NewsReplyAddParam newsReplyAddParam) {
        String idStr;
        NewsReply newsReply = new NewsReply();
        BeanUtils.copyProperties((Object)newsReplyAddParam, (Object)newsReply);
        newsReply.setStatus(Byte.valueOf(ReplyStatusEnum.IS_SHOW.getCode()));
        newsReply.setLikeCount(Integer.valueOf(0));
        newsReply.setRootId(Long.valueOf(0L));
        newsReply.setLevel(Byte.valueOf((byte)0));
        newsReply.setAddTime(new Date());
        newsReply.setInteractiveCount(Integer.valueOf(0));
        newsReply.setId(this.nextSequence());
        if (null != newsReplyAddParam.getUserId()) {
            UserBean userBean = this.userIntegrationService.selectUserFromCache(newsReplyAddParam.getUserId());
            if (StringUtils.isBlank((CharSequence)userBean.getHeadImg()) || StringUtils.isBlank((CharSequence)userBean.getNickname())) {
                this.logger.info("\u8bc4\u8bba\u7528\u6237\u5934\u50cf\u6216\u6635\u79f0\u4e3a\u7a7a,userInfo={}", (Object)JSON.toJSONString((Object)userBean));
            }
            newsReply.setHeadImg(StringUtils.isBlank((CharSequence)userBean.getHeadImg()) ? this.userProperties.getDefaultHeadImgUrl() : userBean.getHeadImg());
            newsReply.setUserNickname(userBean.getNickname());
        }
        if (newsReplyAddParam.getType() == null) {
            newsReply.setType(Byte.valueOf(ReplyTypeEnum.NEWS_REPLY.getCode()));
        }
        if ((idStr = newsReplyAddParam.getNewsId().toString()).startsWith("4") && idStr.length() == 16) {
            newsReply.setType(Byte.valueOf(ReplyTypeEnum.POST_REPLY.getCode()));
        } else if (this.videoMapper.exists(newsReplyAddParam.getNewsId()) > 0) {
            newsReply.setType(Byte.valueOf(ReplyTypeEnum.VIDEO_REPLY.getCode()));
        } else {
            newsReply.setType(Byte.valueOf(ReplyTypeEnum.NEWS_REPLY.getCode()));
        }
        Boolean vestPost = false;
        if (newsReply.getParentId() == null || newsReply.getParentId() == 0L) {
            newsReply.setRootId(Long.valueOf(0L));
            newsReply.setParentId(Long.valueOf(0L));
            newsReply.setLevel(NewsConstant.REPLY_LEVEL_0);
            if (newsReplyAddParam.getType().byteValue() == ReplyTypeEnum.POST_REPLY.getCode()) {
                ForumPostVo forumPostVo = this.forumPostMapper.selectByPrimaryKey(newsReplyAddParam.getNewsId());
                UserBean postVoUser = this.userIntegrationService.selectUserFromCache(forumPostVo.getUserId());
                vestPost = Objects.nonNull(postVoUser) && postVoUser.getState() == 3;
            }
        } else {
            NewsReply newsReplyDb = this.newsReplyMapper.selectByPrimaryKeyAndNewsId(newsReply.getParentId(), newsReplyAddParam.getNewsId());
            if (newsReplyDb != null) {
                newsReply.setRootId(newsReplyDb.getRootId());
                Byte level = newsReplyDb.getLevel();
                if (level == 0) {
                    newsReply.setLevel(NewsConstant.REPLY_LEVEL_1);
                    newsReply.setRootId(newsReplyDb.getId());
                } else {
                    newsReply.setLevel(NewsConstant.REPLY_LEVEL_2);
                    newsReply.setRootId(newsReplyDb.getRootId());
                }
            }
        }
        if (Objects.nonNull(newsReplyAddParam.getParentUserId())) {
            UserBean parentUser = this.userIntegrationService.selectUserFromCache(newsReplyAddParam.getParentUserId());
            vestPost = vestPost != false || Objects.nonNull(parentUser) && Objects.nonNull(parentUser.getState()) && parentUser.getState() == 3;
        }
        if (vestPost.booleanValue()) {
            newsReply.setVestInteract(Byte.valueOf((byte)0));
        }
        return newsReply;
    }
}

