/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.integration.AppVersionIntegrationService;
import com.bxm.localnews.news.config.BizConfigProperties;
import com.bxm.localnews.news.constant.NewsTemplateConst;
import com.bxm.localnews.news.enums.ReplyTypeEnum;
import com.bxm.localnews.news.service.AssemblyService;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import com.bxm.newidea.component.tools.FileUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AssemblyServiceImpl
implements AssemblyService {
    private static final Logger log = LoggerFactory.getLogger(AssemblyServiceImpl.class);
    private final AliyunOSSService aliyunOSSService;
    private final AppVersionIntegrationService appVersionIntegrationService;
    private final BizConfigProperties bizConfigProperties;

    @Autowired
    public AssemblyServiceImpl(AliyunOSSService aliyunOSSService, AppVersionIntegrationService appVersionIntegrationService, BizConfigProperties bizConfigProperties) {
        this.aliyunOSSService = aliyunOSSService;
        this.appVersionIntegrationService = appVersionIntegrationService;
        this.bizConfigProperties = bizConfigProperties;
    }

    @Override
    public String assemblyContent(String target, BasicParam basicParam, String ip, byte type, Long userId, String areaCode, Long newsId) {
        String newsTemplate = NewsTemplateConst.getNewsTemplate();
        if (StringUtils.isBlank((String)newsTemplate)) {
            newsTemplate = this.aliyunOSSService.getOssContentByPath(NewsTemplateConst.getPath());
            NewsTemplateConst.setNewsTemplate((String)newsTemplate);
        }
        if (StringUtils.isNotBlank((String)target)) {
            target = this.fixContent(target, basicParam, ip, type, userId, areaCode, newsId);
            return newsTemplate.replace("{body}", target);
        }
        return newsTemplate;
    }

    @Override
    public String fixContent(String content, BasicParam basicParam, String ip, byte type, Long userId, String areaCode, Long newsId) {
        content = this.appletAdapter(content);
        Document document = Jsoup.parse((String)content);
        document.outputSettings().prettyPrint(true).indentAmount(1);
        this.addWatermark(document);
        this.deleteNbspFromVideo(document);
        if (this.appVersionIntegrationService.needProcessContentVideo(basicParam)) {
            this.processVideo2Img(document, basicParam);
        }
        this.processLink(document, basicParam, ip, type, userId, areaCode, newsId);
        return document.body().html().replace("\n", "");
    }

    private void processLink(Document document, BasicParam basicParam, String ip, byte type, Long userId, String areaCode, Long newsId) {
        Elements elements = document.select("a");
        if (!elements.isEmpty()) {
            for (Element element : elements) {
                String text = element.text();
                String ev = ReplyTypeEnum.POST_REPLY.getCode() == type ? "1.50.500.523." + newsId : "1.50.1700.1705." + newsId;
                String url = this.bizConfigProperties.getBuryPointHost() + "/dot/s.gif?ch=2&e=1015&p=news&s_type=1&a=" + areaCode + "&dtype=" + basicParam.getPlatform() + "&ev=" + ev + "&ip=" + ip + "&uid=" + userId + "&v=" + basicParam.getCurVer() + "&nlink=" + text;
                element.attr("onclick", "return\u00a0maidian('" + text + "','" + url + "')");
            }
        }
    }

    private void processVideo2Img(Document document, BasicParam basicParam) {
        Elements elements = document.select("video");
        if (!elements.isEmpty()) {
            for (Element element : elements) {
                String poster;
                String src = element.attr("src");
                if (StringUtils.isBlank((String)src) || StringUtils.isBlank((String)(poster = element.attr("poster")))) continue;
                poster = this.buildImgCover(poster);
                String size = element.attr("size") == null ? "0" : element.attr("size");
                String duration = element.attr("duration") == null ? "0" : element.attr("duration");
                Element videoImgElement = document.createElement("img");
                videoImgElement.attr("src", poster);
                videoImgElement.attr("poster", poster);
                videoImgElement.attr("size", size);
                videoImgElement.attr("duration", duration);
                String url = "";
                String posterUrl = "";
                try {
                    url = URLEncoder.encode(src, "UTF-8");
                    posterUrl = URLEncoder.encode(poster, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    log.error("url\u7f16\u7801\u51fa\u9519\uff1a[{}]", (Object)e.getMessage());
                }
                Element divElement = document.createElement("div");
                divElement.addClass("videoCopy");
                if (this.appVersionIntegrationService.needProcessContentVideoPoster(basicParam)) {
                    divElement.attr("onclick", "window.location.href='tt://playVideo?url=" + url + "&poster=" + posterUrl + "'");
                } else {
                    divElement.attr("onclick", "window.location.href='tt://playVideo?url=" + url + "'");
                }
                Element waterMarkElement = document.createElement("img");
                waterMarkElement.attr("class", "videoBubble");
                waterMarkElement.attr("src", "https://m.wstong.com/icon_video_play_new.png");
                waterMarkElement.attr("alt", "");
                divElement.appendChild((Node)waterMarkElement);
                divElement.appendChild((Node)videoImgElement);
                element.replaceWith((Node)divElement);
            }
        }
    }

    private String appletAdapter(String content) {
        return StringUtils.replace((String)content, (String)"\u4f60\u5c06\u83b7\u5f9710\u6735\u5c0f\u7ea2\u82b1", (String)"\u6700\u591a\u83b7\u5f97300\u6735\u5c0f\u7ea2\u82b1");
    }

    private void addWatermark(Document document) {
        Elements elements = document.select("img");
        if (null != elements) {
            for (Element element : elements) {
                String extend;
                String src = element.attr("src");
                if (StringUtils.isBlank((String)src) && StringUtils.isBlank((String)(src = element.attr("data-src")))) continue;
                String url = src;
                int lastIndex = src.lastIndexOf("?");
                if (-1 != lastIndex) {
                    url = src.substring(0, lastIndex);
                }
                url = "gif".equalsIgnoreCase(extend = FileUtils.getFilextension((String)url)) ? url + "?x-oss-process=style/mcompress" : url + "?x-oss-process=style/wcompress";
                element.attr("src", url);
                element.attr("class", "preview");
            }
        }
    }

    @Override
    public String deleteNbspFromVideo(Document document) {
        Elements elements = document.select("video");
        if (!elements.isEmpty()) {
            for (Element element : elements) {
                Element parent = element.parent();
                parent.html(parent.html().replace("&nbsp;", ""));
            }
        }
        return document.body().html();
    }

    @Override
    public String buildVideoCover(String imgUrl) {
        int lastIndex = imgUrl.lastIndexOf("?");
        if (-1 != lastIndex) {
            imgUrl = imgUrl.substring(0, lastIndex);
        }
        imgUrl = imgUrl + "?x-oss-process=style/vthumbnail";
        return imgUrl;
    }

    @Override
    public String buildImgCover(String imgUrl) {
        int lastIndex = imgUrl.lastIndexOf("?");
        if (-1 != lastIndex) {
            imgUrl = imgUrl.substring(0, lastIndex);
        }
        imgUrl = imgUrl + "?x-oss-process=style/thumbnail";
        return imgUrl;
    }
}

