/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.news.config.UserProperties;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.dto.BaseForumPostDTO;
import com.bxm.localnews.news.dto.ForumPostBriefInfoDto;
import com.bxm.localnews.news.dto.ImgDTO;
import com.bxm.localnews.news.enums.PostTypeEnum;
import com.bxm.localnews.news.factory.impl.ExtendFactory;
import com.bxm.localnews.news.service.ForumPostFacadeService;
import com.bxm.localnews.news.service.ForumPostService;
import com.bxm.localnews.news.service.ForumPostStatisticService;
import com.bxm.localnews.news.util.OssTransCodeUtils;
import com.bxm.localnews.news.vo.ForumBasicVo;
import com.bxm.localnews.news.vo.ForumPostClickCountVo;
import com.bxm.localnews.news.vo.ForumPostVo;
import com.bxm.localnews.news.vo.PostImgVo;
import com.bxm.localnews.news.vo.TranscodeMap;
import com.bxm.localnews.news.vo.UserImgVo;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ForumPostFacadeServiceImpl
implements ForumPostFacadeService {
    private final ForumPostService forumPostService;
    private final ForumPostStatisticService forumPostStatisticService;
    private final ForumPostMapper forumPostMapper;
    private final RedisSetAdapter redisSetAdapter;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final UserProperties userProperties;
    private final OssTransCodeUtils ossTransCodeUtils;

    @Autowired
    public ForumPostFacadeServiceImpl(ForumPostService forumPostService, ForumPostStatisticService forumPostStatisticService, ForumPostMapper forumPostMapper, RedisSetAdapter redisSetAdapter, RedisHashMapAdapter redisHashMapAdapter, UserProperties userProperties, OssTransCodeUtils ossTransCodeUtils) {
        this.forumPostService = forumPostService;
        this.forumPostStatisticService = forumPostStatisticService;
        this.forumPostMapper = forumPostMapper;
        this.redisSetAdapter = redisSetAdapter;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.userProperties = userProperties;
        this.ossTransCodeUtils = ossTransCodeUtils;
    }

    @Override
    public ForumPostBriefInfoDto getBriefInfo(Long postId, Long userId, String areaCode, String ip) {
        ForumPostVo forumPostVo = this.forumPostService.getForumPostDetail(postId, userId, null, new BasicParam(), areaCode, ip);
        ForumPostBriefInfoDto briefInfoDto = new ForumPostBriefInfoDto();
        if (null != forumPostVo) {
            PostImgVo imgInfo;
            String title = forumPostVo.getTitle();
            if (StringUtils.isBlank((CharSequence)title) || PostTypeEnum.NOTE.getCode() == forumPostVo.getPostType().byteValue()) {
                title = StringUtils.substring((String)forumPostVo.getTextField(), (int)0, (int)50);
            }
            if (null != (imgInfo = forumPostVo.getShareImg())) {
                briefInfoDto.setConvertImgUrl(imgInfo.getImgUrl());
            }
            briefInfoDto.setHasVote(Boolean.valueOf(forumPostVo.getVoteDetailDTO() != null));
            briefInfoDto.setId(postId);
            briefInfoDto.setTitle(title);
        }
        return briefInfoDto;
    }

    @Override
    public Integer getPublishPostNum(Long userId) {
        return this.forumPostMapper.selectPublishPostNumByUserId(userId);
    }

    @Override
    public List<ForumPostClickCountVo> getRecentPosts(Integer clickCountLimit) {
        return this.forumPostMapper.getRecentPosts(clickCountLimit, DateUtils.addField((Date)new Date(), (int)5, (int)-1));
    }

    @Override
    public void batchAddClick(List<ForumPostClickCountVo> forumPostClickList) {
        if (CollectionUtils.isNotEmpty(forumPostClickList)) {
            MybatisBatchBuilder.create(ForumPostMapper.class, forumPostClickList).run(ForumPostMapper::batchAddClick);
        }
    }

    @Override
    @Async
    public void transcodePostVideo(Long id, List<PostImgVo> postImgList) {
        ForumPostVo forumPostVo;
        if (CollectionUtils.isEmpty(postImgList) && (forumPostVo = this.forumPostMapper.selectByPrimaryKey(id)) != null) {
            postImgList = forumPostVo.getPostImgList();
        }
        if (CollectionUtils.isNotEmpty(postImgList)) {
            postImgList.forEach(e -> {
                if ("VIDEO".equals(e.getType())) {
                    this.ossTransCodeUtils.transCodeByOriginUrl(e.getVideoUrl(), id);
                }
            });
        }
    }

    @Override
    public void batchUpdatePostVideo(List<TranscodeMap> transcodeMapList) {
        if (CollectionUtils.isNotEmpty(transcodeMapList)) {
            MybatisBatchBuilder.create(ForumPostMapper.class, transcodeMapList).run(ForumPostMapper::batchUpdatePostVideo);
        }
    }

    @Override
    public BaseForumPostDTO getForumPostByUserId(Long userId, Long targetUserId) {
        boolean flag;
        KeyGenerator recentKey = RedisConfig.RECENT_DEVELOPMENTS.copy().appendKey((Object)String.valueOf(userId));
        ForumPostVo forumPostVo = this.forumPostMapper.selectPostByUserIdAndWeek(targetUserId);
        BaseForumPostDTO result = null;
        boolean bl = flag = Objects.nonNull(forumPostVo) && this.redisSetAdapter.exists(recentKey, (Object)forumPostVo.getId()) == false;
        if (flag) {
            List<PostImgVo> coverList = this.forumPostStatisticService.getCoverFromPost(forumPostVo.getCoverList(), forumPostVo.getPostImgList(), forumPostVo.getCoverSelect());
            result = BaseForumPostDTO.builder().id(forumPostVo.getId()).imgUrl(CollectionUtils.isEmpty(coverList) ? null : coverList.get(0).getImgUrl()).textField(forumPostVo.getTextField()).title(ExtendFactory.getTitle((String)forumPostVo.getTitle(), (String)forumPostVo.getTextField())).publishTime(forumPostVo.getPublishTime()).build();
            this.redisSetAdapter.add(recentKey, new Object[]{forumPostVo.getId()});
            this.redisSetAdapter.expire(recentKey, 604800L);
        }
        return result;
    }

    @Override
    public List<UserImgVo> batchGetUserImg(List<Long> userIdList, Long currentUserId) {
        List forumPostVoList;
        UserImgVo userImgVo;
        ArrayList<UserImgVo> userImgVoList = new ArrayList<UserImgVo>();
        if (CollectionUtils.isEmpty(userIdList)) {
            return userImgVoList;
        }
        boolean hasCurrent = false;
        if (currentUserId != null && userIdList.contains(currentUserId)) {
            userIdList.remove(currentUserId);
            hasCurrent = true;
        }
        if (CollectionUtils.isNotEmpty(userIdList)) {
            Set userIds = userIdList.stream().map(Object::toString).collect(Collectors.toSet());
            List userForumImgCache = this.redisHashMapAdapter.multiGet(RedisConfig.USER_FORUM_IMG, userIds, String.class);
            if (CollectionUtils.isNotEmpty((Collection)userForumImgCache)) {
                userForumImgCache.forEach(userCache -> {
                    UserImgVo userImgVo = (UserImgVo)JSON.parseObject((String)userCache, UserImgVo.class);
                    if (null != userImgVo) {
                        userIdList.remove(userImgVo.getUserId());
                        userImgVoList.add(userImgVo);
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(userIdList)) {
                userImgVoList.addAll(this.batchLoadUserImgVoToRedis(userIdList));
            }
        }
        if (hasCurrent && (userImgVo = this.convertPostToUserImg(forumPostVoList = this.forumPostMapper.batchGetUserPosts(Collections.singletonList(currentUserId), this.userProperties.getAdvertTopicId(), Integer.valueOf(1)), currentUserId)) != null) {
            userImgVoList.add(userImgVo);
        }
        return userImgVoList;
    }

    @Override
    public void cacheUserPostImg(Date startTime) {
        List userIdList = this.forumPostMapper.getUpdatedUser(startTime);
        this.batchLoadUserImgVoToRedis(userIdList);
    }

    private List<UserImgVo> batchLoadUserImgVoToRedis(List<Long> userIdList) {
        ArrayList<UserImgVo> userImgVoList = new ArrayList<UserImgVo>();
        if (CollectionUtils.isEmpty(userIdList)) {
            return userImgVoList;
        }
        List forumPostVoList = this.forumPostMapper.batchGetUserPosts(userIdList, this.userProperties.getAdvertTopicId(), Integer.valueOf(0));
        if (CollectionUtils.isEmpty((Collection)forumPostVoList)) {
            return userImgVoList;
        }
        Map<Long, List<ForumPostVo>> userForumPostMap = forumPostVoList.stream().collect(Collectors.groupingBy(ForumBasicVo::getUserId));
        HashMap userImgVoMap = new HashMap();
        userIdList.forEach(userId -> {
            UserImgVo userImgVo = this.convertPostToUserImg((List)userForumPostMap.get(userId), (Long)userId);
            userImgVoMap.put(userId.toString(), JSON.toJSONString((Object)userImgVo));
            if (null != userImgVo) {
                userImgVoList.add(userImgVo);
            }
        });
        if (userImgVoMap.size() > 0) {
            this.redisHashMapAdapter.putAll(RedisConfig.USER_FORUM_IMG, userImgVoMap);
        }
        return userImgVoList;
    }

    private UserImgVo convertPostToUserImg(List<ForumPostVo> forumPostVos, Long userId) {
        if (CollectionUtils.isEmpty(forumPostVos)) {
            return null;
        }
        int size = 0;
        ArrayList<ImgDTO> imgDtoList = new ArrayList<ImgDTO>();
        for (ForumPostVo forumPostVo : forumPostVos) {
            List postImgVoList = forumPostVo.getPostImgList();
            if (CollectionUtils.isNotEmpty((Collection)postImgVoList)) {
                for (PostImgVo postImgVo : postImgVoList) {
                    if (!"IMG".equals(postImgVo.getType())) continue;
                    ImgDTO imgDto = new ImgDTO();
                    imgDto.setId(forumPostVo.getId());
                    imgDto.setCategory("POST");
                    imgDto.setType(postImgVo.getType());
                    imgDto.setImgUrl(postImgVo.getImgUrl());
                    imgDtoList.add(imgDto);
                    if (++size < 4) continue;
                    break;
                }
            }
            if (size < 4) continue;
            break;
        }
        UserImgVo userImgVo = new UserImgVo();
        userImgVo.setUserId(userId);
        userImgVo.setImgDtoList(imgDtoList);
        return userImgVo;
    }
}

