/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.dto.MixRecommendDTO;
import com.bxm.localnews.integration.BizLogIntegrationService;
import com.bxm.localnews.integration.LocationIntegrationService;
import com.bxm.localnews.integration.NewsRecommendIntegrationService;
import com.bxm.localnews.integration.UserAccountIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.integration.UserRecommendSourceIntegrationService;
import com.bxm.localnews.integration.VoteIntegrationService;
import com.bxm.localnews.mq.common.constant.UserRecommendEnum;
import com.bxm.localnews.mq.common.model.dto.UserRecommendDTO;
import com.bxm.localnews.news.config.BizConfigProperties;
import com.bxm.localnews.news.config.ForumProperties;
import com.bxm.localnews.news.config.NewsProperties;
import com.bxm.localnews.news.config.UserProperties;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.convert.impl.ForumBasicConvert;
import com.bxm.localnews.news.convert.impl.ForumParamPageConvert;
import com.bxm.localnews.news.convert.impl.ForumPostConvert;
import com.bxm.localnews.news.convert.impl.ForumPostCreateConvert;
import com.bxm.localnews.news.domain.ForumPostInformMapper;
import com.bxm.localnews.news.domain.ForumPostLikeMapper;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.domain.ForumTopicMapper;
import com.bxm.localnews.news.domain.MixedRecommendPoolMapper;
import com.bxm.localnews.news.domain.NewsCollectMapper;
import com.bxm.localnews.news.dto.ForumPostCreateDTO;
import com.bxm.localnews.news.dto.ForumPostLikeDTO;
import com.bxm.localnews.news.dto.NewsCompleTaskDTO;
import com.bxm.localnews.news.dto.PostLikeDto;
import com.bxm.localnews.news.dto.RelationDTO;
import com.bxm.localnews.news.enums.PostTypeEnum;
import com.bxm.localnews.news.enums.UrlCategoryEnum;
import com.bxm.localnews.news.enums.UrlPositionEnum;
import com.bxm.localnews.news.enums.UrlTypeEnum;
import com.bxm.localnews.news.factory.IUrlFactory;
import com.bxm.localnews.news.factory.impl.ExtendFactory;
import com.bxm.localnews.news.param.ForumPostCollectParam;
import com.bxm.localnews.news.param.ForumPostInformParam;
import com.bxm.localnews.news.param.ForumPostListQueryParam;
import com.bxm.localnews.news.param.ForumPostListUserQueryParam;
import com.bxm.localnews.news.param.HomePagePostParam;
import com.bxm.localnews.news.service.ForumPostFacadeService;
import com.bxm.localnews.news.service.ForumPostService;
import com.bxm.localnews.news.service.ForumPostStatisticService;
import com.bxm.localnews.news.service.ForumTopicService;
import com.bxm.localnews.news.service.NewsCollectService;
import com.bxm.localnews.news.service.NewsReadRewardService;
import com.bxm.localnews.news.service.RecommendService;
import com.bxm.localnews.news.service.SensitiveWordService;
import com.bxm.localnews.news.util.JudgeUtil;
import com.bxm.localnews.news.util.ListUtil;
import com.bxm.localnews.news.util.VersionUtils;
import com.bxm.localnews.news.vo.ForumBasicVo;
import com.bxm.localnews.news.vo.ForumPlugin;
import com.bxm.localnews.news.vo.ForumPostInform;
import com.bxm.localnews.news.vo.ForumPostLike;
import com.bxm.localnews.news.vo.ForumPostVo;
import com.bxm.localnews.news.vo.MixedRecommendPool;
import com.bxm.localnews.news.vo.News4Client;
import com.bxm.localnews.news.vo.NewsCollect;
import com.bxm.localnews.news.vo.PostImgVo;
import com.bxm.localnews.news.vo.PostTopicVO;
import com.bxm.localnews.news.vo.TopicVo;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.localnews.param.AccountGoldParam;
import com.bxm.localnews.param.ForumParam;
import com.bxm.localnews.param.VotePinParam;
import com.bxm.newidea.component.emoji.EmojiCodeParser;
import com.bxm.newidea.component.redis.HyperLogLogAdapter;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageParam;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class ForumPostServiceImpl
extends BaseService
implements ForumPostService {
    @Resource
    private ForumPostInformMapper forumPostInformMapper;
    @Resource
    private ForumPostLikeMapper forumPostLikeMapper;
    @Resource
    private ForumPostMapper forumPostMapper;
    @Resource
    private ForumTopicMapper forumTopicMapper;
    @Resource
    private MixedRecommendPoolMapper mixedRecommendPoolMapper;
    @Resource
    private NewsCollectMapper newsCollectMapper;
    @Resource
    private UserIntegrationService userIntegrationService;
    @Resource
    private NewsRecommendIntegrationService newsRecommendIntegrationService;
    @Resource
    private BizLogIntegrationService bizLogIntegrationService;
    @Resource
    private VoteIntegrationService voteIntegrationService;
    @Resource
    private UserRecommendSourceIntegrationService userRecommendSourceIntegrationService;
    @Resource
    private UserAccountIntegrationService userAccountIntegrationService;
    @Resource
    private LocationIntegrationService locationIntegrationService;
    @Resource
    private ForumBasicConvert forumBasicConvert;
    @Resource
    private ForumParamPageConvert forumParamPageConvert;
    @Resource
    private ForumPostCreateConvert forumPostCreateConvert;
    @Resource
    private NewsReadRewardService newsReadRewardService;
    @Resource
    private NewsCollectService collectService;
    @Resource
    private ForumTopicService forumTopicService;
    @Resource
    private ForumPostStatisticService forumPostStatisticService;
    @Resource
    private SensitiveWordService sensitiveWordService;
    @Resource
    private IUrlFactory iUrlFactory;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;
    @Resource
    private RedisStringAdapter redisStringAdapter;
    @Resource
    private UserProperties userProperties;
    @Resource
    private NewsProperties newsProperties;
    @Resource
    private ForumProperties forumProperties;
    @Resource
    private BizConfigProperties bizConfigProperties;
    @Resource
    private HyperLogLogAdapter hyperLogLogAdapter;

    @Override
    public PageWarper<ForumPostVo> listForumPost(ForumPostListQueryParam param, BasicParam basicParam) {
        List postIdList;
        this.logger.debug("\u83b7\u53d6\u63a8\u8350\u6d41,param:{}", JSONObject.toJSON((Object)param));
        PageWarper forumPostPage = new PageWarper();
        if (5 == basicParam.getPlatform() && this.bizConfigProperties.getAppletReviewEnable().booleanValue() && 3 == param.getType()) {
            postIdList = this.forumPostMapper.listPostRecommend(param);
        } else {
            ForumParam forumParam = (ForumParam)this.forumParamPageConvert.convert(param);
            this.fixErrorParamWithIOS(forumParam, basicParam);
            Objects.requireNonNull(forumParam).setPlatform(Integer.valueOf(basicParam.getPlatform()));
            postIdList = this.newsRecommendIntegrationService.recommendList(forumParam);
        }
        if (CollectionUtils.isNotEmpty((Collection)postIdList)) {
            List postList = this.forumPostMapper.listPostByIds(postIdList);
            forumPostPage.setList(postList);
            forumPostPage.setPageNum(param.getPageNum().intValue());
            forumPostPage.setPageSize(param.getPageSize().intValue());
            this.fillExtInfo(forumPostPage.getList(), param.getUserId(), param.getAreaCode(), false, (byte)0);
            if (3 == param.getType() && postIdList.size() >= 3 && VersionUtils.isHighVersion((String)basicParam.getCurVer(), (String)"2.5.0") > 0) {
                this.addRecommendTopic(param, (PageWarper<ForumPostVo>)forumPostPage, postList);
            }
        }
        if (CollectionUtils.isEmpty((Collection)postIdList) || postIdList.size() < param.getPageSize()) {
            forumPostPage.setIsLastPage(true);
            forumPostPage.setHasNextPage(false);
        } else {
            forumPostPage.setHasNextPage(true);
        }
        this.logger.debug("[listForumPost]\u62c9\u53d6\u5e16\u5b50\u5217\u8868\u5b8c\u6bd5");
        return forumPostPage;
    }

    @Override
    public PageWarper<ForumPostVo> listForumPostByUser(ForumPostListUserQueryParam param) {
        PageWarper forumPostWarper = new PageWarper();
        if (null == param || null == param.getType()) {
            return null;
        }
        if (1 == param.getType()) {
            forumPostWarper = new PageWarper(this.forumPostMapper.listPostByIdsInUser(param));
            List forumPostVoList = forumPostWarper.getList();
            if (CollectionUtils.isNotEmpty((Collection)forumPostVoList)) {
                this.fillExtInfo(forumPostVoList, param.getUserId(), null, false, (byte)0);
            }
        } else if (2 == param.getType()) {
            forumPostWarper = new PageWarper(this.forumPostMapper.getCollectPostList(param));
            List forumPostVoList = forumPostWarper.getList();
            if (CollectionUtils.isNotEmpty((Collection)forumPostVoList)) {
                this.fillExtInfo(forumPostVoList, param.getUserId(), null, true, (byte)0);
            }
        } else if (3 == param.getType()) {
            HomePagePostParam postParam = new HomePagePostParam();
            postParam.setTargetUserId(param.getUserId());
            postParam.setUserId(param.getUserId());
            BeanUtils.copyProperties((Object)param, (Object)postParam);
            forumPostWarper = new PageWarper(this.forumPostMapper.listHomePagePostList(postParam));
            List forumPostVoList = forumPostWarper.getList();
            if (CollectionUtils.isNotEmpty((Collection)forumPostVoList)) {
                this.fillExtInfo(forumPostVoList, param.getUserId(), null, false, (byte)2);
            }
        }
        return forumPostWarper;
    }

    @Override
    public ForumPostVo getForumPostDetail(Long id, Long userId, Long shareUserId, BasicParam basicParam, String areaCode, String ip) {
        ForumPostVo forumPostVo = this.forumPostMapper.selectByPrimaryKey(id);
        if (null != forumPostVo) {
            boolean isDeleted;
            KeyGenerator keyGenerator;
            Long recordNum;
            if (PlatformEnum.WEB.getCode() == basicParam.getPlatform() && 2 == forumPostVo.getStatus() && null != (recordNum = this.hyperLogLogAdapter.size(new KeyGenerator[]{keyGenerator = RedisConfig.FORUM_RECORD_FROM_H5.copy().appendKey((Object)forumPostVo.getId())})) && recordNum >= (long)this.forumProperties.getH5LimitNum().intValue()) {
                ForumPostVo emptyForumPostVo = new ForumPostVo();
                emptyForumPostVo.setStatus(Integer.valueOf(100));
                emptyForumPostVo.setId(id);
                return emptyForumPostVo;
            }
            boolean isNotClient = PlatformEnum.ANDROID.getCode() != basicParam.getPlatform() && PlatformEnum.IOS.getCode() != basicParam.getPlatform();
            boolean bl = isDeleted = null != forumPostVo.getStatus() && (3 == forumPostVo.getStatus() || 4 == forumPostVo.getStatus());
            if (isNotClient && isDeleted) {
                return null;
            }
            LocationDTO location = StringUtils.isNotEmpty((CharSequence)areaCode) ? this.locationIntegrationService.getLocationByGeocode(areaCode) : null;
            this.completePostInfo(forumPostVo, userId, location);
            this.forumPostStatisticService.generateForumPostContent(forumPostVo, basicParam, ip, userId, areaCode);
            this.forumPostStatisticService.judgeEnablePlaceholder(forumPostVo, location);
            this.setIsCashAndCashRewardIsZero(forumPostVo);
            ((ForumPostStatisticService)SpringContextHolder.getBean(ForumPostStatisticService.class)).doAsyncReadPost(userId, id, shareUserId, basicParam.getPlatform(), forumPostVo, ip);
        }
        return forumPostVo;
    }

    @Override
    public Message doCreateOrUpdatePost(ForumBasicVo forumBasicVo, BasicParam basicParam, boolean isDirectlyPassed) {
        this.logger.debug("\u7528\u6237\u53d1\u5e16\u6216\u8005\u7f16\u8f91\uff0c\u53c2\u6570:[{}]", (Object)JSONObject.toJSONString((Object)forumBasicVo));
        if (this.sensitiveWordService.contains(forumBasicVo.getTextField())) {
            return Message.build((boolean)false, (String)"\u53d1\u5e03\u5185\u5bb9\u5305\u542b\u654f\u611f\u8bcd");
        }
        Message message = Message.build((boolean)true);
        ForumPostVo forumPostVo = this.forumBasicConvert.convert(forumBasicVo);
        if (isDirectlyPassed) {
            forumPostVo.setStatus(Integer.valueOf(1));
        }
        NewsCompleTaskDTO newsCompleTaskDTO = new NewsCompleTaskDTO();
        if (null == forumPostVo.getId()) {
            forumPostVo.setIsFirstUserPost(Byte.valueOf((byte)(this.forumPostMapper.selectPublishPostNumByUserId(forumBasicVo.getUserId()) == 0 ? 1 : 0)));
            int i = this.saveForumPost(forumPostVo);
            if (i > 0) {
                this.forumTopicService.updateTopic(forumPostVo);
                newsCompleTaskDTO = this.afterCreate(basicParam, forumPostVo);
            }
        } else {
            MixedRecommendPool mixedRecommendPool = this.mixedRecommendPoolMapper.selectByPrimaryKey(forumPostVo.getId());
            if (Objects.nonNull(mixedRecommendPool)) {
                return Message.build((boolean)false, (String)"\u60a8\u7684\u5185\u5bb9\u5df2\u88ab\u63a8\u8350\u5230\u5934\u6761\uff0c\u5982\u9700\u4fee\u6539\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
            ForumPostVo exitsPost = this.forumPostMapper.selectByPrimaryKey(forumPostVo.getId());
            if (exitsPost.getStatus() != 2) {
                forumPostVo.setIsUserUpdate(Byte.valueOf((byte)1));
            }
            this.mixedRecommendPoolMapper.deleteMixRecommandPoolById(forumPostVo.getId());
            forumPostVo.setIsRecommend(Byte.valueOf((byte)0));
            forumPostVo.setModifyTime(new Date());
            this.forumPostMapper.updateByPrimaryKeySelective(forumPostVo);
            this.forumTopicService.updateTopic(forumPostVo);
        }
        ((ForumPostFacadeService)SpringContextHolder.getBean(ForumPostFacadeService.class)).transcodePostVideo(forumPostVo.getId(), forumPostVo.getPostImgList());
        ForumPostCreateDTO forumPostCreateDTO = this.forumPostCreateConvert.generateForumPost(forumPostVo, newsCompleTaskDTO, forumBasicVo.getUserId());
        message.addParam("completeTaskAndPush", (Object)forumPostCreateDTO);
        UserRecommendDTO userRecommendDTO = new UserRecommendDTO();
        userRecommendDTO.setUserId(forumBasicVo.getUserId());
        userRecommendDTO.setRecommendType(UserRecommendEnum.USER_BEHAVIOR.getTag());
        userRecommendDTO.setLastPostTime(new Date());
        this.userRecommendSourceIntegrationService.pushUserRecommendInfo(userRecommendDTO);
        return message;
    }

    @Override
    public int saveForumPost(ForumPostVo forumPostVo) {
        forumPostVo.setId(this.getPostId());
        UserBean user = this.userIntegrationService.selectUserFromCache(forumPostVo.getUserId());
        if (null != user) {
            if (StringUtils.isBlank((CharSequence)user.getHeadImg()) || StringUtils.isBlank((CharSequence)user.getNickname())) {
                this.logger.info("\u5e16\u5b50\u4fdd\u5b58\u7528\u6237\u5934\u50cf\u6216\u6635\u79f0\u4e3a\u7a7a,userInfo={}", (Object)JSON.toJSONString((Object)user));
            }
            forumPostVo.setUserImg(user.getHeadImg());
            forumPostVo.setUserName(user.getNickname());
        }
        Date currentTime = new Date();
        forumPostVo.setCreateTime(currentTime);
        forumPostVo.setDisplayDateTime(currentTime);
        forumPostVo.setPublishTime(currentTime);
        forumPostVo.setModifyTime(currentTime);
        return this.forumPostMapper.insertSelective(forumPostVo);
    }

    @Override
    public Message deleteForumPost(Long id) {
        this.logger.debug("\u5f00\u59cb\u5220\u9664\u5e16\u5b50\uff0cid\uff1a" + id);
        ForumPostVo forumPostVo = this.forumPostMapper.selectByPrimaryKey(id);
        String result = this.checkPostInfo(forumPostVo);
        if (StringUtils.isNotBlank((CharSequence)result)) {
            return Message.build((boolean)Boolean.FALSE, (String)result);
        }
        forumPostVo.setModifyTime(new Date());
        forumPostVo.setStatus(Integer.valueOf(4));
        this.forumPostMapper.updateByPrimaryKeySelective(forumPostVo);
        this.mixedRecommendPoolMapper.deleteMixRecommandPoolById(id);
        this.logger.debug("\u5f00\u59cb\u56de\u6536\u91d1\u5e01\uff0cid\uff1a" + id);
        Integer goldNum = this.userAccountIntegrationService.countGoldByPostId(id, forumPostVo.getUserId());
        if (null != goldNum && goldNum > 0) {
            String content = "\u5220\u9664\u3010" + ExtendFactory.getPostContent((String)forumPostVo.getTitle(), (String)forumPostVo.getTextField()) + "\u3011";
            this.userAccountIntegrationService.addGold(AccountGoldParam.buildPostDeleteParam((Long)forumPostVo.getUserId(), (int)(-goldNum.intValue()), (Long)id, (String)content));
        }
        this.userIntegrationService.addPostReplyNum(forumPostVo.getUserId(), Integer.valueOf(2));
        this.logger.debug("\u5e16\u5b50\u5220\u9664\u5b8c\u6210\uff0cid\uff1a" + id);
        return Message.build((boolean)Boolean.TRUE);
    }

    @Override
    public void fillExtInfo(List<ForumPostVo> forumPostList, Long userId, String areaCode, boolean isFillTitle, byte isInHome) {
        ArrayList postCollectIdList;
        LocationDTO location = StringUtils.isNotEmpty((CharSequence)areaCode) ? this.locationIntegrationService.getLocationByGeocode(areaCode) : null;
        List<Long> postIds = forumPostList.stream().map(ForumBasicVo::getId).collect(Collectors.toList());
        List<PostTopicVO> postTopicVoList = this.forumTopicService.listTopicByPostIds(postIds, userId);
        List postLikeIdList = null != userId ? this.forumPostLikeMapper.listUserPostLike(userId) : new ArrayList();
        List list = postCollectIdList = null != userId ? this.newsCollectMapper.selectByIds(userId, Byte.valueOf((byte)3)) : new ArrayList();
        if (!CollectionUtils.isEmpty(forumPostList)) {
            forumPostList.parallelStream().forEach(e -> {
                this.completePostInfo((ForumPostVo)e, userId, location, postTopicVoList, postLikeIdList, postCollectIdList, isFillTitle, isInHome);
                this.forumPostStatisticService.judgeEnablePlaceholder((ForumPostVo)e, location);
                this.setIsCashAndCashRewardIsZero((ForumPostVo)e);
            });
        }
    }

    @Override
    public NewsCompleTaskDTO doShareForumPost(Long userId, Long postId, String areaCode, Byte type, Integer platform) {
        this.logger.debug("\u7528\u6237\u5206\u4eab\u5e16\u5b50\uff0c\u53c2\u6570->postId:{},userId:{},type:{},platform:{}", new Object[]{postId, userId, type, platform});
        this.bizLogIntegrationService.shareForumSuccessed(userId, postId, areaCode, platform);
        return this.newsReadRewardService.saveShareForums(postId, userId, type, areaCode);
    }

    @Override
    public void doLikeForumPost(Long userId, Long postId, int type, String areaCode, Integer platform) {
        this.logger.debug("[\u65e7\u7248]\u7528\u6237\u70b9\u8d5e\u5e16\u5b50\uff0c\u53c2\u6570->postId:{},userId:{},type:{},platform:{}", new Object[]{postId, userId, type, platform});
        ForumPostLike postLike = this.forumPostLikeMapper.selectByUserIdAndPostId(userId, postId);
        UserBean userBean = this.userIntegrationService.selectUserFromCache(userId);
        this.generateForumPostLike(postLike, type, postId, userId, userBean);
        this.forumPostStatisticService.doUpdateForumInfo(type, postId);
        ((ForumPostStatisticService)SpringContextHolder.getBean(ForumPostStatisticService.class)).doAsyncLikePost(userId, postId, type, areaCode, (byte)1, platform);
    }

    @Override
    public Message doInformForumPost(ForumPostInformParam param) {
        ForumPostInform forumPostInformParam = new ForumPostInform();
        forumPostInformParam.setPostId(param.getPostId());
        forumPostInformParam.setUserId(param.getUserId());
        List informList = this.forumPostInformMapper.selectByModel(forumPostInformParam);
        if (CollectionUtils.isNotEmpty((Collection)informList)) {
            return Message.build((boolean)false, (String)"\u60a8\u5df2\u4e3e\u62a5\u8fc7");
        }
        ForumPostInform forumPostInform = new ForumPostInform();
        BeanUtils.copyProperties((Object)param, (Object)forumPostInform);
        forumPostInform.setId(this.nextSequence());
        this.forumPostInformMapper.insertSelective(forumPostInform);
        return Message.build((boolean)true);
    }

    @Override
    public List<News4Client> listPostDetailRecommend(Long postId, Long userId, Integer size, String areaCode, Integer platform) {
        ForumParam forumParam = this.generateForumParam(size, postId, userId, areaCode, platform);
        List idList = this.newsRecommendIntegrationService.recommendList(forumParam);
        this.logger.debug("[listPostDetailRecommend]\u5e16\u5b50\u8be6\u60c5\u63a8\u8350\uff1a{}", (Object)JSONObject.toJSONString((Object)idList));
        List<MixRecommendDTO> mixRecommendList = ForumPostConvert.convertIds2MixRecommendDTO(idList);
        List<News4Client> news4ClientList = ((RecommendService)SpringContextHolder.getBean(RecommendService.class)).listNews4Client(mixRecommendList, userId, areaCode, true);
        this.logger.debug("[listPostDetailRecommend]\u5e16\u5b50\u8be6\u60c5\u63a8\u8350\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(news4ClientList));
        return news4ClientList;
    }

    @Override
    public PostLikeDto doLikeForumPost(Long postId, Long userId, String areaCode, Integer platform) {
        ForumPostLike postLike;
        PostLikeDto postLikeDto = new PostLikeDto();
        UserBean userBean = this.userIntegrationService.selectUserFromCache(userId);
        if (StringUtils.isBlank((CharSequence)userBean.getHeadImg()) || StringUtils.isBlank((CharSequence)userBean.getNickname())) {
            this.logger.info("\u5e16\u5b50\u70b9\u8d5e\u7528\u6237\u5934\u50cf\u6216\u6635\u79f0\u4e3a\u7a7a,userInfo={}", (Object)JSON.toJSONString((Object)userBean));
        }
        if (Objects.isNull(postLike = this.forumPostLikeMapper.selectByUserIdAndPostId(userId, postId)) || postLike.getType() == 0) {
            boolean flag;
            long id = this.generateForumPostLike(postLike, 1, postId, userId, userBean);
            this.forumPostStatisticService.doUpdateForumInfo(1, postId);
            ForumPostVo postVo = this.forumPostMapper.selectByPrimaryKey(postId);
            boolean bl = flag = Objects.nonNull(userId) && Objects.nonNull(postVo.getUserId()) && userId.equals(postVo.getUserId());
            if (flag) {
                postLikeDto.setCode(Integer.valueOf(1));
                postLikeDto.setCopyWriter(null);
                postLikeDto.setShowFlower(Integer.valueOf(0));
            } else {
                postLikeDto = this.calculateFlower(postVo, userId, id, areaCode, platform);
            }
            this.userIntegrationService.updateUserLikeNumByUserId(postVo.getUserId());
        } else {
            postLikeDto = null;
        }
        return postLikeDto;
    }

    @Override
    public List<ForumPostLikeDTO> getPostLikeDetail(Long id, Long userId, String devcId) {
        ArrayList result = Lists.newArrayList();
        List forumPostLikes = this.forumPostLikeMapper.selectPostById(id);
        forumPostLikes.forEach(e -> {
            ForumPostLikeDTO postLikeDTO = new ForumPostLikeDTO();
            BeanUtils.copyProperties((Object)e, (Object)postLikeDTO);
            if (StringUtils.isBlank((CharSequence)postLikeDTO.getHeadImg())) {
                postLikeDTO.setHeadImg(this.userProperties.getDefaultHeadImgUrl());
            }
            result.add(postLikeDTO);
        });
        return result;
    }

    @Override
    public Boolean relaceSoftbankEmoji() {
        PageParam pageParam = new PageParam();
        pageParam.setPageSize(Integer.valueOf(1000));
        for (int i = 1; i < 100; ++i) {
            pageParam.setPageNum(Integer.valueOf(i));
            PageWarper forumPostVoPage = new PageWarper(this.forumPostMapper.selectAllPosts(pageParam));
            if (CollectionUtils.isEmpty((Collection)forumPostVoPage.getList())) break;
            ArrayList<ForumPostVo> updateList = new ArrayList<ForumPostVo>();
            for (ForumPostVo forumPostVo : forumPostVoPage.getList()) {
                boolean changed = false;
                if (EmojiCodeParser.hasSoftbankEmoji((String)forumPostVo.getContent())) {
                    changed = true;
                    forumPostVo.setContent(EmojiCodeParser.replaceSoftbankEmoji((String)forumPostVo.getContent()));
                }
                if (EmojiCodeParser.hasSoftbankEmoji((String)forumPostVo.getTextField())) {
                    changed = true;
                    forumPostVo.setTextField(EmojiCodeParser.replaceSoftbankEmoji((String)forumPostVo.getTextField()));
                }
                if (EmojiCodeParser.hasSoftbankEmoji((String)forumPostVo.getTitle())) {
                    changed = true;
                    forumPostVo.setTitle(EmojiCodeParser.replaceSoftbankEmoji((String)forumPostVo.getTitle()));
                }
                if (EmojiCodeParser.hasSoftbankEmoji((String)forumPostVo.getUserName())) {
                    changed = true;
                    forumPostVo.setUserName(EmojiCodeParser.replaceSoftbankEmoji((String)forumPostVo.getUserName()));
                }
                if (!changed) continue;
                updateList.add(forumPostVo);
            }
            if (!CollectionUtils.isNotEmpty(updateList)) continue;
            MybatisBatchBuilder.create(ForumPostMapper.class, updateList).run(ForumPostMapper::updateByPrimaryKeySelective);
        }
        return true;
    }

    @Override
    public void doCollectForumPost(ForumPostCollectParam forumPostCollectParam) {
        NewsCollect newsCollect = new NewsCollect(forumPostCollectParam.getUserId(), forumPostCollectParam.getPostId(), Byte.valueOf((byte)3));
        this.collectService.collectNews(newsCollect, forumPostCollectParam.getPlatform(), forumPostCollectParam.getAreaCode());
    }

    @Override
    public List<ForumPostVo> getPostListByIds(String postIds) {
        List postIdList = ListUtil.convertStringToList((String)postIds);
        if (CollectionUtils.isEmpty((Collection)postIdList)) {
            return null;
        }
        List forumPostVoList = this.forumPostMapper.listPostByIds(postIdList);
        if (CollectionUtils.isNotEmpty((Collection)forumPostVoList)) {
            for (ForumPostVo forumPostVo : forumPostVoList) {
                this.forumPostStatisticService.exchangeDetailPost(forumPostVo);
                this.completeCommonPostInfo(forumPostVo, null, null, true);
                this.setIsCashAndCashRewardIsZero(forumPostVo);
            }
        }
        return forumPostVoList;
    }

    @Override
    public List<ForumPostVo> getRewardPostList() {
        String rewardList = this.redisStringAdapter.getString(RedisConfig.FORUM_POST_REWARD_LIST.copy());
        List forumPostVoList = StringUtils.isBlank((CharSequence)rewardList) ? this.forumPostMapper.getRewardPostList(Integer.valueOf(50)) : JSON.parseArray((String)rewardList, ForumPostVo.class);
        if (CollectionUtils.isNotEmpty((Collection)forumPostVoList)) {
            forumPostVoList.forEach(e -> this.forumPostStatisticService.judgeEnablePlaceholder((ForumPostVo)e, null));
        }
        return forumPostVoList;
    }

    @Override
    public Boolean getContentUpdate(Date lastRequestTime, String areaCode) {
        if (Objects.isNull(lastRequestTime)) {
            return true;
        }
        Date maxPublishTime = this.forumPostMapper.selectMaxPublishTime(areaCode);
        if (null != maxPublishTime) {
            return maxPublishTime.compareTo(lastRequestTime) > 0;
        }
        return false;
    }

    @Override
    public PageWarper<ForumPostVo> getHomePagePostList(HomePagePostParam param) {
        PageWarper forumPostWarper = new PageWarper(this.forumPostMapper.listHomePagePostList(param));
        List forumPostVoList = forumPostWarper.getList();
        if (CollectionUtils.isNotEmpty((Collection)forumPostVoList)) {
            this.fillExtInfo(forumPostVoList, param.getUserId(), param.getAreaCode(), false, (byte)0);
        }
        return forumPostWarper;
    }

    private void addRecommendTopic(ForumPostListQueryParam param, PageWarper<ForumPostVo> forumPostPage, List<ForumPostVo> postList) {
        List<Object> topicVoList = this.forumTopicService.getTopicList(param.getAreaCode());
        if (CollectionUtils.isNotEmpty(topicVoList)) {
            Integer order;
            if (topicVoList.size() > 6) {
                topicVoList = topicVoList.stream().limit(6L).collect(Collectors.toList());
            }
            if (null == (order = (Integer)this.redisHashMapAdapter.get(RedisConfig.USER_READ_RECOMMEND_TOPIC.copy(), param.getUserId() + "", Integer.class)) || (order = Integer.valueOf(order + 1)) >= topicVoList.size()) {
                order = 0;
            }
            this.redisHashMapAdapter.put(RedisConfig.USER_READ_RECOMMEND_TOPIC.copy(), param.getUserId() + "", (Object)order);
            TopicVo topic = (TopicVo)topicVoList.get(order);
            this.forumTopicService.fillTopicShareInfo(topic, param.getUserId());
            ArrayList<ForumPostVo> newPostList = new ArrayList<ForumPostVo>();
            for (int i = 0; i < postList.size(); ++i) {
                if (i == 3) {
                    ForumPostVo forumPostVo = new ForumPostVo();
                    forumPostVo.setRecommendTopicVo(topic);
                    newPostList.add(forumPostVo);
                }
                newPostList.add(postList.get(i));
            }
            forumPostPage.setList(newPostList);
        }
    }

    private void fixErrorParamWithIOS(ForumParam forumParam, BasicParam basicParam) {
        List relations;
        if (PlatformEnum.IOS.getCode() == basicParam.getPlatform() && VersionUtils.isHighVersion((String)basicParam.getCurVer(), (String)"3.0.0") >= 0 && VersionUtils.isHighVersion((String)basicParam.getCurVer(), (String)"3.1.0") < 0 && forumParam.getTopicId() != null && JudgeUtil.isPost((Long)forumParam.getTopicId()) && CollectionUtils.isNotEmpty((Collection)(relations = this.forumTopicMapper.getPostTopicRelation((List)ImmutableList.of((Object)forumParam.getTopicId()))))) {
            forumParam.setTopicId(((RelationDTO)relations.get(0)).getBid());
        }
    }

    private NewsCompleTaskDTO afterCreate(BasicParam basicParam, ForumPostVo forumPostVo) {
        if (basicParam != null) {
            this.bizLogIntegrationService.forumSuccessed(forumPostVo.getUserId(), forumPostVo.getAreaCode(), Integer.valueOf(basicParam.getPlatform()));
        }
        ((ForumPostStatisticService)SpringContextHolder.getBean(ForumPostStatisticService.class)).doAsyncAddPublishNum(forumPostVo);
        if (forumPostVo.getStatus() == 6) {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            int num = random.nextInt(5, 20);
            ((ForumPostStatisticService)SpringContextHolder.getBean(ForumPostStatisticService.class)).addPostLike(forumPostVo, num);
            ((ForumPostStatisticService)SpringContextHolder.getBean(ForumPostStatisticService.class)).addPostReply(forumPostVo);
        }
        return this.forumPostStatisticService.completeTask(forumPostVo);
    }

    private String checkPostInfo(ForumPostVo forumPostVo) {
        String result = "";
        if (forumPostVo == null) {
            result = "\u5e16\u5b50\u4e0d\u5b58\u5728";
        } else if (forumPostVo.getIsCash() == 1) {
            result = "\u73b0\u91d1\u5956\u52b1\u5185\u5bb9\u5220\u9664\u9700\u8981\u8054\u7cfb\u5ba2\u670d\u54e6";
        } else if (forumPostVo.getIsBroke() == 1) {
            result = "\u7206\u6599\u5185\u5bb9\u5220\u9664\u9700\u8981\u8054\u7cfb\u5ba2\u670d\u54e6";
        } else if (forumPostVo.getIsRecommend() == 1) {
            result = "\u4f18\u8d28\u5934\u6761\u5220\u9664\u9700\u8981\u8054\u7cfb\u5ba2\u670d\u54e6";
        } else if (forumPostVo.getIsBrilliant() == 1) {
            result = "\u7cbe\u534e\u5185\u5bb9\u5220\u9664\u9700\u8981\u8054\u7cfb\u5ba2\u670d\u54e6";
        }
        return result;
    }

    private void setIsCashAndCashRewardIsZero(ForumPostVo forumPostVo) {
        boolean flag;
        boolean bl = flag = Objects.nonNull(forumPostVo) && Objects.nonNull(forumPostVo.getIsRed()) && forumPostVo.getIsRed() == 0 && Objects.nonNull(forumPostVo.getIsCash()) && forumPostVo.getIsCash() == 1;
        if (flag) {
            forumPostVo.setIsCash(Integer.valueOf(0));
            forumPostVo.setCashReward(new BigDecimal(0));
        }
    }

    private void completePostInfo(ForumPostVo forumPostVo, Long userId, LocationDTO locationDTO) {
        if (null == forumPostVo) {
            return;
        }
        forumPostVo.setTopicList(this.forumTopicService.listTopicByPostId(forumPostVo.getId(), userId));
        if (null != userId) {
            Integer like = this.forumPostLikeMapper.getUserPostLike(forumPostVo.getId(), userId);
            forumPostVo.setLiked(Integer.valueOf(null != like && 1 == like ? 1 : 0));
            forumPostVo.setCollected(Integer.valueOf(null != this.newsCollectMapper.selectUserCollect(forumPostVo.getId(), userId, Byte.valueOf((byte)3)) ? 1 : 0));
        }
        this.forumPostStatisticService.exchangeDetailPost(forumPostVo);
        forumPostVo.setVestType(this.userIntegrationService.getVirtualUserType(forumPostVo.getUserId()));
        this.completeCommonPostInfo(forumPostVo, locationDTO, userId, true);
        this.setPluginInfo(forumPostVo, userId);
    }

    private void setPluginInfo(ForumPostVo forumPostVo, Long userId) {
        this.logger.debug("forumpost:[{}],plugins:[{}]", (Object)forumPostVo.getId(), (Object)forumPostVo.getPlugins());
        if (forumPostVo.getPlugins() != null) {
            for (ForumPlugin plugin : forumPostVo.getPlugins()) {
                if (!"VOTE".equals(plugin.getType())) continue;
                VotePinParam param = new VotePinParam();
                param.setRelationId(forumPostVo.getId());
                param.setVoteId(plugin.getId());
                param.setUserId(userId);
                forumPostVo.setVoteDetailDTO(this.voteIntegrationService.get(param));
                break;
            }
        }
    }

    private void completePostInfo(ForumPostVo forumPostVo, Long userId, LocationDTO locationDTO, List<PostTopicVO> postTopVoList, List<Long> postLikeIdList, List<Long> postCollectIdList, boolean isFillTitle, byte isInHome) {
        if (null == forumPostVo) {
            return;
        }
        forumPostVo.setPostContentImgList(forumPostVo.getPostImgList());
        if (CollectionUtils.isNotEmpty(postTopVoList)) {
            List topicVoList = postTopVoList.parallelStream().filter(e -> e.getPostId().equals(forumPostVo.getId())).collect(Collectors.toList());
            forumPostVo.setTopicList(topicVoList);
        }
        if (null != userId) {
            forumPostVo.setLiked(Integer.valueOf(postLikeIdList.parallelStream().anyMatch(e -> e.equals(forumPostVo.getId())) ? 1 : 0));
            forumPostVo.setCollected(Integer.valueOf(postCollectIdList.parallelStream().anyMatch(e -> e.equals(forumPostVo.getId())) ? 1 : 0));
        }
        forumPostVo.setLeftRelyNum(Integer.valueOf(CollectionUtils.isNotEmpty((Collection)forumPostVo.getReplyInfo()) ? forumPostVo.getCommentCount() - forumPostVo.getReplyInfo().size() : forumPostVo.getCommentCount()));
        if (isFillTitle) {
            forumPostVo.setTitle(ExtendFactory.getTitle((String)forumPostVo.getTitle(), (String)forumPostVo.getTextField()));
        }
        if (isInHome == 0) {
            this.forumPostStatisticService.exchangeDetailPost(forumPostVo);
        } else if (isInHome == 1) {
            this.forumPostStatisticService.exchangeCoverPost(forumPostVo);
        } else if (isInHome == 2) {
            this.getImCoverList(forumPostVo);
        }
        this.completeCommonPostInfo(forumPostVo, locationDTO, userId, isInHome != 2);
    }

    private void getImCoverList(ForumPostVo forumPostVo) {
        List<PostImgVo> coverFromPost = this.forumPostStatisticService.getCoverFromPost(forumPostVo.getCoverList(), forumPostVo.getPostImgList(), forumPostVo.getCoverSelect());
        forumPostVo.setPostImgList(coverFromPost);
        if (CollectionUtils.isNotEmpty(coverFromPost)) {
            forumPostVo.setShareImg(coverFromPost.get(0));
        } else {
            forumPostVo.setShareImg(PostImgVo.buildImg((String)this.newsProperties.getDefaultImShareImg()));
        }
    }

    private void completeCommonPostInfo(ForumPostVo forumPostVo, LocationDTO locationDTO, Long userId, boolean isFillNote) {
        if (StringUtils.isBlank((CharSequence)forumPostVo.getLocation())) {
            forumPostVo.setLocation(null != locationDTO ? locationDTO.getName() : null);
        }
        forumPostVo.setTextField(StringUtils.isNotBlank((CharSequence)forumPostVo.getTextField()) ? StringEscapeUtils.unescapeHtml((String)forumPostVo.getTextField()) : null);
        forumPostVo.setContent(StringUtils.isNotBlank((CharSequence)forumPostVo.getContent()) ? StringEscapeUtils.unescapeHtml((String)forumPostVo.getContent()) : null);
        forumPostVo.setDisplayTime(null != forumPostVo.getDisplayDateTime() ? DateUtils.timeConvertString((Date)forumPostVo.getDisplayDateTime()) : null);
        forumPostVo.setShareUrl(this.iUrlFactory.getAppUrl(UrlCategoryEnum.FORUM, UrlTypeEnum.SHARE, forumPostVo.getId(), userId));
        forumPostVo.setAppletShareUrl(this.iUrlFactory.getAppletUrl(UrlPositionEnum.POST, forumPostVo.getId(), userId));
        if (0 == forumPostVo.getIsBrilliant() && 0 == forumPostVo.getIsBroke() && 0 == forumPostVo.getIsCash() && 1 == forumPostVo.getIsRecommend()) {
            forumPostVo.setIsRed(Integer.valueOf(1));
        }
        if (PostTypeEnum.NOTE.getCode() == forumPostVo.getPostType().byteValue()) {
            if (isFillNote) {
                forumPostVo.setTitle("\u6211\u53d1\u5e03\u4e86\u4e00\u4e2a\u7eb8\u6761");
            }
            forumPostVo.setShareImg(PostImgVo.buildImg((String)this.forumProperties.getNoteShareImg()));
        }
    }

    private Long generateForumPostLike(ForumPostLike postLike, int type, Long postId, Long userId, UserBean userBean) {
        long id;
        String updateNickname;
        String updateHeadImg = StringUtils.isBlank((CharSequence)userBean.getHeadImg()) ? this.userProperties.getDefaultHeadImgUrl() : userBean.getHeadImg();
        String string = updateNickname = StringUtils.isBlank((CharSequence)userBean.getNickname()) ? null : userBean.getNickname();
        if (Objects.isNull(postLike)) {
            id = this.nextId();
            ForumPostLike forumPostLike = ForumPostLike.buildPostLike((Long)postId, (Long)userId);
            forumPostLike.setId(Long.valueOf(id));
            forumPostLike.setType(Byte.valueOf((byte)type));
            forumPostLike.setHeadImg(updateHeadImg);
            forumPostLike.setUserNickname(updateNickname);
            this.forumPostLikeMapper.insertSelective(forumPostLike);
        } else {
            id = postLike.getId();
            postLike.setType(Byte.valueOf((byte)type));
            postLike.setHeadImg(updateHeadImg);
            postLike.setUserNickname(updateNickname);
            this.forumPostLikeMapper.updateByPrimaryKeySelective(postLike);
        }
        return id;
    }

    private ForumParam generateForumParam(Integer size, Long postId, Long userId, String areaCode, Integer platform) {
        if (null == size) {
            size = 5;
        }
        ForumParam forumParam = new ForumParam();
        forumParam.setOperationId(Integer.valueOf(7));
        forumParam.setPostId(postId);
        forumParam.setUserId(userId);
        forumParam.setAreaCode(areaCode);
        forumParam.setPlatform(platform);
        if (size == 5) {
            forumParam.setPostNum(Integer.valueOf(3));
            forumParam.setNewsNum(Integer.valueOf(2));
        } else if (size == 15) {
            forumParam.setPostNum(Integer.valueOf(10));
            forumParam.setNewsNum(Integer.valueOf(5));
        }
        return forumParam;
    }

    private PostLikeDto calculateFlower(ForumPostVo postVo, Long userId, Long id, String areaCode, int platform) {
        int postLikeConsume = this.forumPostStatisticService.getPostLikeConsume(postVo.getIsBrilliant());
        LocationDTO location = this.locationIntegrationService.getLocationByGeocode(areaCode);
        this.forumPostStatisticService.judgeEnablePlaceholder(postVo, location);
        String consumeContent = "\u70b9\u8d5e\u3010" + ExtendFactory.getPostContent((String)postVo.getTitle(), (String)postVo.getTextField()) + "\u3011 \u6d88\u8017\u5c0f\u7ea2\u82b1";
        Boolean consume = this.userAccountIntegrationService.addGold(AccountGoldParam.buildPostLikeExpendParam((Long)userId, (int)postLikeConsume, (Long)id, (String)consumeContent));
        PostLikeDto postLikeDto = new PostLikeDto();
        if (consume.booleanValue()) {
            String addContent = "\u4f60\u53d1\u5e03\u7684\u3010" + ExtendFactory.getPostContent((String)postVo.getTitle(), (String)postVo.getTextField()) + "\u3011\u88ab\u8d5e";
            this.userAccountIntegrationService.addGold(AccountGoldParam.buildPostLikeAddParam((Long)postVo.getUserId(), (int)postLikeConsume, (Long)id, (String)addContent));
            postLikeDto.setAmount(Integer.valueOf(postLikeConsume));
            postLikeDto.setCode(Integer.valueOf(1));
            this.forumPostStatisticService.fillPostLikeDto(postLikeDto, userId, postVo.getUserId(), postLikeConsume);
            ((ForumPostStatisticService)SpringContextHolder.getBean(ForumPostStatisticService.class)).doAsyncLikePost(userId, postVo.getId(), 1, areaCode, (byte)0, platform);
        } else {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            postLikeDto.setCode(Integer.valueOf(0));
            postLikeDto.setShowFlower(Integer.valueOf(0));
            postLikeDto.setCopyWriter("\u4f60\u7684\u5c0f\u7ea2\u82b1\u4f59\u989d\u4e0d\u8db3\uff0c\u5feb\u8f6c\u53d1\u6587\u7ae0\u8d5a\u5c0f\u7ea2\u82b1");
        }
        return postLikeDto;
    }

    private Long getPostId() {
        KeyGenerator postKeyGenerator = RedisConfig.SEQ_POST_ID.copy();
        return this.redisStringAdapter.incrementWithDefault(postKeyGenerator, 4000000000000000L, 1);
    }
}

