/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.integration.BizLogIntegrationService;
import com.bxm.localnews.integration.LocationIntegrationService;
import com.bxm.localnews.integration.MessageIntegrationService;
import com.bxm.localnews.integration.MissionIntegrationService;
import com.bxm.localnews.integration.UserAccountIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.news.config.ClientConfigProperties;
import com.bxm.localnews.news.config.NewsProperties;
import com.bxm.localnews.news.config.ReplyConfigProperties;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.ForumPostLikeMapper;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.domain.ForumPostRecordMapper;
import com.bxm.localnews.news.domain.ForumTopicMapper;
import com.bxm.localnews.news.domain.NewsReplyMapper;
import com.bxm.localnews.news.domain.UserReplyMapper;
import com.bxm.localnews.news.dto.CalculatePostDTO;
import com.bxm.localnews.news.dto.NewsCompleTaskDTO;
import com.bxm.localnews.news.dto.PostLikeDto;
import com.bxm.localnews.news.enums.ReplyTypeEnum;
import com.bxm.localnews.news.enums.TaskEnum;
import com.bxm.localnews.news.factory.impl.ExtendFactory;
import com.bxm.localnews.news.service.AssemblyService;
import com.bxm.localnews.news.service.ForumPostStatisticService;
import com.bxm.localnews.news.service.NewsService;
import com.bxm.localnews.news.vo.ForumPostLike;
import com.bxm.localnews.news.vo.ForumPostRecord;
import com.bxm.localnews.news.vo.ForumPostStatistic;
import com.bxm.localnews.news.vo.ForumPostVo;
import com.bxm.localnews.news.vo.NewsReply;
import com.bxm.localnews.news.vo.PostCount;
import com.bxm.localnews.news.vo.PostImgVo;
import com.bxm.localnews.news.vo.TopicVo;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.localnews.news.vo.UserReply;
import com.bxm.localnews.param.AccountGoldParam;
import com.bxm.localnews.vo.VirtualUserInfo;
import com.bxm.newidea.component.redis.HyperLogLogAdapter;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.IPUtil;
import com.bxm.newidea.component.tools.RandomUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ForumPostStatisticServiceImpl
extends BaseService
implements ForumPostStatisticService {
    @Resource
    private ForumTopicMapper forumTopicMapper;
    @Resource
    private NewsReplyMapper newsReplyMapper;
    @Resource
    private UserReplyMapper userReplyMapper;
    @Resource
    private ForumPostRecordMapper forumPostRecordMapper;
    @Resource
    private ForumPostLikeMapper forumPostLikeMapper;
    @Resource
    private ForumPostMapper forumPostMapper;
    @Resource
    private UserIntegrationService userIntegrationService;
    @Resource
    private UserAccountIntegrationService userAccountIntegrationService;
    @Resource
    private LocationIntegrationService locationIntegrationService;
    @Resource
    private MissionIntegrationService missionIntegrationService;
    @Resource
    private MessageIntegrationService messageIntegrationService;
    @Resource
    private BizLogIntegrationService bizLogIntegrationService;
    @Resource
    private ClientConfigProperties clientConfigProperties;
    @Resource
    private NewsProperties newsProperties;
    @Resource
    private ReplyConfigProperties replyConfigProperties;
    @Resource
    private RedisStringAdapter redisStringAdapter;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;
    @Resource
    private AssemblyService assemblyService;
    @Resource
    private HyperLogLogAdapter hyperLogLogAdapter;

    @Override
    public void doUpdateForumInfo(int type, Long postId) {
        ForumPostStatistic forumPostStatistic = new ForumPostStatistic();
        forumPostStatistic.setId(postId);
        forumPostStatistic.setLikeCount(Integer.valueOf(type == 0 ? -1 : 1));
        List forumPostLikes = this.forumPostLikeMapper.selectByPostIdAndOrderByAddtime(postId);
        if (CollectionUtils.isNotEmpty((Collection)forumPostLikes)) {
            forumPostStatistic.setLikeInfo(JSONObject.toJSONString((Object)forumPostLikes));
        }
        this.forumPostMapper.updateStatisticByPrimaryKeySelective(forumPostStatistic);
    }

    @Override
    public int doRefreshLikeInfo() {
        List postLikes = this.forumPostLikeMapper.selectNotShowPostLike();
        postLikes.forEach(e -> {
            e.setIsShow(Byte.valueOf((byte)1));
            this.forumPostLikeMapper.updateByPrimaryKeySelective(e);
            this.doUpdateForumInfo(1, e.getPostId());
        });
        ((ForumPostStatisticService)SpringContextHolder.getBean(ForumPostStatisticService.class)).asyncSendPostLikeMessage(postLikes);
        return CollectionUtils.isEmpty((Collection)postLikes) ? 0 : postLikes.size();
    }

    @Override
    @Async
    public void asyncSendPostLikeMessage(List<ForumPostLike> postLikes) {
        if (CollectionUtils.isNotEmpty(postLikes)) {
            postLikes.forEach(e -> {
                boolean flag;
                ForumPostVo postVo = this.forumPostMapper.selectByPrimaryKey(e.getPostId());
                this.userIntegrationService.updateUserLikeNumByUserId(postVo.getUserId());
                int postLikeConsume = this.getPostLikeConsume(postVo.getIsBrilliant());
                boolean bl = flag = postVo.getStatus() != 4;
                if (flag) {
                    String addContent = "\u4f60\u53d1\u5e03\u7684\u3010" + ExtendFactory.getPostContent((String)postVo.getTitle(), (String)postVo.getTextField()) + "\u3011\u88ab\u8d5e";
                    AccountGoldParam usableParam = AccountGoldParam.buildPostLikeAddParam((Long)postVo.getUserId(), (int)postLikeConsume, (Long)e.getId(), (String)addContent);
                    this.userAccountIntegrationService.addGold(usableParam);
                    this.doAsyncLikePost(e.getUserId(), e.getPostId(), 1, postVo.getAreaCode(), (byte)1, null);
                }
            });
        }
    }

    @Override
    public int getPostLikeConsume(Integer isBrilliant) {
        if (Objects.isNull(isBrilliant) || isBrilliant == 0) {
            return this.clientConfigProperties.getPostCommonLikeConsume();
        }
        return this.clientConfigProperties.getPostBrilliantLikeConsume();
    }

    @Override
    @Async
    public void doAsyncLikePost(Long userId, Long postId, int type, String areaCode, byte isOld, Integer platform) {
        if (1 == type) {
            ForumPostVo forumPostVo = this.forumPostMapper.selectByPrimaryKey(postId);
            this.generateVirtualLike(forumPostVo, isOld);
            if (Objects.nonNull(platform)) {
                this.bizLogIntegrationService.forumLikeSuccessed(userId, postId, areaCode, platform);
            } else {
                isOld = 0;
            }
            this.judgeEnablePlaceholder(forumPostVo, null);
            this.exchangeDetailPost(forumPostVo);
            this.messageIntegrationService.pushPostLikeMessage(forumPostVo, userId, (int)isOld, this.getPostLikeConsume(forumPostVo.getIsBrilliant()));
        }
    }

    @Override
    public void fillPostLikeDto(PostLikeDto postLikeDto, Long userId, Long authorUserId, int postLikeConsume) {
        String dateKey = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd");
        KeyGenerator forumPostLikeTimeKey = RedisConfig.FORUMPOST_LIEK_TIME.copy().appendKey((Object)dateKey).appendKey((Object)userId);
        long likeCount = this.redisStringAdapter.incrementWithDefault(forumPostLikeTimeKey, 1L, 1, 86400L);
        if (likeCount <= 2L) {
            postLikeDto.setCopyWriter("\u5df2\u8d5e\u8d4f\u697c\u4e3b" + postLikeConsume + "\u6735\u5c0f\u7ea2\u82b1");
            postLikeDto.setShowFlower(Integer.valueOf(1));
        } else {
            postLikeDto.setCopyWriter(null);
            postLikeDto.setShowFlower(Integer.valueOf(0));
        }
    }

    @Override
    public Boolean judgeEnablePlaceholder(ForumPostVo postVo, LocationDTO location) {
        boolean flag;
        boolean bl = flag = Objects.nonNull(postVo) && Objects.nonNull(postVo.getEnablePlaceholder()) && postVo.getEnablePlaceholder() == 1;
        if (flag) {
            boolean titleFlag = StringUtils.isNotBlank((String)postVo.getTitle());
            if (Objects.isNull(location) || StringUtils.isBlank((String)location.getName())) {
                if (titleFlag) {
                    postVo.setTitle(postVo.getTitle().replace("{areaname}", "\u672c\u5730"));
                }
                if (StringUtils.isNotBlank((String)postVo.getContent())) {
                    postVo.setContent(postVo.getContent().replace("{areaname}", "\u672c\u5730"));
                }
                postVo.setTextField(StringUtils.isNotBlank((String)postVo.getTextField()) ? postVo.getTextField().replace("{areaname}", "\u672c\u5730") : postVo.getTextField());
            } else {
                if (titleFlag) {
                    postVo.setTitle(postVo.getTitle().replace("{areaname}", location.getName()));
                }
                if (StringUtils.isNotBlank((String)postVo.getContent())) {
                    postVo.setContent(postVo.getContent().replace("{areaname}", location.getName()));
                }
                postVo.setTextField(StringUtils.isNotBlank((String)postVo.getTextField()) ? postVo.getTextField().replace("{areaname}", location.getName()) : postVo.getTextField());
            }
        }
        return flag;
    }

    @Override
    @Async
    public void doAsyncReadPost(Long userId, Long postId, Long shareUserId, Integer platform, ForumPostVo forumPostVo, String ip) {
        this.doRecordForumPost(userId, postId, shareUserId, platform, forumPostVo);
        if (null != shareUserId && shareUserId != 0L && PlatformEnum.APPLET.getCode() == platform.intValue() && !shareUserId.equals(userId)) {
            String content = "\u8f6c\u53d1\u3010" + ExtendFactory.getPostContent((String)forumPostVo.getTitle(), (String)forumPostVo.getTextField()) + "\u3011\u88ab\u9605\u8bfb";
            NewsCompleTaskDTO firstBrowse = this.missionIntegrationService.compleTask(shareUserId, TaskEnum.TASK_FIRST_BROWSE.name(), userId.toString(), content);
            this.logger.info("\u7528\u6237={}\u5728\u5c0f\u7a0b\u5e8f\u4e2d\u6253\u5f00\u5e16\u5b50,\u65b0\u95fbid={},\u5206\u4eab\u4eba\u7684shareUserId={},\u5b8c\u6210\u4efb\u52a1\u63a5\u53e3\u8fd4\u56de={}", new Object[]{userId, forumPostVo.getId(), shareUserId, JSONObject.toJSONString((Object)firstBrowse)});
            if (Objects.nonNull(firstBrowse) && firstBrowse.getGoldNum() > 0L) {
                String extendUrl;
                String extendContent = null;
                List<PostImgVo> imgList = this.getDetailFromPost(forumPostVo.getPostImgList());
                String string = extendUrl = CollectionUtils.isNotEmpty(imgList) ? null : imgList.get(0).getImgUrl();
                if (StringUtils.isEmpty(extendUrl)) {
                    extendContent = ExtendFactory.getTitle((String)forumPostVo.getTitle(), (String)forumPostVo.getTextField());
                }
                this.messageIntegrationService.addMessage(shareUserId, userId, firstBrowse, forumPostVo.getId(), Byte.valueOf(ReplyTypeEnum.POST_REPLY.getCode()), extendUrl, extendContent, forumPostVo.getTitle());
            }
        }
        if (null != platform && PlatformEnum.WEB.getCode() == platform.intValue() && 2 == forumPostVo.getStatus()) {
            KeyGenerator keyGenerator = RedisConfig.FORUM_RECORD_FROM_H5.copy().appendKey((Object)postId);
            long ipNum = StringUtils.isNotBlank((String)ip) ? IPUtil.ip2long((String)ip) : RandomUtils.nextLong();
            this.hyperLogLogAdapter.add(keyGenerator, (Object[])new Long[]{ipNum});
        }
    }

    @Override
    public void exchangeCoverPost(ForumPostVo forumPostVo) {
        List<PostImgVo> coverFromPost = this.getCoverFromPost(forumPostVo.getCoverList(), forumPostVo.getPostImgList(), forumPostVo.getCoverSelect());
        forumPostVo.setPostImgList(coverFromPost);
        if (CollectionUtils.isNotEmpty(coverFromPost)) {
            forumPostVo.setShareImg(coverFromPost.get(0));
        } else {
            forumPostVo.setShareImg(PostImgVo.buildImg((String)this.newsProperties.getDefaultShareCover()));
        }
    }

    @Override
    public void exchangeDetailPost(ForumPostVo forumPostVo) {
        forumPostVo.setShareImg(this.getShareImg(forumPostVo));
        forumPostVo.setPostImgList(this.getDetailFromPost(forumPostVo.getPostImgList()));
    }

    @Override
    public List<PostImgVo> getDetailFromPost(List<PostImgVo> imgList) {
        ArrayList coverList = new ArrayList();
        ArrayList<PostImgVo> videoCoverTempList = new ArrayList<PostImgVo>();
        ArrayList<PostImgVo> imgCoverTempList = new ArrayList<PostImgVo>();
        if (CollectionUtils.isNotEmpty(imgList)) {
            for (PostImgVo postImgVo : imgList) {
                if (StringUtils.isBlank((String)postImgVo.getType()) || StringUtils.isBlank((String)postImgVo.getImgUrl())) continue;
                if ("VIDEO".equals(postImgVo.getType())) {
                    postImgVo.setImgUrl(this.assemblyService.buildVideoCover(postImgVo.getImgUrl()));
                    videoCoverTempList.add(postImgVo);
                    continue;
                }
                if (!"IMG".equals(postImgVo.getType())) continue;
                postImgVo.setImgUrl(this.assemblyService.buildImgCover(postImgVo.getImgUrl()));
                imgCoverTempList.add(postImgVo);
            }
        }
        if (CollectionUtils.isNotEmpty(videoCoverTempList)) {
            coverList.addAll(videoCoverTempList);
        }
        if (CollectionUtils.isNotEmpty(imgCoverTempList)) {
            coverList.addAll(imgCoverTempList);
        }
        return coverList.stream().limit(9L).collect(Collectors.toList());
    }

    @Override
    public List<PostImgVo> getCoverFromPost(String coverStr, List<PostImgVo> imgList, Byte coverSelect) {
        List<Object> coverArray = new ArrayList();
        Integer videoSize = 1;
        Integer imageSize = 3;
        if (coverSelect == 0) {
            coverArray = ((NewsService)SpringContextHolder.getBean(NewsService.class)).getCoverByCoverStr(coverStr);
            if (CollectionUtils.isEmpty(coverArray)) {
                coverArray = this.getCoverByVideo(imgList, videoSize);
            }
            if (CollectionUtils.isEmpty(coverArray)) {
                coverArray = this.getCoverByImgUrl(imgList, imageSize);
            }
        } else if (coverSelect == 1) {
            coverArray = this.getCoverByVideo(imgList, videoSize);
            if (CollectionUtils.isEmpty(coverArray)) {
                coverArray = this.getCoverByImgUrl(imgList, imageSize);
            }
        } else if (coverSelect == 2 && (coverArray = this.getCoverByVideo(imgList, videoSize = Integer.valueOf(3))).size() < videoSize) {
            imageSize = videoSize - coverArray.size();
            List<PostImgVo> coverByImgUrl = this.getCoverByImgUrl(imgList, imageSize);
            coverArray.addAll(coverByImgUrl);
        }
        return coverArray;
    }

    private List<PostImgVo> getCoverByImgUrl(List<PostImgVo> imgList, Integer size) {
        ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(imgList)) {
            for (PostImgVo postImgVo : imgList) {
                if (StringUtils.isBlank((String)postImgVo.getType()) || StringUtils.isBlank((String)postImgVo.getImgUrl())) continue;
                if ("IMG".equals(postImgVo.getType())) {
                    postImgVo.setImgUrl(this.assemblyService.buildImgCover(postImgVo.getImgUrl()));
                    result.add(postImgVo);
                }
                if (result.size() < size) continue;
                break;
            }
        }
        return result;
    }

    private List<PostImgVo> getCoverByVideo(List<PostImgVo> videoList, Integer size) {
        ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(videoList)) {
            for (PostImgVo postImgVo : videoList) {
                if (StringUtils.isBlank((String)postImgVo.getType()) || StringUtils.isBlank((String)postImgVo.getImgUrl())) continue;
                if ("VIDEO".equals(postImgVo.getType())) {
                    postImgVo.setImgUrl(this.assemblyService.buildVideoCover(postImgVo.getImgUrl()));
                    result.add(postImgVo);
                }
                if (result.size() < size) continue;
                break;
            }
        }
        return result;
    }

    @Override
    public void doConsumeRecommendedCount(List<Long> ids, Long userId) {
        List forumPostStatisticList = ids.stream().map(id -> ForumPostStatistic.buildRecommend((Long)id, (Integer)1)).collect(Collectors.toList());
        MybatisBatchBuilder.create(ForumPostMapper.class, forumPostStatisticList).run(ForumPostMapper::updateStatisticByPrimaryKeySelective);
    }

    @Override
    public void doConsumeClickCount(Long postId, Long userId) {
        ForumPostStatistic forumPostStatistic = new ForumPostStatistic();
        forumPostStatistic.setClickCount(Integer.valueOf(1));
        forumPostStatistic.setId(postId);
        this.forumPostMapper.updateStatisticByPrimaryKeySelective(forumPostStatistic);
    }

    @Override
    public void doConsumeActiveViewCount(Long postId, Long userId) {
        ForumPostStatistic forumPostStatistic = new ForumPostStatistic();
        forumPostStatistic.setReviewCount(Integer.valueOf(1));
        forumPostStatistic.setId(postId);
        this.forumPostMapper.updateStatisticByPrimaryKeySelective(forumPostStatistic);
    }

    @Override
    public void doSyncPostLikeInfo() {
        List list = this.forumPostLikeMapper.selectNotExitsUserInfo();
        ArrayList paramList = Lists.newArrayList();
        list.forEach(e -> {
            ForumPostLike postLike = new ForumPostLike();
            postLike.setUserId(e);
            UserBean userInfo = this.userIntegrationService.selectUserFromCache(e);
            if (Objects.nonNull(userInfo)) {
                postLike.setUserNickname(userInfo.getNickname());
                postLike.setHeadImg(userInfo.getHeadImg());
                paramList.add(postLike);
            }
        });
        MybatisBatchBuilder.create(ForumPostLikeMapper.class, (Collection)paramList).run(ForumPostLikeMapper::updateUserInfoByUserId);
    }

    @Override
    public void doSyncPostStaticInfo() {
        List list = this.forumPostMapper.selectNotExitReplyAndLikeInfo();
        ArrayList paramList = Lists.newArrayList();
        list.forEach(e -> {
            boolean flag;
            List forumPostLikes;
            ForumPostStatistic forumPostStatistic = new ForumPostStatistic();
            forumPostStatistic.setId(e);
            List replyList = this.newsReplyMapper.selectPostReplyByNewsIdOrderByAddTime(e);
            if (CollectionUtils.isNotEmpty((Collection)replyList)) {
                forumPostStatistic.setReplyInfo(JSONObject.toJSONString((Object)replyList));
            }
            if (CollectionUtils.isNotEmpty((Collection)(forumPostLikes = this.forumPostLikeMapper.selectByPostIdAndOrderByAddtime(e)))) {
                forumPostStatistic.setLikeInfo(JSONObject.toJSONString((Object)forumPostLikes));
            }
            boolean bl = flag = !StringUtils.isBlank((String)forumPostStatistic.getLikeInfo()) || !StringUtils.isBlank((String)forumPostStatistic.getReplyInfo());
            if (flag) {
                paramList.add(forumPostStatistic);
            }
        });
        MybatisBatchBuilder.create(ForumPostMapper.class, (Collection)paramList).run(ForumPostMapper::updateStatisticByPrimaryKeySelective);
    }

    @Override
    public List<CalculatePostDTO> calculatePostCount() {
        ArrayList result = Lists.newArrayList();
        List newPostCount = this.forumPostMapper.selectNewPostCount();
        List unreviewedCounts = this.forumPostMapper.selectPendingReviewCount();
        newPostCount.forEach(e -> {
            CalculatePostDTO calculatePostDTO = new CalculatePostDTO();
            if (StringUtils.isNotBlank((String)e.getAreaCode())) {
                LocationDTO location = this.locationIntegrationService.getLocationByGeocode(e.getAreaCode());
                calculatePostDTO.setAreaName(location.getName());
                calculatePostDTO.setAreaCode(e.getAreaCode());
            } else {
                calculatePostDTO.setAreaName("\u5176\u4ed6\u5730\u533a");
                calculatePostDTO.setAreaCode("");
            }
            calculatePostDTO.setNewPostCount(e.getNum());
            Integer unReviewed = unreviewedCounts.stream().filter(k -> StringUtils.equalsIgnoreCase((String)e.getAreaCode(), (String)k.getAreaCode())).findFirst().map(PostCount::getNum).orElse(0);
            calculatePostDTO.setPendingReviewCount(unReviewed);
            int userCount = this.forumPostMapper.selectUserCount(e.getAreaCode());
            calculatePostDTO.setUserCount(Integer.valueOf(userCount));
            result.add(calculatePostDTO);
        });
        return result;
    }

    @Override
    public void calcParticipantsNum() {
        this.logger.info("calculate participants num start. ");
        this.calcAllParticipantsNum();
        this.calcAreaParticipantsNum();
        this.redisHashMapAdapter.remove(RedisConfig.TOPIC.copy());
        this.logger.info("calculate participants num end. ");
    }

    private void calcAllParticipantsNum() {
        List topicVoList = this.forumTopicMapper.getTopicList(null, null);
        if (CollectionUtils.isNotEmpty((Collection)topicVoList)) {
            for (TopicVo topicVo : topicVoList) {
                Integer participantsNum = this.getParticipantsNum(null, topicVo.getId(), null);
                this.forumTopicMapper.updateTopic(topicVo.getId(), participantsNum);
            }
        }
    }

    private void calcAreaParticipantsNum() {
        List areaRelationVoList = this.forumTopicMapper.getAreaRelationList();
        if (CollectionUtils.isNotEmpty((Collection)areaRelationVoList)) {
            areaRelationVoList.stream().filter(e -> null != e.getType() && null != e.getRelationId() && StringUtils.isNotBlank((String)e.getAreaCode())).forEach(e -> {
                if (2 == e.getType()) {
                    Integer participantsNum = this.getParticipantsNum(null, e.getRelationId(), e.getAreaCode());
                    this.forumTopicMapper.updateAreaParticipantsNum(e.getId(), participantsNum);
                }
            });
        }
    }

    private Integer getParticipantsNum(Long forumId, Long topicId, String areaCode) {
        List postIdList;
        Integer participantsNum = this.forumPostMapper.calcPostNum(forumId, topicId, areaCode);
        if (null == participantsNum) {
            participantsNum = 0;
        }
        if (CollectionUtils.isNotEmpty((Collection)(postIdList = this.forumPostMapper.getPostIdList(forumId, topicId, areaCode)))) {
            for (Long postId : postIdList) {
                Integer replyNum = this.newsReplyMapper.calcReplyNum(postId);
                if (replyNum == null) continue;
                participantsNum = participantsNum + replyNum;
            }
        }
        return participantsNum;
    }

    @Override
    public NewsCompleTaskDTO completeTask(ForumPostVo forumPostVo) {
        Long userId = forumPostVo.getUserId();
        Long postId = forumPostVo.getId();
        String content = "\u9996\u6b21\u53d1\u5e03\u3010" + ExtendFactory.getPostContent((String)forumPostVo.getTitle(), (String)forumPostVo.getTextField()) + "\u3011";
        NewsCompleTaskDTO newsCompleTaskDTO = this.missionIntegrationService.compleTask(userId, TaskEnum.TASK_FIRST_POST_INTIVATION.name(), postId.toString(), content);
        if (null == newsCompleTaskDTO || null == newsCompleTaskDTO.getGoldNum() || 0L == newsCompleTaskDTO.getGoldNum()) {
            content = "\u53d1\u5e03\u3010" + ExtendFactory.getPostContent((String)forumPostVo.getTitle(), (String)forumPostVo.getTextField()) + "\u3011";
            newsCompleTaskDTO = this.missionIntegrationService.compleTask(userId, TaskEnum.TASK_POST_INTIVATION.name(), postId.toString(), content);
        }
        return newsCompleTaskDTO;
    }

    @Override
    @Async
    public void addPostLike(ForumPostVo forumPostVo, Integer num) {
        List virtualUserList = this.userIntegrationService.getVirtualUserList(Integer.valueOf(num * 2));
        ArrayList list = Lists.newArrayList();
        for (VirtualUserInfo virtualUser : virtualUserList) {
            ForumPostLike like = this.forumPostLikeMapper.selectByUserIdAndPostId(virtualUser.getId(), forumPostVo.getId());
            if (Objects.isNull(like)) {
                Calendar calendar = Calendar.getInstance();
                int amount = (int)(1.0 + Math.random() * 120.0);
                calendar.add(12, amount);
                ForumPostLike postLike = ForumPostLike.builder().addTime(calendar.getTime()).headImg(virtualUser.getHeadImg()).id(Long.valueOf(this.nextId())).isShow(Byte.valueOf((byte)0)).isVest(Byte.valueOf((byte)1)).postId(forumPostVo.getId()).type(Byte.valueOf((byte)1)).userId(virtualUser.getId()).userNickname(virtualUser.getNickname()).build();
                list.add(postLike);
            }
            if (list.size() < num) continue;
            break;
        }
        MybatisBatchBuilder.create(ForumPostLikeMapper.class, (Collection)list).run(ForumPostLikeMapper::insertSelective);
    }

    @Override
    @Async
    public void addPostReply(ForumPostVo forumPostVo) {
        int size = 5;
        List list = this.newsReplyMapper.selectRandomReplyLibrary(this.replyConfigProperties.getNewReportId(), 5);
        List userList = this.userIntegrationService.getVirtualUserList(Integer.valueOf(5));
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        int i = 0;
        for (String replyContent : list) {
            int nextTime = ThreadLocalRandom.current().nextInt(300000);
            VirtualUserInfo virtualUser = (VirtualUserInfo)userList.get(i);
            NewsReply newsReply = new NewsReply();
            newsReply.setAddTime(new Date(System.currentTimeMillis() + (long)nextTime));
            newsReply.setDeleteFlag((byte)0);
            newsReply.setHeadImg(virtualUser.getHeadImg());
            newsReply.setId(this.nextSequence());
            newsReply.setLevel(Byte.valueOf((byte)0));
            newsReply.setLikeCount(Integer.valueOf(0));
            newsReply.setNewsId(forumPostVo.getId());
            newsReply.setReplyContent(replyContent);
            newsReply.setType(Byte.valueOf((byte)3));
            newsReply.setParentId(Long.valueOf(0L));
            newsReply.setStatus(Byte.valueOf((byte)0));
            newsReply.setUserId(virtualUser.getId());
            newsReply.setUserNickname(virtualUser.getNickname());
            newsReply.setInteractiveCount(Integer.valueOf(0));
            newsReply.setRootId(Long.valueOf(0L));
            this.newsReplyMapper.insertSelective(newsReply);
            UserReply userReply = new UserReply();
            BeanUtils.copyProperties((Object)newsReply, (Object)userReply);
            this.userReplyMapper.insertSelective(userReply);
            ++i;
        }
    }

    @Override
    public void doRecordForumPost(Long userId, Long postId, Long shareUserId, Integer platform, ForumPostVo forumPostVo) {
        ForumPostRecord pRecord = this.forumPostRecordMapper.selectByIds(postId, userId, null);
        Date d = new Date();
        if (pRecord != null) {
            pRecord.setUpdateTime(d);
            this.forumPostRecordMapper.updateByPrimaryKeySelective(pRecord);
        } else {
            ForumPostRecord nr = new ForumPostRecord();
            nr.setId(this.nextSequence());
            nr.setPostId(postId);
            nr.setUserId(userId);
            nr.setUpdateTime(d);
            nr.setCheckTime(Integer.valueOf(0));
            nr.setGetGold(Byte.valueOf((byte)1));
            nr.setAddTime(d);
            nr.setLastLocation("1");
            nr.setAdViewType(Byte.valueOf((byte)1));
            this.forumPostRecordMapper.insertSelective(nr);
        }
        this.doConsumeClickCount(postId, userId);
    }

    @Override
    @Async
    public void doAsyncAddPublishNum(ForumPostVo forumPostVo) {
        try {
            this.userIntegrationService.addPostReplyNum(forumPostVo.getUserId(), Integer.valueOf(1));
        }
        catch (Exception e) {
            this.logger.debug("\u65b0\u589e\u5e16\u5b50\u8c03\u7528\u589e\u52a0\u53d1\u5e03\u6570\u670d\u52a1\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    @Override
    @Async
    public void doTriggerUpdateInfo(Long userId, String nickname, String headImg) {
        List forumPostVoList = this.forumPostMapper.selectForumPostByUser(userId);
        for (ForumPostVo forumPostVo : forumPostVoList) {
            this.forumPostMapper.updateUserInfo(forumPostVo.getId(), userId, headImg, nickname);
        }
    }

    @Override
    @Async
    public void doTriggerUpdateForumPostLikeInfo(Long userId, String nickname, String headImg) {
        if (StringUtils.isBlank((String)nickname) && StringUtils.isBlank((String)headImg)) {
            return;
        }
        this.forumPostLikeMapper.updateNickNameAndHeadImgByUserId(userId, nickname, headImg);
    }

    @Override
    public void generateForumPostContent(ForumPostVo forumPostVo, BasicParam basicParam, String ip, Long userId, String areaCode) {
        if (StringUtils.isNotEmpty((String)forumPostVo.getContent())) {
            if (StringUtils.isNotBlank((String)forumPostVo.getEditorMessage())) {
                forumPostVo.setContent(forumPostVo.getContent() + forumPostVo.getEditorMessage());
            }
            if (StringUtils.isNotBlank((String)forumPostVo.getForumContent())) {
                forumPostVo.setContent(forumPostVo.getContent() + forumPostVo.getForumContent());
            }
            if (StringUtils.equals((String)"1", (String)basicParam.getDevcId()) || PlatformEnum.APPLET.getCode() == basicParam.getPlatform() || PlatformEnum.WEB.getCode() == basicParam.getPlatform()) {
                forumPostVo.setContent(this.assemblyService.fixContent(forumPostVo.getContent(), basicParam, ip, ReplyTypeEnum.POST_REPLY.getCode(), userId, areaCode, forumPostVo.getId()));
            } else {
                String content = this.assemblyService.assemblyContent(forumPostVo.getContent(), basicParam, ip, ReplyTypeEnum.POST_REPLY.getCode(), userId, areaCode, forumPostVo.getId());
                forumPostVo.setContent(content);
            }
        }
    }

    private void generateVirtualLike(ForumPostVo forumPostVo, int isOld) {
        if (isOld != 0) {
            return;
        }
        List virtualUserList = this.userIntegrationService.getVirtualUserList(Integer.valueOf(20));
        if (CollectionUtils.isEmpty((Collection)virtualUserList)) {
            return;
        }
        for (VirtualUserInfo virtualUserInfo : virtualUserList) {
            ForumPostLike like = this.forumPostLikeMapper.selectByUserIdAndPostId(virtualUserInfo.getId(), forumPostVo.getId());
            if (!Objects.isNull(like)) continue;
            Calendar calendar = Calendar.getInstance();
            calendar.add(12, 3);
            ForumPostLike postLike = ForumPostLike.buildVestPostLike((Long)this.nextId(), (Long)forumPostVo.getId(), (Long)virtualUserInfo.getId());
            postLike.setAddTime(calendar.getTime());
            postLike.setHeadImg(virtualUserInfo.getHeadImg());
            postLike.setUserNickname(virtualUserInfo.getNickname());
            this.forumPostLikeMapper.insertSelective(postLike);
            this.logger.info("\u6dfb\u52a0\u9a6c\u7532\u70b9\u8d5e\u6210\u529f,\u70b9\u8d5e\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)postLike));
            break;
        }
    }

    private PostImgVo getShareImg(ForumPostVo forumPostVo) {
        List<PostImgVo> coverFromPost = this.getCoverFromPost(forumPostVo.getCoverList(), forumPostVo.getPostImgList(), forumPostVo.getCoverSelect());
        if (CollectionUtils.isNotEmpty(coverFromPost)) {
            return coverFromPost.get(0);
        }
        return PostImgVo.buildImg((String)this.newsProperties.getDefaultShareCover());
    }
}

